/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.model;

import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.Plausibility;

public final class VariableInstanceValuesValidator
implements IVarValueValidator {
    private final ValuesBounds bounds;
    private final MeasuringUnit resultMU;

    public VariableInstanceValuesValidator(VariableInstance instance) {
        this.bounds = instance.getResultValuesBounds();
        this.resultMU = instance.getVariable().getMeasuringUnit();
    }

    public IVarValue validate(IVarValue value) {
        if (value == null) {
            return value;
        }
        if (this.bounds == null) {
            return value;
        }
        if (!Double.isFinite(value.getValue())) {
            return value;
        }
        if (this.bounds.getLowLimit() != null && value.getValue() < this.resultMU.convert(this.bounds.getLowLimit().doubleValue(), this.bounds.getMeasuringUnit())) {
            return value.copyWithPlausibility(Plausibility.LowerLimit);
        }
        if (this.bounds.getHighLimit() != null && value.getValue() > this.resultMU.convert(this.bounds.getHighLimit().doubleValue(), this.bounds.getMeasuringUnit())) {
            return value.copyWithPlausibility(Plausibility.UpperLimit);
        }
        return value;
    }
}

