/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.server.model.IValuesWriter;

public class CompoundValuesWriter
implements IValuesWriter {
    private final IValuesWriter lowResWriter;
    private final IValuesWriter highResWriter;

    public CompoundValuesWriter(IValuesWriter lowResWriter, IValuesWriter highResWriter) {
        this.lowResWriter = lowResWriter;
        this.highResWriter = highResWriter;
    }

    @Override
    public boolean deleteSupplementValue(VariableInstance instance, Integer selector, long fromTs, long toTs, User user) {
        boolean lowResult = this.lowResWriter.deleteSupplementValue(instance, selector, fromTs, toTs, user);
        this.highResWriter.deleteSupplementValue(instance, selector, fromTs, toTs, user);
        return lowResult;
    }

    @Override
    public boolean applySupplementValuesChanges(SupplementValueChange[] changes, boolean overwriteLaterUnrasterizedValues, User user) {
        boolean lowResult = this.lowResWriter.applySupplementValuesChanges(changes, overwriteLaterUnrasterizedValues, user);
        this.highResWriter.applySupplementValuesChanges(changes, overwriteLaterUnrasterizedValues, user);
        return lowResult;
    }
}

