/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ComputationLayer {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Map<VariableInstance, TsIntervals> missingData = new HashMap<VariableInstance, TsIntervals>();

    ComputationLayer() {
    }

    TsIntervals getMissingIntervals(VariableInstance instance) {
        return this.missingData.get(instance);
    }

    TsIntervals createMissingIntervals(VariableInstance instance) {
        TsIntervals intervals = new TsIntervals();
        this.missingData.put(instance, intervals);
        return intervals;
    }

    public Collection<Map.Entry<VariableInstance, TsIntervals>> getAllMissingIntervals() {
        return this.missingData.entrySet();
    }

    int intervals() {
        return this.missingData.size();
    }

    boolean isEmpty() {
        for (TsIntervals intervals : this.missingData.values()) {
            if (intervals.isEmpty()) continue;
            return false;
        }
        return true;
    }

    void clear() {
        this.missingData.clear();
    }

    void readLock() {
        this.readLock.lock();
    }

    void readUnlock() {
        this.readLock.unlock();
    }

    void writeLock() {
        this.writeLock.lock();
    }

    void writeUnlock() {
        this.writeLock.unlock();
    }
}

