/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.calculated.FormulaEvaluator;
import de.elpro.ewms.server.custom.CustomAlgorithms;
import de.elpro.ewms.server.model.IComputationBounds;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithm;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithmFactory;
import de.elpro.ewms.server.model.StateModel;
import de.elpro.ewms.server.rasterizedvalues.ComputationLayer;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesInvalidatedListener;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ComputationStack {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final RasterizedValues rasterizedValues;
    private final Raster RASTER;
    private final TreeMap<Integer, ComputationLayer> LAYER_STACK = new TreeMap();

    ComputationStack(RasterizedValues rasterizedValues) {
        this.rasterizedValues = rasterizedValues;
        this.RASTER = rasterizedValues.getRaster();
    }

    void clearComputationStack() {
        for (ComputationLayer layer : this.LAYER_STACK.values()) {
            layer.clear();
        }
    }

    void expandComputationStackRange(final long toTs, final IComputationBounds bounds) {
        if (bounds.getValuesEndTs() >= toTs) {
            return;
        }
        IComputationBounds newBounds = new IComputationBounds(){

            @Override
            public long getValuesStartTs() {
                return bounds.getValuesStartTs();
            }

            @Override
            public long getValuesEndTs() {
                return toTs;
            }
        };
        for (VariableInstance instance : ORMCache.getVariableInstances()) {
            if (instance.getSupplementValueStrategy() == null && (instance.getType() == VariableInstanceType.None || instance.getType() == VariableInstanceType.PLC)) continue;
            this.addToComputationLayer(instance, bounds.getValuesEndTs(), toTs, newBounds);
        }
    }

    void addToComputationStack(long fromTs, long toTs, IComputationBounds bounds) {
        if (toTs <= fromTs) {
            throw new IllegalArgumentException("Inconsistent computation stack interval");
        }
        for (VariableInstance instance : ORMCache.getVariableInstances()) {
            this.addToComputationLayer(instance, fromTs, toTs, bounds);
        }
    }

    void addToComputationLayer(VariableInstance instance, long fromTs, long toTs, IComputationBounds bounds) {
        this.addToComputationLayer(instance, fromTs, toTs, bounds, false);
    }

    void addToComputationLayer(VariableInstance instance, long fromTs, long toTs, IComputationBounds bounds, boolean skipCurrentInstance) {
        ICustomCalculationAlgorithm customAlgorithm;
        if (fromTs < bounds.getValuesStartTs() && toTs <= (fromTs = bounds.getValuesStartTs())) {
            return;
        }
        if (toTs <= fromTs) {
            throw new IllegalArgumentException("Inconsistent computation stack interval");
        }
        TsIntervals missingData = this.getMissingIntervalsOrDefault(instance);
        if (missingData.containsInterval(fromTs, toTs)) {
            return;
        }
        if (!skipCurrentInstance) {
            missingData.addInterval(fromTs, toTs);
            for (IVarValuesInvalidatedListener invalidationListener : this.rasterizedValues.getOnVarValuesInvalidatedListeners()) {
                invalidationListener.valuesInvalidated(this.rasterizedValues, instance, fromTs, toTs);
            }
        }
        if ((customAlgorithm = CustomAlgorithms.getAlgorithm(instance.getResultCustomAlgorithmId(), this.rasterizedValues)) != null && customAlgorithm instanceof StateModel) {
            StateModel modelAlgorithm = (StateModel)customAlgorithm;
            modelAlgorithm.addMissingInterval(instance, fromTs, toTs);
        }
        for (VariableInstance dependent : ORMCache.getDependentInstances(instance)) {
            if (dependent.getType() == VariableInstanceType.Calculated) {
                TsInterval interval = FormulaEvaluator.getDependentInterval(dependent, fromTs, toTs, bounds, this.RASTER);
                this.addToComputationLayer(dependent, interval.getFromTs(), interval.getToTs(), bounds);
                continue;
            }
            if (dependent.getType() == VariableInstanceType.Custom) {
                ICustomCalculationAlgorithmFactory customAlgorithmFactory = CustomAlgorithms.getAlgorithmFactory(dependent.getResultCustomAlgorithmId());
                if (customAlgorithmFactory == null) continue;
                TsInterval interval = customAlgorithmFactory.getDependencyManager().getDependentInterval(this.rasterizedValues, dependent, fromTs, toTs);
                long dependentTo = interval.getToTs();
                long dependentFrom = interval.getFromTs();
                if (this != Server.getRawValuesViews().getGlobalView().getComputationStack()) {
                    dependentTo = Math.min(dependentTo, bounds.getValuesEndTs());
                    dependentFrom = Math.max(dependentFrom, bounds.getValuesStartTs());
                }
                this.addToComputationLayer(dependent, dependentFrom, dependentTo, bounds);
                continue;
            }
            this.addToComputationLayer(dependent, fromTs, toTs, bounds);
        }
    }

    private TsIntervals getMissingIntervalsOrDefault(VariableInstance instance) {
        TsIntervals intervals;
        int depth = ORMCache.getInstanceLayer(instance);
        ComputationLayer computeLayer = this.LAYER_STACK.get(depth);
        if (computeLayer == null) {
            computeLayer = new ComputationLayer();
            this.LAYER_STACK.put(depth, computeLayer);
        }
        if ((intervals = computeLayer.getMissingIntervals(instance)) == null) {
            intervals = computeLayer.createMissingIntervals(instance);
        }
        return intervals;
    }

    ComputationLayer getComutationLayer(VariableInstance instance) {
        return this.LAYER_STACK.get(ORMCache.getInstanceLayer(instance));
    }

    Collection<ComputationLayer> getComputationLayers() {
        return this.LAYER_STACK.values();
    }

    Map<VariableInstance, TsIntervals> getAllMissingIntervals() {
        HashMap<VariableInstance, TsIntervals> missingData = new HashMap<VariableInstance, TsIntervals>();
        for (ComputationLayer layer : this.LAYER_STACK.values()) {
            for (Map.Entry<VariableInstance, TsIntervals> entry : layer.getAllMissingIntervals()) {
                missingData.put(entry.getKey(), entry.getValue());
            }
        }
        return missingData;
    }

    public boolean isEmpty() {
        try {
            this.readLock();
            for (ComputationLayer layer : this.getComputationLayers()) {
                if (layer.isEmpty()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.readUnlock();
        }
    }

    public int intervals() {
        try {
            int intervals = 0;
            this.readLock();
            for (ComputationLayer layer : this.getComputationLayers()) {
                intervals += layer.intervals();
            }
            int n = intervals;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    void readLock() {
        this.readLock.lock();
    }

    void readUnlock() {
        this.readLock.unlock();
    }

    void writeLock() {
        this.writeLock.lock();
    }

    void writeUnlock() {
        this.writeLock.unlock();
    }

    boolean tryWriteLock() {
        return this.writeLock.tryLock();
    }
}

