/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DeprecatedValuesRamCache {
    private static final int CLUSTER_SIZE = 1000;
    private static final int VALUE_BYTES = Math.max(38, Math.max(34, 26));
    private final String DEFAULT_KEY = "default cache key";
    private final Raster RASTER;
    private final Table<VariableInstance, String, Map<Long, byte[]>> CACHE = HashBasedTable.create();
    private long lastValuesTs = Long.MIN_VALUE;

    public DeprecatedValuesRamCache(Raster raster) {
        this.RASTER = raster;
    }

    public void push(VariableInstance instance, IVarValue[] values) {
        this.push(instance, "default cache key", values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(VariableInstance instance, String key, IVarValue[] values) {
        if (values.length == 0) {
            return;
        }
        Map<Long, byte[]> clusters = this.getClusters(instance, key);
        long firstElementEndTs = this.RASTER.getRasterEnd(values[0].getEndTimestamp());
        Map<Long, byte[]> map = clusters;
        synchronized (map) {
            long clusterId = this.getClusterId(firstElementEndTs);
            int j = (int)((firstElementEndTs - clusterId) / this.RASTER.toMilli());
            int i = 0;
            while (i < values.length) {
                boolean newCluster;
                byte[] cluster = clusters.get(clusterId);
                boolean bl = newCluster = cluster == null;
                if (newCluster) {
                    cluster = new byte[1000 * VALUE_BYTES];
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(cluster, j * VALUE_BYTES, cluster.length - j * VALUE_BYTES);
                boolean hasNonEmptyValues = false;
                boolean wholeClusterWriten = j == 0;
                while (j < 1000 && i < values.length) {
                    byteBuffer.position(j++ * VALUE_BYTES);
                    IVarValue value = values[i++];
                    DeprecatedValuesRamCache.writeValue(byteBuffer, value);
                    if (value.getValueSource() == ValueSource.NaN) continue;
                    hasNonEmptyValues = true;
                }
                if (j != 1000 && wholeClusterWriten) {
                    wholeClusterWriten = false;
                }
                if (newCluster && hasNonEmptyValues) {
                    clusters.put(clusterId, cluster);
                }
                if (!newCluster && wholeClusterWriten && !hasNonEmptyValues) {
                    clusters.remove(clusterId);
                }
                j = 0;
                clusterId += 1000L * this.RASTER.toMilli();
            }
        }
        map = this.CACHE;
        synchronized (map) {
            this.lastValuesTs = Math.max(this.lastValuesTs, this.RASTER.getRasterEnd(values[values.length - 1].getEndTimestamp()));
        }
    }

    public void pushEmpty(VariableInstance instance, long toTs) {
        this.pushEmpty(instance, "default cache key", toTs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEmpty(VariableInstance instance, String key, long toTs) {
        Map<Long, byte[]> clusters;
        Map<Long, byte[]> map = clusters = this.getClusters(instance, key);
        synchronized (map) {
            clusters.clear();
        }
        this.lastValuesTs = Math.max(this.lastValuesTs, this.RASTER.getRasterEnd(toTs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastValuesTs() {
        Table<VariableInstance, String, Map<Long, byte[]>> table = this.CACHE;
        synchronized (table) {
            return this.lastValuesTs;
        }
    }

    private static void writeValue(ByteBuffer buffer, IVarValue value) {
        ValueSource source = value.getValueSource();
        switch (source) {
            case Archive: {
                ArchiveValue av = (ArchiveValue)value;
                buffer.put((byte)ValueSource.Archive.ordinal());
                buffer.putLong(av.getStartTimestamp());
                buffer.putLong(av.getEndTimestamp());
                buffer.putDouble(av.getValue());
                buffer.putDouble(av.getQuality());
                buffer.put((byte)av.getPlausibility().ordinal());
                break;
            }
            case NaN: 
            case Calculated: 
            case Model: 
            case Mixed: {
                buffer.put((byte)value.getValueSource().ordinal());
                buffer.putLong(value.getEndTimestamp());
                buffer.putDouble(value.getValue());
                buffer.putDouble(value.getQuality());
                buffer.put((byte)value.getPlausibility().ordinal());
                break;
            }
            case Supplement: {
                SupplementValue sv = (SupplementValue)value;
                buffer.put((byte)ValueSource.Supplement.ordinal());
                buffer.putLong(sv.getStartTimestamp());
                buffer.putLong(sv.getEndTimestamp());
                buffer.putDouble(sv.getValue());
                buffer.put((byte)sv.getPlausibility().ordinal());
                buffer.putLong(sv.getRecordedTimestamp());
                buffer.putInt(sv.getUserId());
                break;
            }
            case Measured: {
                throw new IllegalArgumentException("Trying to write Measured Value to ORM Cache");
            }
            case None: {
                throw new IllegalArgumentException("Trying to write None Value to ORM Cache");
            }
        }
    }

    public IVarValue[] get(VariableInstance instance, long fromTs, long toTs) {
        return this.get(instance, "default cache key", fromTs, toTs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVarValue[] get(VariableInstance instance, String key, long fromTs, long toTs) {
        if (fromTs % this.RASTER.toMilli() != 0L || toTs % this.RASTER.toMilli() != 0L) {
            throw new IllegalArgumentException("Illegal interval bounds");
        }
        Map<Long, byte[]> clusters = this.getClusters(instance, key);
        int size = (int)((toTs - fromTs) / this.RASTER.toMilli());
        IVarValue[] result = new IVarValue[size];
        long firstElementEndTs = fromTs + this.RASTER.toMilli();
        long clusterId = this.getClusterId(firstElementEndTs);
        int j = (int)((firstElementEndTs - clusterId) / this.RASTER.toMilli());
        Map<Long, byte[]> map = clusters;
        synchronized (map) {
            int i = 0;
            while (i < size) {
                byte[] cluster = clusters.get(clusterId);
                if (cluster == null) {
                    while (j++ < 1000 && i < size) {
                        result[i] = VarValue.nan((long)(fromTs + this.RASTER.toMilli() * (long)(i + 1)));
                        ++i;
                    }
                } else {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(cluster, j * VALUE_BYTES, cluster.length - j * VALUE_BYTES);
                    while (j < 1000 && i < size) {
                        byteBuffer.position(j++ * VALUE_BYTES);
                        result[i] = DeprecatedValuesRamCache.readValue(byteBuffer);
                        if (result[i] == null) {
                            result[i] = VarValue.nan((long)(fromTs + (long)(i + 1) * this.RASTER.toMilli()));
                        }
                        ++i;
                    }
                }
                j = 0;
                clusterId += 1000L * this.RASTER.toMilli();
            }
            return result;
        }
    }

    public void deleteValues(long toTimestamp) {
        long newFirstClusterTs = this.getClusterId(toTimestamp);
        for (Map values : this.CACHE.values()) {
            LinkedList<Long> clustersToRemove = new LinkedList<Long>();
            for (Long clusterId : values.keySet()) {
                if (clusterId >= newFirstClusterTs) continue;
                clustersToRemove.add(clusterId);
            }
            for (Long id : clustersToRemove) {
                values.remove(id);
            }
        }
    }

    public void deleteValues() {
        this.CACHE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheKeys(VariableInstance instance) {
        Table<VariableInstance, String, Map<Long, byte[]>> table = this.CACHE;
        synchronized (table) {
            Map row = this.CACHE.row((Object)instance);
            if (row != null) {
                return row.keySet();
            }
            return Collections.emptySet();
        }
    }

    private static IVarValue readValue(ByteBuffer buffer) {
        ValueSource source = ValueSource.values()[buffer.get()];
        switch (source) {
            case Archive: {
                return new ArchiveValue(buffer.getLong(), buffer.getLong(), buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()]);
            }
            case Supplement: {
                return new SupplementValue(buffer.getLong(), buffer.getLong(), buffer.getDouble(), Plausibility.values()[buffer.get()], buffer.getLong(), buffer.getInt());
            }
            case NaN: 
            case Calculated: 
            case Model: 
            case Mixed: {
                return new VarValue(buffer.getLong(), buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()], source);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, byte[]> getClusters(VariableInstance instance, String key) {
        Table<VariableInstance, String, Map<Long, byte[]>> table = this.CACHE;
        synchronized (table) {
            HashMap<Long, byte[]> cachedValues = (HashMap<Long, byte[]>)this.CACHE.get((Object)instance, (Object)key);
            if (cachedValues == null) {
                cachedValues = new HashMap<Long, byte[]>();
                this.CACHE.put((Object)instance, (Object)key, cachedValues);
            }
            return cachedValues;
        }
    }

    private long getClusterId(long timestamp) {
        long offset = timestamp % (1000L * this.RASTER.toMilli());
        return timestamp - offset;
    }
}

