/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import java.util.Collection;

public interface IVarValuesCache {
    public static final String DEFAULT_KEY = "#default key";
    public static final String PLC_RAW_VALUES_KEY = "#PLC key";

    public Raster getRaster();

    default public void push(VariableInstance instance, IVarValuesCollection values) {
        this.push(instance, DEFAULT_KEY, values);
    }

    public void push(VariableInstance var1, String var2, IVarValuesCollection var3);

    default public void resetValues(VariableInstance instance, long newEndTs) {
        this.resetValues(instance, DEFAULT_KEY, newEndTs);
    }

    public void resetValues(VariableInstance var1, String var2, long var3);

    default public IVarValuesCollection get(VariableInstance instance, long fromTs, long toTs) {
        return this.get(instance, DEFAULT_KEY, fromTs, toTs);
    }

    public IVarValuesCollection get(VariableInstance var1, String var2, long var3, long var5);

    public long getLastValueTs();

    public Collection<String> getKeys(VariableInstance var1);

    public void clearCache();

    public void clearCacheForInstance(VariableInstance var1);

    public void clearCacheToTimestamp(long var1);

    public void clearCacheFromTimestamp(long var1);

    public long getRAMSize();

    public long getHDDSize();

    default public void destroy() {
    }
}

