/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.rawvalues.RawValuesViewDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewFutureTimeRange;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.IFutureTimeRange;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Aggregator;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.calculated.FormulaEvaluator;
import de.elpro.ewms.server.custom.CustomAlgorithms;
import de.elpro.ewms.server.model.IComputationBounds;
import de.elpro.ewms.server.model.ICustomCalculationAlgorithm;
import de.elpro.ewms.server.model.ILastValuesChangedListener;
import de.elpro.ewms.server.model.VariableInstanceValuesValidator;
import de.elpro.ewms.server.rasterizedvalues.ComputationLayer;
import de.elpro.ewms.server.rasterizedvalues.ComputationStack;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesCache;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesInvalidatedListener;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValuesState;
import de.elpro.ewms.server.rasterizedvalues.StoredValuesConverter;
import de.elpro.ewms.server.rasterizedvalues.SupplementValuesHackValidator;
import de.elpro.ewms.server.statistics.RasterizedValuesStatisticsInstance;
import de.elpro.ewms.server.statistics.Statistics;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import de.elpro.ewms.server.supplement.SupplementStorage;
import de.elpro.ui.thread.NamedThreadFactory;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.persistence.EntityManager;
import org.apache.commons.io.FileUtils;
import org.eclipse.fx.core.log.Logger;

public class RasterizedValues {
    private static Logger logger = Activator.getLoggerFactory().createLogger(RasterizedValues.class.getName());
    private static final int CORES_COUNT = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    private static final ExecutorService LOAD_DATA_EXECUTOR = Executors.newFixedThreadPool(Math.max(CORES_COUNT, 1), (ThreadFactory)new NamedThreadFactory("load-data-thread-"));
    private static final ExecutorService PUSH_PLC_VALUES_EXECUTOR = Executors.newFixedThreadPool(Math.max((int)((double)CORES_COUNT * 0.7), 1), (ThreadFactory)new NamedThreadFactory("push-pls-values-thread-"));
    private static final ExecutorService REALTIME_VIEW_EXECUTOR = Executors.newFixedThreadPool(Math.max((int)((double)CORES_COUNT * 0.8), 1), (ThreadFactory)new NamedThreadFactory("realtime-view-computation-thread-"));
    private static final ExecutorService GLOBAL_VIEW_EXECUTOR = Executors.newFixedThreadPool(Math.max((int)((double)CORES_COUNT * 0.8), 1), (ThreadFactory)new NamedThreadFactory("global-view-computation-thread-"));
    private static final ExecutorService CUSTOM_VIEW_EXECUTOR = Executors.newFixedThreadPool(Math.max(1, (int)((double)CORES_COUNT * 0.5)), (ThreadFactory)new NamedThreadFactory("custom-view-computation-thread-"));
    private final ExecutorService notifyListenersExecutor;
    private ComputationBounds valuesBounds;
    private Long plcNow;
    private IFutureTimeRange futureTimeRange;
    private AbstractWorker computationWorker;
    private final ComputationStack computationStack;
    private final IVarValuesCache varValuesCache;
    private final FormulaEvaluator formulaEvaluator;
    private final Raster raster;
    private final RawValuesViewType type;
    private final Integer index;
    private final ArchiveStorage archiveStorage;
    private volatile RasterizedValuesState state = RasterizedValuesState.New;
    private volatile double stateProgress = 0.0;
    private Long ramCacheSize = null;
    private Long hddArchivSize = null;
    private final Set<IVarValuesInvalidatedListener> varValuesInvalidatedListeners = new HashSet<IVarValuesInvalidatedListener>();
    private final Collection<ILastValuesChangedListener> lastValuesChangedListener = new LinkedList<ILastValuesChangedListener>();

    public RasterizedValues(RawValuesViewType type, Integer index, Raster raster, ArchiveStorage archStorage) {
        this.type = type;
        this.index = index;
        this.raster = raster;
        this.archiveStorage = archStorage;
        if (index == null) {
            EntityManager em = Server.getEntityManagerFactory().createEntityManager();
            try {
                em.getTransaction().begin();
                this.futureTimeRange = (IFutureTimeRange)em.find(RawValuesViewFutureTimeRange.class, (Object)type);
            }
            finally {
                em.getTransaction().rollback();
                em.close();
            }
        }
        this.varValuesCache = Server.getVarValuesCacheFactory().create(raster);
        this.computationStack = new ComputationStack(this);
        this.formulaEvaluator = new FormulaEvaluator(this);
        this.notifyListenersExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(String.format("[%s] notify-lastvalueschanged-listeners-", type.name())));
    }

    public void init() {
        long ts = System.nanoTime();
        this.writeLock();
        try {
            this.state = RasterizedValuesState.Initialization;
            if (!this.archiveStorage.open()) {
                throw new IllegalStateException("Could not initialize archive storage");
            }
            this.archiveStorage.compressDb();
            TimeRangeMetadata metadata = (TimeRangeMetadata)this.archiveStorage.getMetadata();
            if (metadata.getTimeRangeBegin() != null && metadata.getTimeRangeEnd() != null) {
                this.plcNow = this.raster.getRasterEnd(metadata.getTimeRangeEnd().longValue());
                long fromTs = this.raster.getRasterBegin(metadata.getTimeRangeBegin().longValue());
                long toTs = this.getFuture(this.plcNow);
                this.valuesBounds = new ComputationBounds(fromTs, toTs);
                this.loadPLCValues(ORMCache.getVariableInstances(), fromTs, toTs);
            }
            this.computationWorker = new ValuesComputationWorker(this.raster);
        }
        catch (Throwable throwable) {
            this.state = RasterizedValuesState.Idle;
            this.writeUnlock();
            logger.info(String.format("Initialization of %s done in %d ms", this.getType() + (this.getIndex() != null ? " - " + this.getIndex() : ""), (System.nanoTime() - ts) / 1000000L));
            throw throwable;
        }
        this.state = RasterizedValuesState.Idle;
        this.writeUnlock();
        logger.info(String.format("Initialization of %s done in %d ms", this.getType() + (this.getIndex() != null ? " - " + this.getIndex() : ""), (System.nanoTime() - ts) / 1000000L));
    }

    public void shutdown() {
        this.getComputationWorker().stopAsync();
        this.getArchiveStorage().close();
    }

    public void clearCache() {
        this.writeLock();
        try {
            this.computationStack.clearComputationStack();
            this.varValuesCache.clearCache();
            this.computationStack.addToComputationStack(this.valuesBounds.getValuesStartTs(), this.valuesBounds.getValuesEndTs(), this.valuesBounds);
            this.formulaEvaluator.getCumulativeValuesCache().clearCache();
        }
        finally {
            this.writeUnlock();
        }
    }

    public AbstractWorker getComputationWorker() {
        return this.computationWorker;
    }

    public ComputationStack getComputationStack() {
        return this.computationStack;
    }

    public RawValuesViewType getType() {
        return this.type;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public RasterizedValuesState getState() {
        return this.state;
    }

    public double getStateProgress() {
        return this.stateProgress;
    }

    public RawValuesViewDescriptor getDescriptor() {
        RawValuesViewDescriptor descriptor = new RawValuesViewDescriptor();
        descriptor.setId(this.getIndex());
        descriptor.setType(this.getType());
        descriptor.setName(this.getArchiveStorage().getName() != null ? this.getArchiveStorage().getName().toJson() : null);
        descriptor.setRaster(this.getRaster());
        descriptor.setTimeRangeBegin(Instant.ofEpochMilli(this.valuesBounds.getValuesStartTs()));
        descriptor.setTimeRangeEnd(Instant.ofEpochMilli(this.valuesBounds.getValuesEndTs()));
        this.readLock();
        try {
            if (this.ramCacheSize == null) {
                this.ramCacheSize = this.varValuesCache.getRAMSize();
            }
            descriptor.setRamSize(this.ramCacheSize.longValue());
            if (this.hddArchivSize == null) {
                this.hddArchivSize = FileUtils.sizeOfDirectory((File)new File(this.getArchiveStorage().getDbPath()));
            }
            descriptor.setHddSize(this.hddArchivSize.longValue());
        }
        finally {
            this.readUnlock();
        }
        return descriptor;
    }

    public ArchiveStorage getArchiveStorage() {
        return this.archiveStorage;
    }

    public void markValuesInvalidSync(long fromTs, long toTs) {
        this.writeLock();
        try {
            this.computationStack.addToComputationStack(fromTs, toTs, this.valuesBounds);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void markValuesInvalid(VariableInstance instance) {
        this.computationStack.addToComputationLayer(instance, this.valuesBounds.getValuesStartTs(), this.valuesBounds.getValuesEndTs(), this.valuesBounds);
    }

    public void markValuesInvalid(VariableInstance instance, long fromTs, Long toTs) {
        fromTs = Math.max(this.valuesBounds.getValuesStartTs(), fromTs);
        fromTs = this.raster.getRasterBegin(fromTs);
        toTs = toTs != null ? Math.min(this.valuesBounds.getValuesEndTs(), toTs) : this.valuesBounds.getValuesEndTs();
        if (fromTs < (toTs = Long.valueOf(this.raster.getRasterEnd(toTs.longValue())))) {
            this.computationStack.addToComputationLayer(instance, fromTs, toTs, this.valuesBounds);
        }
    }

    public void loadPLCValues(Collection<VariableInstance> instances) {
        this.loadPLCValues(instances, this.valuesBounds.getValuesStartTs(), this.valuesBounds.getValuesEndTs());
    }

    private void loadPLCValues(Collection<VariableInstance> instances, long fromTs, long toTs) {
        HashMap lastChangedValues = !this.lastValuesChangedListener.isEmpty() ? new HashMap() : null;
        LinkedList futures = new LinkedList();
        ExecutorService executorService = PUSH_PLC_VALUES_EXECUTOR;
        for (VariableInstance instance : instances) {
            if (instance.getType() == VariableInstanceType.PLC) {
                long loadToTs;
                Instant objectRemoved = instance.getStructureObject().getRemoved();
                long l = loadToTs = objectRemoved != null ? Math.min(toTs, this.raster.getRasterEnd(objectRemoved.toEpochMilli())) : toTs;
                if (fromTs < loadToTs) {
                    futures.add(executorService.submit(() -> {
                        ArrayList<ArchiveValue> archiveValues = this.archiveStorage.loadValues(instance, fromTs, loadToTs);
                        if (!archiveValues.isEmpty() || instance.getSupplementValueStrategy() != null) {
                            this.pushPLCValues(instance, archiveValues, fromTs, loadToTs, lastChangedValues);
                        }
                    }));
                }
                this.computationStack.addToComputationLayer(instance, fromTs, toTs, this.valuesBounds, true);
                continue;
            }
            this.computationStack.addToComputationLayer(instance, fromTs, toTs, this.valuesBounds);
        }
        futures.forEach(f -> {
            try {
                f.get();
            }
            catch (Exception e) {
                logger.error("Error pushing PLC Values", (Throwable)e);
            }
        });
        if (lastChangedValues != null && !this.lastValuesChangedListener.isEmpty()) {
            executorService.submit(() -> this.lastValuesChangedListener.parallelStream().forEach(listener -> {
                try {
                    listener.valuesChanged(lastChangedValues);
                }
                catch (Exception exc) {
                    logger.error("Error publisching last values changes", (Throwable)exc);
                }
            }));
        }
    }

    public void pushPLCValues(Map<VariableInstance, ArrayList<ArchiveValue>> instanceValues, Long archiveValuesRange, boolean updateValuesBounds) {
        if (instanceValues.isEmpty()) {
            return;
        }
        HashMap<VariableInstance, TsInterval> intervals = new HashMap<VariableInstance, TsInterval>();
        for (Map.Entry<VariableInstance, ArrayList<ArchiveValue>> entry : instanceValues.entrySet()) {
            VariableInstance instance = entry.getKey();
            ArrayList<ArchiveValue> values = entry.getValue();
            if (values.isEmpty()) continue;
            long firstPlcTs = this.raster.getRasterBegin(values.get(0).getStartTimestamp());
            long lastPlcTs = this.raster.getRasterEnd(values.get(values.size() - 1).getEndTimestamp());
            if (updateValuesBounds) {
                if (this.valuesBounds == null) {
                    this.setPlcNow(lastPlcTs);
                    this.valuesBounds = new ComputationBounds(firstPlcTs, this.getFuture(lastPlcTs));
                    this.computationStack.addToComputationStack(this.valuesBounds.getValuesStartTs(), this.valuesBounds.getValuesEndTs(), this.valuesBounds);
                }
                if (archiveValuesRange != null && this.plcNow - archiveValuesRange > this.valuesBounds.getValuesStartTs()) {
                    long newStartTs = this.raster.getRasterBegin(this.plcNow - archiveValuesRange);
                    this.moveValuesStartTs(newStartTs);
                    firstPlcTs = Math.max(firstPlcTs, newStartTs);
                }
                if (lastPlcTs > this.plcNow) {
                    this.setPlcNow(lastPlcTs);
                    long valuesEndTs = this.getFuture(lastPlcTs);
                    this.valuesBounds.setValuesEndTs(valuesEndTs);
                }
            } else if (this.valuesBounds == null) {
                throw new IllegalArgumentException("ValuesBounds is NULL. Set updateValuesBounds to TRUE.");
            }
            long changesStartTs = Math.max(firstPlcTs, this.valuesBounds.getValuesStartTs());
            long changesEndTs = Math.min(lastPlcTs, this.valuesBounds.getValuesEndTs());
            if (changesEndTs <= changesStartTs) continue;
            this.computationStack.addToComputationLayer(instance, changesStartTs, changesEndTs, this.valuesBounds, true);
            for (IVarValuesInvalidatedListener invalidationListener : this.getOnVarValuesInvalidatedListeners()) {
                invalidationListener.valuesInvalidated(this, instance, changesStartTs, changesEndTs);
            }
            intervals.put(instance, new TsInterval(changesStartTs, changesEndTs));
        }
        HashMap<VariableInstance, IVarValue> lastChangedValues = !this.lastValuesChangedListener.isEmpty() ? new HashMap<VariableInstance, IVarValue>() : null;
        for (Map.Entry<VariableInstance, ArrayList<ArchiveValue>> entry : instanceValues.entrySet()) {
            TsInterval interval;
            VariableInstance instance = entry.getKey();
            ArrayList<ArchiveValue> archiveValues = entry.getValue();
            if (archiveValues.isEmpty() || (interval = (TsInterval)intervals.get(instance)) == null) continue;
            long fromTs = interval.getFromTs();
            long toTs = interval.getToTs();
            this.pushPLCValues(instance, archiveValues, fromTs, toTs, lastChangedValues);
        }
        if (lastChangedValues != null && !this.lastValuesChangedListener.isEmpty()) {
            this.notifyListenersExecutor.execute(() -> this.lastValuesChangedListener.parallelStream().forEach(listener -> {
                try {
                    listener.valuesChanged(lastChangedValues);
                }
                catch (Exception exc) {
                    logger.error("Error publishing last values changes", (Throwable)exc);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushPLCValues(VariableInstance instance, ArrayList<ArchiveValue> archiveValues, long fromTs, long toTs, Map<VariableInstance, IVarValue> lastChangedValues) {
        Object object;
        IVarValuesCollection rawResult;
        IVarValuesCollection result;
        long ts;
        long startTs;
        block19: {
            Aggregation aggr = instance.getVariable().getResultAggregation();
            List<SupplementValue> supplementValues = null;
            startTs = System.nanoTime();
            if (instance.getSupplementValueStrategy() != null) {
                ts = System.nanoTime();
                supplementValues = this.loadSupplementValues(instance, aggr, fromTs, toTs);
                Statistics.SUPPLEMENT.increment(System.nanoTime() - ts, (toTs - fromTs) / this.raster.toMilli());
            }
            IVarValueValidator validator = this.createValidator(instance, supplementValues, aggr, fromTs, toTs);
            ts = System.nanoTime();
            result = null;
            rawResult = StoredValuesConverter.convertStoredNoParameterValues(archiveValues, fromTs, toTs, this.raster, aggr, false, null);
            if (instance.getSupplementValueStrategy() != null || instance.getResultValuesBounds() != null) {
                if (validator != null) {
                    object = null;
                    Object var18_15 = null;
                    try (IVarValuesCollection valCollection = new IVarValuesCollection(validator);){
                        valCollection.addAll((Collection)rawResult);
                        result = valCollection;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                result = rawResult;
            }
        }
        Statistics.ARCHIVE.increment(System.nanoTime() - ts, rawResult.size());
        ts = System.nanoTime();
        this.varValuesCache.push(instance, "#PLC key", rawResult);
        if (result != null) {
            this.varValuesCache.push(instance, result);
        }
        Statistics.RAM_CACHE_WRITE.increment(System.nanoTime() - ts, (toTs - fromTs) / this.getRaster().toMilli());
        Statistics.TOTAL.increment(System.nanoTime() - startTs, (toTs - fromTs) / this.getRaster().toMilli());
        if (lastChangedValues != null && toTs == this.getComputationBounds().getValuesEndTs()) {
            object = lastChangedValues;
            synchronized (object) {
                if (result != null) {
                    lastChangedValues.put(instance, result.getLast().copy());
                } else {
                    lastChangedValues.put(instance, rawResult.getLast().copy());
                }
            }
        }
        RasterizedValuesStatisticsInstance.INSTANCE.addNanos(instance, System.nanoTime() - startTs);
    }

    public void updateComputationStack(Set<VariableInstance> removedInstances, Set<VariableInstance> changedDepTreeInstances) {
        Map<VariableInstance, TsIntervals> missingIntervals = this.computationStack.getAllMissingIntervals();
        ComputationBounds bounds = this.getComputationBounds();
        this.computationStack.clearComputationStack();
        for (Map.Entry<VariableInstance, TsIntervals> entry : missingIntervals.entrySet()) {
            VariableInstance instance = entry.getKey();
            if (removedInstances.contains(instance)) continue;
            for (TsInterval interval : entry.getValue().getIntervals()) {
                this.computationStack.addToComputationLayer(instance, interval.getFromTs(), interval.getToTs(), bounds);
            }
        }
        if (bounds != null) {
            for (VariableInstance changedInstance : changedDepTreeInstances) {
                this.computationStack.addToComputationLayer(changedInstance, bounds.getValuesStartTs(), bounds.getValuesEndTs(), bounds);
            }
        }
        for (VariableInstance instance : removedInstances) {
            this.varValuesCache.clearCacheForInstance(instance);
            this.formulaEvaluator.getCumulativeValuesCache().clearCacheForInstance(instance);
        }
        for (VariableInstance instance : changedDepTreeInstances) {
            this.formulaEvaluator.getCumulativeValuesCache().clearCacheForInstance(instance);
        }
    }

    public void moveValuesStartTs(long valuesStartTs) {
        this.varValuesCache.clearCacheToTimestamp(valuesStartTs);
        this.valuesBounds.moveValuesStartTs(valuesStartTs);
    }

    public Long getPlcNow() {
        return this.plcNow;
    }

    protected void setPlcNow(long plcNow) {
        this.plcNow = plcNow;
    }

    protected long getFuture(long plcNow) {
        if (this.futureTimeRange == null || !this.futureTimeRange.isEnabled()) {
            return this.raster.getRasterEnd(plcNow);
        }
        return this.raster.getRasterEnd(this.futureTimeRange.getEndTimestamp(plcNow));
    }

    public IFutureTimeRange getFutureTimeRange() {
        this.readLock();
        try {
            IFutureTimeRange iFutureTimeRange = this.futureTimeRange;
            return iFutureTimeRange;
        }
        finally {
            this.readUnlock();
        }
    }

    public void setFutureTimeRange(IFutureTimeRange futureTimeRange) {
        this.writeLock();
        try {
            this.futureTimeRange = futureTimeRange;
            if (this.getComputationBounds() != null && this.getPlcNow() != null) {
                long newEndTs = this.raster.getRasterEnd(futureTimeRange.getEndTimestamp(this.getPlcNow().longValue()));
                this.getComputationBounds().setValuesEndTs(newEndTs);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public ComputationBounds getComputationBounds() {
        return this.valuesBounds;
    }

    public TimeRange getComputationTimeRange() {
        this.readLock();
        try {
            ComputationBounds bounds = this.getComputationBounds();
            if (bounds != null) {
                TimeRange timeRange = new TimeRange(Instant.ofEpochMilli(this.getComputationBounds().getValuesStartTs()), Instant.ofEpochMilli(this.getComputationBounds().getValuesEndTs()));
                return timeRange;
            }
            return null;
        }
        finally {
            this.readUnlock();
        }
    }

    public IVarValuesCollection getValues(VariableInstance instance, Instant utcFrom, Instant utcTo) {
        if (instance.getVariable() == null) {
            throw new IllegalStateException(String.format("Variable Instance (%d) has no assigned Variable and probalby not initialized!", instance.getId()));
        }
        String cacheKey = "#default key";
        if (instance.getType() == VariableInstanceType.PLC && instance.getSupplementValueStrategy() == null && instance.getResultValuesBounds() == null) {
            cacheKey = "#PLC key";
        }
        long fromTs = this.raster.getRasterBegin(utcFrom.toEpochMilli());
        long toTs = this.raster.getRasterEnd(utcTo.toEpochMilli());
        TimeRangeMetadata metadata = this.archiveStorage.getCachedMetadata();
        if (metadata == null || metadata.getTimeRangeBegin() == null) {
            return IVarValuesCollection.createNaN((long)fromTs, (long)toTs, (Raster)this.raster);
        }
        long ramRequestFrom = Math.max(fromTs, this.raster.getRasterBegin(metadata.getTimeRangeBegin().longValue()));
        long ramRequestTo = Math.min(toTs, this.raster.getRasterEnd(this.varValuesCache.getLastValueTs()));
        if (ramRequestTo <= ramRequestFrom) {
            return IVarValuesCollection.createNaN((long)fromTs, (long)toTs, (Raster)this.raster);
        }
        if (ramRequestFrom == fromTs && ramRequestTo == toTs) {
            return this.varValuesCache.get(instance, cacheKey, fromTs, toTs);
        }
        int size = (int)((toTs - fromTs) / this.raster.toMilli());
        Throwable throwable = null;
        Object var16_13 = null;
        try (IVarValuesCollection result = new IVarValuesCollection();){
            Iterator cachedValues = null;
            if (ramRequestFrom < ramRequestTo) {
                cachedValues = this.varValuesCache.get(instance, cacheKey, ramRequestFrom, ramRequestTo).iterator();
            }
            int i = 0;
            while (i < size) {
                long ts = fromTs + this.raster.toMilli() * (long)(i + 1);
                if (ts <= ramRequestFrom || ts > ramRequestTo) {
                    result.add(VarValue.nan((long)ts));
                } else {
                    result.add((IVarValue)cachedValues.next());
                }
                ++i;
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IVarValuesCollection getValues(VariableInstance instance, MeasuringUnit measuringUnit, Instant utcFrom, Instant utcTo) {
        MeasuringUnit instanceMU = instance.getVariable().getMeasuringUnit();
        IVarValuesCollection values = this.getValues(instance, utcFrom, utcTo);
        if (instanceMU.equals((Object)measuringUnit)) {
            return values;
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (IVarValuesCollection muValues = new IVarValuesCollection();){
            for (IVarValue iVal : values) {
                if (Double.isFinite(iVal.getValue())) {
                    muValues.add(iVal.copy(measuringUnit.convert(iVal.getValue(), instanceMU)));
                    continue;
                }
                muValues.add(iVal);
            }
            return values;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IVarValuesCollection[] getValues(VariableInstance[] instances, Instant from, Instant to) {
        IVarValuesCollection[] result = new IVarValuesCollection[instances.length];
        Future[] futures = new Future[instances.length];
        int i = 0;
        while (i < instances.length) {
            if (instances[i] != null) {
                int index = i;
                futures[index] = LOAD_DATA_EXECUTOR.submit(() -> {
                    iVarValuesCollectionArray[n] = this.getValues(instances[index], from, to);
                });
            }
            ++i;
        }
        i = 0;
        while (i < instances.length) {
            if (futures[i] != null) {
                try {
                    futures[i].get();
                }
                catch (Exception e) {
                    logger.error("Error reading data in Multithread mode", (Throwable)e);
                    throw new NullPointerException("Error reading data in Multithread mode");
                }
            }
            ++i;
        }
        return result;
    }

    public IVarValuesCollection getValues(VariableInstance instance, Instant utcFrom, Instant utcTo, ComplexRaster complexRaster) {
        IVarValuesCollection internalRasterValues = this.getValues(instance, utcFrom, utcTo);
        if (complexRaster == null || complexRaster.getRaster() == this.raster) {
            return internalRasterValues;
        }
        return IVarValuesCollection.create((IVarValue[])Aggregator.aggregate((IVarValue[])internalRasterValues.toArray(), (Raster)this.raster, (ComplexRaster)complexRaster, (Aggregation)instance.getVariable().getResultAggregation()));
    }

    public IVarValuesCollection getValuesSync(VariableInstance instance, Instant utcFrom, Instant utcTo) throws InterruptedException {
        return this.getValuesSync(new VariableInstance[]{instance}, utcFrom, utcTo)[0];
    }

    public IVarValuesCollection[] getValuesSync(VariableInstance[] instances, Instant utcFrom, Instant utcTo) throws InterruptedException {
        this.readLock();
        try {
            IVarValuesCollection[] instancesValues = new IVarValuesCollection[instances.length];
            int i = 0;
            while (i < instances.length) {
                VariableInstance instance = instances[i];
                ComputationLayer layer = null;
                try {
                    while (true) {
                        if ((layer = this.computationStack.getComutationLayer(instance)) != null) {
                            layer.readLock();
                            TsIntervals intervals = layer.getMissingIntervals(instance);
                            if (intervals == null || !intervals.hasIntersections(utcFrom.toEpochMilli(), utcTo.toEpochMilli())) break;
                            layer.readUnlock();
                        }
                        this.readUnlock();
                        Thread.sleep(10L);
                        this.readLock();
                    }
                    instancesValues[i] = this.getValues(instance, utcFrom, utcTo);
                }
                finally {
                    if (layer != null) {
                        layer.readUnlock();
                    }
                }
                ++i;
            }
            IVarValuesCollection[] iVarValuesCollectionArray = instancesValues;
            return iVarValuesCollectionArray;
        }
        finally {
            this.readUnlock();
        }
    }

    public IVarValuesCollection getValuesSync(VariableInstance instance, Instant utcFrom, Instant utcTo, ComplexRaster raster) throws InterruptedException {
        return this.getValuesSync(instance, utcFrom, utcTo, raster, instance.getVariable().getResultAggregation());
    }

    public IVarValuesCollection getValuesSync(VariableInstance instance, Instant utcFrom, Instant utcTo, ComplexRaster complexRaster, Aggregation aggregation) throws InterruptedException {
        IVarValuesCollection internalRasterValues = this.getValuesSync(instance, utcFrom, utcTo);
        if (complexRaster == null || complexRaster.getRaster() == this.raster) {
            return internalRasterValues;
        }
        return IVarValuesCollection.create((IVarValue[])Aggregator.aggregate((IVarValue[])internalRasterValues.toArray(), (Raster)this.raster, (ComplexRaster)complexRaster, (Aggregation)(aggregation != null ? aggregation : instance.getVariable().getResultAggregation())));
    }

    public IVarValuesCollection[] getCurrentValuesSync(VariableInstance[] instances) throws InterruptedException {
        this.readLock();
        try {
            long to = this.getPlcNow();
            long from = to - this.raster.toMilli();
            Instant utcFrom = Instant.ofEpochMilli(from);
            Instant utcTo = Instant.ofEpochMilli(to);
            IVarValuesCollection[] instancesValues = new IVarValuesCollection[instances.length];
            int i = 0;
            while (i < instances.length) {
                VariableInstance instance = instances[i];
                ComputationLayer layer = null;
                try {
                    while (true) {
                        if ((layer = this.computationStack.getComutationLayer(instance)) != null) {
                            layer.readLock();
                            TsIntervals intervals = layer.getMissingIntervals(instance);
                            if (intervals == null || !intervals.hasIntersections(utcFrom.toEpochMilli(), utcTo.toEpochMilli())) break;
                            layer.readUnlock();
                        }
                        this.readUnlock();
                        Thread.sleep(10L);
                        this.readLock();
                    }
                    instancesValues[i] = this.getValues(instance, utcFrom, utcTo);
                }
                finally {
                    if (layer != null) {
                        layer.readUnlock();
                    }
                }
                ++i;
            }
            IVarValuesCollection[] iVarValuesCollectionArray = instancesValues;
            return iVarValuesCollectionArray;
        }
        finally {
            this.readUnlock();
        }
    }

    public IVarValue getLastValue(VariableInstance instance) {
        long to = this.archiveStorage.getCachedMetadata().getTimeRangeEnd();
        long from = to - this.raster.toMilli();
        IVarValuesCollection lastValues = this.getValues(instance, Instant.ofEpochMilli(from), Instant.ofEpochMilli(to));
        return lastValues.getFirst();
    }

    public IVarValue getCurrentValueSync(VariableInstance instance) throws InterruptedException {
        return this.getCurrentValueSync(new VariableInstance[]{instance})[0];
    }

    public IVarValue[] getCurrentValueSync(VariableInstance[] instances) throws InterruptedException {
        IVarValuesCollection[] values = this.getCurrentValuesSync(instances);
        IVarValue[] lastValues = new IVarValue[instances.length];
        int i = 0;
        while (i < instances.length) {
            lastValues[i] = values[i].getFirst();
            ++i;
        }
        return lastValues;
    }

    public IVarValue getLastValidValue(VariableInstance instance, long maxAge) {
        long rangeMillis = this.raster.toMilli() * 24L * 30L;
        TimeRangeMetadata metadata = this.archiveStorage.getCachedMetadata();
        long startTo = metadata.getTimeRangeEnd();
        long minTo = Math.max(startTo - maxAge, metadata.getTimeRangeBegin());
        long to = startTo;
        long from = to - rangeMillis;
        while (to >= minTo) {
            IVarValuesCollection lastValues = this.getValues(instance, Instant.ofEpochMilli(from), Instant.ofEpochMilli(to));
            IVarValue candidate = null;
            for (IVarValue val : lastValues) {
                if (!val.isValid()) continue;
                candidate = val;
            }
            if (candidate != null) {
                return candidate;
            }
            if (from <= metadata.getTimeRangeBegin()) {
                return new VarValue(from + this.raster.toMilli(), Double.NaN, -1.0, Plausibility.Missing, ValueSource.NaN);
            }
            to = from;
            from = Math.max(metadata.getTimeRangeBegin(), to - rangeMillis);
        }
        return new VarValue(startTo, Double.NaN, -1.0, Plausibility.Missing, ValueSource.NaN);
    }

    public IVarValue[] getLastValidValueSync(VariableInstance[] instances, long maxAge) throws InterruptedException {
        long to = this.getPlcNow();
        long from = Math.max(this.getComputationBounds().getValuesStartTs(), this.raster.getRasterEnd(to - maxAge) - this.raster.toMilli());
        IVarValuesCollection[] values = this.getValuesSync(instances, Instant.ofEpochMilli(from), Instant.ofEpochMilli(to));
        IVarValue[] result = new IVarValue[instances.length];
        int i = 0;
        while (i < instances.length) {
            IVarValuesCollection iValues = values[i];
            IVarValue candidate = null;
            IVarValue lastValue = null;
            for (IVarValue val : iValues) {
                if (val.isValid()) {
                    candidate = val;
                }
                lastValue = val;
            }
            result[i] = candidate != null ? candidate : VarValue.nan((long)lastValue.getEndTimestamp());
            ++i;
        }
        return result;
    }

    public SupplementValue getSupplementValue(VariableInstance instance, Instant ts, Integer selector) {
        long to = this.raster.getRasterEnd(ts.toEpochMilli());
        long from = to - this.raster.toMilli();
        ArrayList supplementValues = SupplementStorage.getInstance().loadValues(instance, selector, from, to);
        if (supplementValues.size() == 0) {
            return null;
        }
        return (SupplementValue)supplementValues.get(supplementValues.size() - 1);
    }

    public SupplementValue getLastSupplementValue(VariableInstance instance, Integer selector) {
        if (instance.getSupplementValueStrategy() != SupplementValueStrategy.Unrasterized) {
            throw new IllegalArgumentException(String.format("Instance %s not of unrasterized type", instance.getFullName()));
        }
        long to = this.archiveStorage.getCachedMetadata().getTimeRangeEnd();
        long from = to - this.raster.toMilli();
        ArrayList supplementValues = SupplementStorage.getInstance().loadValues(instance, selector, from, to);
        if (supplementValues.size() == 0) {
            return null;
        }
        return (SupplementValue)supplementValues.get(supplementValues.size() - 1);
    }

    public SupplementValue getLastSupplementValueSync(VariableInstance instance, Integer selector) throws InterruptedException {
        ComputationLayer layer = null;
        try {
            this.computationStack.readLock();
            while (true) {
                if ((layer = this.computationStack.getComutationLayer(instance)) != null) {
                    layer.readLock();
                    TsIntervals intervals = layer.getMissingIntervals(instance);
                    if (intervals == null || intervals.isEmpty()) break;
                    layer.readUnlock();
                }
                Thread.sleep(500L);
            }
            SupplementValue supplementValue = this.getLastSupplementValue(instance, selector);
            return supplementValue;
        }
        finally {
            layer.readUnlock();
            this.computationStack.readUnlock();
        }
    }

    public Map<VariableInstance, TsIntervals> getInvalidValuesIntervals(Instant from, Instant to, Function<VariableInstance, Boolean> filter) {
        HashMap<VariableInstance, TsIntervals> invalidValuesIntervals = new HashMap<VariableInstance, TsIntervals>();
        this.readLock();
        try {
            for (VariableInstance instance : Collections.unmodifiableCollection(ORMCache.getVariableInstances())) {
                if (!filter.apply(instance).booleanValue()) continue;
                long ts = this.raster.getRasterBegin(from.toEpochMilli());
                TsIntervals intervals = new TsIntervals();
                IVarValuesCollection values = this.getValues(instance, from, to);
                for (IVarValue val : values) {
                    if (!val.isValid()) continue;
                    long valBegin = this.raster.getRasterEnd(val.getEndTimestamp()) - this.raster.toMilli();
                    if (ts < valBegin) {
                        TsInterval interval = new TsInterval(this.raster.getRasterBegin(ts), valBegin);
                        intervals.getIntervals().add(interval);
                    }
                    ts = val.getEndTimestamp();
                }
                if (ts < this.raster.getRasterEnd(to.toEpochMilli())) {
                    intervals.getIntervals().add(new TsInterval(this.raster.getRasterBegin(ts), this.raster.getRasterEnd(to.toEpochMilli())));
                }
                if (intervals.isEmpty()) continue;
                invalidValuesIntervals.put(instance, intervals);
            }
        }
        finally {
            this.readUnlock();
        }
        return invalidValuesIntervals;
    }

    public void readLock() {
        this.computationStack.readLock();
    }

    public void readUnlock() {
        this.computationStack.readUnlock();
    }

    public void writeLock() {
        this.computationStack.writeLock();
        this.hddArchivSize = null;
        this.ramCacheSize = null;
    }

    public void writeUnlock() {
        this.computationStack.writeUnlock();
    }

    public boolean tryWriteLock() {
        boolean result = this.computationStack.tryWriteLock();
        if (result) {
            this.hddArchivSize = null;
            this.ramCacheSize = null;
        }
        return result;
    }

    private List<SupplementValue> loadSupplementValues(VariableInstance instance, Aggregation aggr, long fromTs, long toTs) {
        ArrayList<SupplementValue> supplementValues = SupplementStorage.getInstance().loadValues(instance, fromTs, toTs);
        if (instance.getSupplementValueStrategy() == SupplementValueStrategy.Rasterized && !supplementValues.isEmpty() && ((SupplementValue)supplementValues.get(supplementValues.size() - 1)).getEndTimestamp() <= fromTs) {
            supplementValues.clear();
        }
        if (!(supplementValues == null || aggr != Aggregation.Last && aggr != Aggregation.LastValid || supplementValues.isEmpty() || instance.getSupplementValueStrategy() != SupplementValueStrategy.Rasterized || instance.getType() == VariableInstanceType.None || fromTs <= this.getComputationBounds().getValuesStartTs())) {
            Instant firstValueToTs;
            Instant firstValueFromTs;
            IVarValue preValue;
            int insertIndex = -1;
            int svSize = supplementValues.size();
            while (insertIndex + 1 < svSize && ((SupplementValue)supplementValues.get(insertIndex + 1)).getEndTimestamp() < fromTs) {
                ++insertIndex;
            }
            if (insertIndex + 1 < svSize && ((SupplementValue)supplementValues.get(insertIndex + 1)).getStartTimestamp() == fromTs && (preValue = this.getValues(instance, firstValueFromTs = Instant.ofEpochMilli(fromTs - this.raster.toMilli()), firstValueToTs = Instant.ofEpochMilli(fromTs)).getFirst()).isValid()) {
                SupplementValue sv = new SupplementValue(firstValueFromTs.toEpochMilli(), firstValueToTs.toEpochMilli(), preValue.getValue(), -1L, -1);
                if (insertIndex == -1) {
                    supplementValues.add(0, sv);
                } else {
                    supplementValues.set(insertIndex, sv);
                }
            }
        }
        return supplementValues;
    }

    private IVarValueValidator createValidator(VariableInstance instance, List<SupplementValue> supplementValues, Aggregation aggr, long fromTs, long toTs) {
        Object validator = supplementValues != null && !supplementValues.isEmpty() ? new SupplementValuesHackValidator(instance, supplementValues, fromTs, toTs, this.raster, instance.getSupplementValueStrategy(), aggr) : (instance.getResultValuesBounds() != null ? new VariableInstanceValuesValidator(instance) : null);
        return validator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVarValuesCollection getVisibleRasterizedValues(VariableInstance instance, long fromTs, long toTs) throws Exception {
        long ts;
        IVarValuesCollection result;
        Long removedTs;
        StructureObject object = instance.getStructureObject();
        Long l = removedTs = object.getRemoved() != null ? Long.valueOf(this.raster.getRasterEnd(object.getRemoved().toEpochMilli())) : null;
        if (removedTs != null && removedTs <= fromTs) {
            result = IVarValuesCollection.createNaN((long)fromTs, (long)toTs, (Raster)this.raster);
        } else if (removedTs == null || removedTs >= toTs) {
            result = this.getRasterizedValues(instance, fromTs, toTs);
        } else {
            ts = fromTs;
            Throwable throwable = null;
            Object var12_10 = null;
            try (IVarValuesCollection values = new IVarValuesCollection();){
                IVarValuesCollection intervalValues = this.getRasterizedValues(instance, ts, removedTs);
                if (intervalValues == null) {
                    return null;
                }
                values.addAll((Collection)intervalValues);
                ts = removedTs;
                while (true) {
                    if (ts >= toTs) {
                        result = values;
                        break;
                    }
                    values.add(VarValue.nan((long)(ts += this.raster.toMilli())));
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        ts = System.nanoTime();
        if (result != null) {
            this.varValuesCache.push(instance, result);
        } else {
            this.varValuesCache.resetValues(instance, toTs);
        }
        Statistics.RAM_CACHE_WRITE.increment(System.nanoTime() - ts, (toTs - fromTs) / this.getRaster().toMilli());
        return result;
    }

    private IVarValuesCollection getRasterizedValues(VariableInstance instance, long fromTs, long toTs) throws Exception {
        long ts;
        long startTs = ts = System.nanoTime();
        if (this.raster.compareTo((Enum)Raster.Hour) > 0) {
            throw new IllegalArgumentException("Maximal computing raster is Raster.Hour");
        }
        Aggregation aggr = instance.getVariable().getResultAggregation();
        IVarValuesCollection result = null;
        List<SupplementValue> supplementValues = null;
        if (instance.getSupplementValueStrategy() != null) {
            ts = System.nanoTime();
            supplementValues = this.loadSupplementValues(instance, aggr, fromTs, toTs);
            Statistics.SUPPLEMENT.increment(System.nanoTime() - ts, (toTs - fromTs) / this.raster.toMilli());
        }
        IVarValueValidator validator = this.createValidator(instance, supplementValues, aggr, fromTs, toTs);
        if (instance.getType() == VariableInstanceType.PLC) {
            result = this.varValuesCache.get(instance, "#PLC key", fromTs, toTs);
            if (instance.getSupplementValueStrategy() == null && instance.getResultValuesBounds() == null) {
                return result;
            }
            if (validator != null) {
                Throwable throwable = null;
                Object var15_14 = null;
                try (IVarValuesCollection valCollection = new IVarValuesCollection(validator);){
                    valCollection.addAll((Collection)result);
                    result = valCollection;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        } else if (instance.getType() == VariableInstanceType.Calculated) {
            try {
                ts = System.nanoTime();
                result = this.formulaEvaluator.evaluate(instance, fromTs, toTs, validator);
                Statistics.CALCULATED.increment(System.nanoTime() - ts, (toTs - fromTs) / this.getRaster().toMilli());
            }
            catch (Exception exc) {
                logger.error(String.format("Error computing calculated variable %s / %s with formula = '%s'. Unexpected exception occurred.", ORMCache.getVariableName(instance.getVariable()), instance.getStructureObject(), instance.getResultCalculationFormula()), (Throwable)exc);
            }
        } else if (instance.getType() == VariableInstanceType.Link) {
            if (instance.getLink() != null) {
                ts = System.nanoTime();
                result = this.varValuesCache.get(instance.getLink(), fromTs, toTs);
                Statistics.RAM_CACHE_READ.increment(System.nanoTime() - ts, result.size());
            } else {
                logger.error(String.format("%s link instance defines no link reference", instance.getFullName()));
            }
        } else if (instance.getType() == VariableInstanceType.Custom) {
            ICustomCalculationAlgorithm algorithm = CustomAlgorithms.getAlgorithm(instance.getResultCustomAlgorithmId(), this);
            if (algorithm == null) {
                logger.info(String.format("Trying to Compute Data for Custom Variable: %s / %s with anknown algorithm id %s", ORMCache.getVariableName(instance.getVariable()), instance.getStructureObject(), instance.getCustomAlgorithmId()));
            } else {
                try {
                    ts = System.nanoTime();
                    result = algorithm.calculate(instance, fromTs, toTs);
                    Statistics.CUSTOM.increment(System.nanoTime() - ts, result.size());
                }
                catch (Exception exc) {
                    logger.error(String.format("Error caculating custom variable %s / %s:", ORMCache.getVariableName(instance.getVariable()), instance.getStructureObject()), (Throwable)exc);
                }
            }
        } else {
            result = null;
        }
        if (result == null && supplementValues != null) {
            ts = System.nanoTime();
            if (validator != null || !supplementValues.isEmpty()) {
                try {
                    result = new IVarValuesCollection(validator);
                    long supplTs = fromTs + this.raster.toMilli();
                    while (supplTs <= toTs) {
                        result.add(VarValue.nan((long)supplTs));
                        supplTs += this.raster.toMilli();
                    }
                }
                finally {
                    result.close();
                }
            } else {
                result = IVarValuesCollection.createNaN((long)fromTs, (long)toTs, (Raster)this.raster);
            }
            Statistics.SUPPLEMENT.increment(System.nanoTime() - ts, 0L);
        }
        Statistics.TOTAL.increment(System.nanoTime() - startTs, (toTs - fromTs) / this.getRaster().toMilli());
        return result;
    }

    public static void validateResult(IVarValue[] values, IVarValueValidator validator) {
        if (values == null) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            values[i] = validator.validate(values[i]);
            ++i;
        }
    }

    public void addOnVarValuesInvalidatedListener(IVarValuesInvalidatedListener listener) {
        this.writeLock();
        try {
            this.varValuesInvalidatedListeners.add(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    public Collection<IVarValuesInvalidatedListener> getOnVarValuesInvalidatedListeners() {
        this.readLock();
        try {
            Set<IVarValuesInvalidatedListener> set = this.varValuesInvalidatedListeners;
            return set;
        }
        finally {
            this.readUnlock();
        }
    }

    public void removeOnVarValuesInvalidatedListener(IVarValuesInvalidatedListener listener) {
        this.writeLock();
        try {
            this.varValuesInvalidatedListeners.remove(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void addOnLastValuesChangesListener(ILastValuesChangedListener listener) {
        this.writeLock();
        try {
            this.lastValuesChangedListener.add(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeOnLastValuesChangedListener(ILastValuesChangedListener listener) {
        this.writeLock();
        try {
            this.lastValuesChangedListener.remove(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    private String getComputationWorkerName() {
        switch (this.type) {
            case GlobalView: {
                return String.format("Global view computation worker [%s]", this.raster.name());
            }
            case RealtimeView: {
                return String.format("Realtime view computation worker [%s]", this.raster.name());
            }
            case CustomView: {
                TimeRangeMetadata metadata = this.archiveStorage.getCachedMetadata();
                return String.format("Raw Values View computation worker [%s] (%s - %s)", this.raster.name(), Instant.ofEpochMilli(metadata.getTimeRangeBegin()), Instant.ofEpochMilli(metadata.getTimeRangeEnd()));
            }
        }
        return null;
    }

    private ExecutorService getExecutorService() {
        switch (this.getType()) {
            case RealtimeView: {
                return REALTIME_VIEW_EXECUTOR;
            }
            case GlobalView: {
                return GLOBAL_VIEW_EXECUTOR;
            }
            case CustomView: {
                return CUSTOM_VIEW_EXECUTOR;
            }
        }
        return CUSTOM_VIEW_EXECUTOR;
    }

    public void destroy() {
        this.varValuesCache.destroy();
    }

    static /* synthetic */ IVarValuesCollection access$0(RasterizedValues rasterizedValues, VariableInstance variableInstance, long l, long l2) throws Exception {
        return rasterizedValues.getVisibleRasterizedValues(variableInstance, l, l2);
    }

    public class ComputationBounds
    implements IComputationBounds {
        private final AtomicLong valuesStartTs;
        private final AtomicLong valuesEndTs;

        public ComputationBounds(long valuesStartTs, long valuesEndTs) {
            this.valuesStartTs = new AtomicLong(valuesStartTs);
            this.valuesEndTs = new AtomicLong(valuesEndTs);
        }

        @Override
        public long getValuesStartTs() {
            return this.valuesStartTs.get();
        }

        @Override
        public long getValuesEndTs() {
            return this.valuesEndTs.get();
        }

        public void moveValuesStartTs(long newValuesStartTs) {
            if (this.valuesStartTs.get() < newValuesStartTs) {
                this.valuesStartTs.set(newValuesStartTs);
            } else if (newValuesStartTs < this.valuesStartTs.get()) {
                RasterizedValues.this.computationStack.addToComputationStack(newValuesStartTs, this.valuesStartTs.get(), this);
                this.valuesStartTs.set(newValuesStartTs);
            }
            if (newValuesStartTs >= this.valuesEndTs.get()) {
                this.valuesEndTs.set(this.valuesStartTs.get());
            }
        }

        public void setValuesEndTs(long newValuesEndTs) {
            long oldEndTs = this.valuesEndTs.get();
            if (newValuesEndTs == oldEndTs) {
                return;
            }
            if (newValuesEndTs > oldEndTs) {
                RasterizedValues.this.computationStack.expandComputationStackRange(newValuesEndTs, this);
            } else {
                RasterizedValues.this.varValuesCache.clearCacheFromTimestamp(newValuesEndTs);
                logger.infof("Raster: %s. Reduce EndTs to %s", new Object[]{RasterizedValues.this.raster, LocalDateTime.ofInstant(Instant.ofEpochMilli(newValuesEndTs), ZoneId.systemDefault())});
            }
            this.valuesEndTs.set(newValuesEndTs);
        }

        public String toString() {
            return String.format("[%s - %s]", Instant.ofEpochMilli(this.valuesStartTs.get()), Instant.ofEpochMilli(this.valuesEndTs.get()));
        }
    }

    private class ValuesComputationWorker
    extends AbstractWorker {
        private final Logger logger;

        public ValuesComputationWorker(Raster raster) {
            super("de.elpro.ewms.server.computationworker." + RasterizedValues.this.getType().name() + (RasterizedValues.this.index != null ? "." + RasterizedValues.this.index : ""), RasterizedValues.this.getComputationWorkerName(), 1000L, false);
            this.logger = Activator.getLoggerFactory().createLogger(ValuesComputationWorker.class.getName());
        }

        protected boolean doStart() {
            return true;
        }

        protected void doStop() {
        }

        protected boolean canDoWork() {
            return !RasterizedValues.this.getComputationStack().isEmpty();
        }

        protected Callable<Void> createWorkTask() {
            return new Callable<Void>(){
                private volatile int progress = 0;

                private void updateProgress(double progress) {
                    ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.stateProgress = progress;
                }

                private void computeLayer(ComputationLayer layer, Map<VariableInstance, IVarValue> lastChangedValues, int intervalsCount, ExecutorService executorService) throws Exception {
                    block6: {
                        layer.writeLock();
                        try {
                            LinkedList futures = new LinkedList();
                            Map exceptions = Collections.synchronizedMap(new LinkedHashMap());
                            for (Map.Entry<VariableInstance, TsIntervals> entry : layer.getAllMissingIntervals()) {
                                VariableInstance instance = ORMCache.getVariableInstance(entry.getKey().getId());
                                TsIntervals missingData = entry.getValue();
                                futures.add(executorService.submit(() -> {
                                    long getInstanceValuesDurationTs = System.nanoTime();
                                    try {
                                        for (TsInterval interval : missingData.getIntervals()) {
                                            long fromTs = Math.max(interval.getFromTs(), RasterizedValues.this.getComputationBounds().getValuesStartTs());
                                            long toTs = Math.min(interval.getToTs(), RasterizedValues.this.getComputationBounds().getValuesEndTs());
                                            if (toTs <= fromTs) continue;
                                            IVarValuesCollection values = RasterizedValues.this.getVisibleRasterizedValues(instance, fromTs, toTs);
                                            if (lastChangedValues == null || interval.getToTs() != RasterizedValues.this.getComputationBounds().getValuesEndTs()) continue;
                                            Map map3 = lastChangedValues;
                                            synchronized (map3) {
                                                if (values != null) {
                                                    lastChangedValues.put(instance, values.getLast().copy());
                                                } else {
                                                    lastChangedValues.put(instance, VarValue.nan((long)interval.getToTs()));
                                                }
                                            }
                                        }
                                    }
                                    catch (Exception exc) {
                                        exceptions.put(instance, exc);
                                    }
                                    RasterizedValuesStatisticsInstance.INSTANCE.addNanos(instance, System.nanoTime() - getInstanceValuesDurationTs);
                                    this.updateProgress((double)this.progress++ / (double)(intervalsCount + 1));
                                }));
                            }
                            for (Future future : futures) {
                                future.get();
                            }
                            if (exceptions.isEmpty()) {
                                layer.clear();
                                break block6;
                            }
                            exceptions.entrySet().forEach(e -> ValuesComputationWorker.this.logger.error(String.format("Error while computing values for %s", ((VariableInstance)e.getKey()).getFullName()), (Throwable)e.getValue()));
                            throw (Exception)exceptions.values().stream().findAny().get();
                        }
                        finally {
                            layer.writeUnlock();
                        }
                    }
                }

                @Override
                public Void call() throws Exception {
                    HashMap<VariableInstance, IVarValue> lastChangedValues = !((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.lastValuesChangedListener.isEmpty() ? new HashMap<VariableInstance, IVarValue>() : null;
                    long ts = System.nanoTime();
                    ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.computationStack.readLock();
                    ExecutorService executorService = RasterizedValues.this.getExecutorService();
                    if (((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.state != RasterizedValuesState.Initialization) {
                        ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.state = RasterizedValuesState.InProgress;
                    }
                    this.progress = 0;
                    int intervalsCount = 0;
                    try {
                        try {
                            Collection<ComputationLayer> layers = ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.computationStack.getComputationLayers();
                            LinkedList<ComputationLayer> computationLayers = new LinkedList<ComputationLayer>();
                            for (ComputationLayer layer : layers) {
                                if (layer.intervals() <= 0) continue;
                                intervalsCount += layer.intervals();
                                computationLayers.add(layer);
                            }
                            if (!computationLayers.isEmpty()) {
                                this.updateProgress(0.0);
                                for (ComputationLayer layer : computationLayers) {
                                    this.computeLayer(layer, lastChangedValues, intervalsCount, executorService);
                                }
                                this.updateProgress(1.0);
                            }
                        }
                        catch (Exception exc) {
                            ValuesComputationWorker.this.logger.error(String.format("Common error while values computation", new Object[0]), (Throwable)exc);
                            ValuesComputationWorker.this.error(exc.getMessage(), 1);
                            ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.state = RasterizedValuesState.Idle;
                            ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.computationStack.readUnlock();
                            return null;
                        }
                    }
                    finally {
                        ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.state = RasterizedValuesState.Idle;
                        ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.computationStack.readUnlock();
                    }
                    long computationDurationMilli = (System.nanoTime() - ts) / 1000000L;
                    if (computationDurationMilli > ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.raster.toMilli() / 2L || computationDurationMilli > 5000L) {
                        ValuesComputationWorker.this.logger.warning(String.format("Computation for %d intervals of [%s] raster done in %.3f sek.", intervalsCount, ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.raster, (double)computationDurationMilli / 1000.0));
                    }
                    if (lastChangedValues != null && !((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.lastValuesChangedListener.isEmpty()) {
                        executorService.submit(() -> ((ValuesComputationWorker)ValuesComputationWorker.this).RasterizedValues.this.lastValuesChangedListener.parallelStream().forEach(listener -> {
                            try {
                                listener.valuesChanged(lastChangedValues);
                            }
                            catch (Exception exc) {
                                ValuesComputationWorker.this.logger.error("Error publisching last values changes", (Throwable)exc);
                            }
                        }));
                    }
                    return null;
                }
            };
        }
    }
}

