/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;

public class StoredValuesConverter {
    public static <T extends IStoredVarValue> IVarValuesCollection convertStoredNoParameterValues(ArrayList<T> storedValues, long fromTs, long toTs, Raster raster, Aggregation aggr, IVarValueValidator validator) {
        return StoredValuesConverter.convertStoredNoParameterValues(storedValues, fromTs, toTs, raster, aggr, true, validator);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T extends IStoredVarValue> IVarValuesCollection convertStoredNoParameterValues(ArrayList<T> storedValues, long fromTs, long toTs, Raster raster, Aggregation aggr, boolean allowInterpolation, IVarValueValidator validator) {
        rasterMillis = raster.toMilli();
        if (fromTs % rasterMillis != 0L || toTs % rasterMillis != 0L) {
            throw new IllegalArgumentException("Bounds not in given raster");
        }
        size = (int)((toTs - fromTs) / rasterMillis);
        var12_9 = null;
        var13_11 = null;
        try {
            result = new IVarValuesCollection(validator);
            try {
                j = 0;
                elValues = new ArrayList<IStoredVarValue>(1);
                storedValue /* !! */  = null;
                prevValidValue /* !! */  = null;
                storedValuesSize = storedValues.size();
                if (storedValuesSize > 0) {
                    prevValue = storedValue /* !! */ ;
                    storedValue /* !! */  = (IStoredVarValue)storedValues.get(j++);
                    while (storedValue /* !! */  != null) {
                        prevValidValue /* !! */  = allowInterpolation != false && prevValue != null && prevValue.getEndTimestamp() == storedValue /* !! */ .getStartTimestamp() && prevValue.isValid() != false ? prevValue : null;
                        if (fromTs < storedValue /* !! */ .getEndTimestamp()) break;
                        prevValue = storedValue /* !! */ ;
                        storedValue /* !! */  = j < storedValuesSize ? (IStoredVarValue)storedValues.get(j++) : null;
                    }
                }
                endTimestamp = fromTs;
                i = 0;
                while (i < size) {
                    endTimestamp += rasterMillis;
                    if (storedValue /* !! */  != null) ** GOTO lbl34
                    break;
lbl-1000:
                    // 1 sources

                    {
                        result.add(VarValue.nan((long)endTimestamp));
                        endTimestamp += rasterMillis;
                        ++i;
lbl34:
                        // 2 sources

                        ** while (endTimestamp <= storedValue /* !! */ .getStartTimestamp())
                    }
lbl35:
                    // 1 sources

                    if (allowInterpolation && elValues.size() != 0 && (prevValue = (IStoredVarValue)elValues.get(elValues.size() - 1)) != storedValue /* !! */ ) {
                        prevValidValue /* !! */  = prevValue.getEndTimestamp() == endTimestamp - rasterMillis && prevValue.isValid() != false ? prevValue : null;
                    }
                    elValues.clear();
                    block8: while (storedValue /* !! */ .getIntersectInterval(endTimestamp - rasterMillis, endTimestamp) > 0L) {
                        elValues.add(storedValue /* !! */ );
                        if (endTimestamp < storedValue /* !! */ .getEndTimestamp()) break;
                        if (j < storedValuesSize) {
                            storedValue /* !! */  = (IStoredVarValue)storedValues.get(j++);
                            while (storedValue /* !! */ .getStartTimestamp() == storedValue /* !! */ .getEndTimestamp()) {
                                if (j < storedValuesSize) {
                                    storedValue /* !! */  = (IStoredVarValue)storedValues.get(j++);
                                    continue;
                                }
                                storedValue /* !! */  = null;
                                continue block8;
                            }
                            continue;
                        }
                        storedValue /* !! */  = null;
                        break;
                    }
                    result.add(StoredValuesConverter.synchronizeRaster(endTimestamp, rasterMillis, elValues, aggr, prevValidValue /* !! */ ));
                    ++i;
                }
                while (i < size) {
                    result.add(VarValue.nan((long)endTimestamp));
                    ++i;
                    endTimestamp += rasterMillis;
                }
                return result;
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        catch (Throwable var13_12) {
            if (var12_9 == null) {
                var12_9 = var13_12;
            } else if (var12_9 != var13_12) {
                var12_9.addSuppressed(var13_12);
            }
            throw var12_9;
        }
    }

    public static <T extends IStoredVarValue> IVarValue[] convertStoredNoParameterValues(List<T> storedValues, long fromTs, long toTs, Raster raster, Aggregation aggr) {
        return StoredValuesConverter.convertStoredNoParameterValues(storedValues, fromTs, toTs, raster, aggr, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T extends IStoredVarValue> IVarValue[] convertStoredNoParameterValues(List<T> storedValues, long fromTs, long toTs, Raster raster, Aggregation aggr, boolean allowInterpolation) {
        if (!(storedValues instanceof RandomAccess)) {
            throw new IllegalAccessError("Stored Values does not support random access");
        }
        rasterMillis = raster.toMilli();
        if (fromTs % rasterMillis != 0L || toTs % rasterMillis != 0L) {
            throw new IllegalArgumentException("Bounds not in given raster");
        }
        result = new IVarValue[(int)((toTs - fromTs) / rasterMillis)];
        j = 0;
        elValues = new ArrayList<IStoredVarValue>(1);
        storedValue /* !! */  = null;
        prevValidValue /* !! */  = null;
        storedValuesSize = storedValues.size();
        if (storedValuesSize > 0) {
            prevValue = storedValue /* !! */ ;
            storedValue /* !! */  = (IStoredVarValue)storedValues.get(j++);
            while (storedValue /* !! */  != null) {
                prevValidValue /* !! */  = allowInterpolation != false && prevValue != null && prevValue.getEndTimestamp() == storedValue /* !! */ .getStartTimestamp() && prevValue.isValid() != false ? prevValue : null;
                if (fromTs < storedValue /* !! */ .getEndTimestamp()) break;
                prevValue = storedValue /* !! */ ;
                storedValue /* !! */  = j < storedValuesSize ? (IStoredVarValue)storedValues.get(j++) : null;
            }
        }
        endTimestamp = fromTs;
        i = 0;
        while (i < result.length) {
            endTimestamp += rasterMillis;
            if (storedValue /* !! */  != null) ** GOTO lbl29
            break;
lbl-1000:
            // 1 sources

            {
                result[i++] = VarValue.nan((long)endTimestamp);
                endTimestamp += rasterMillis;
lbl29:
                // 2 sources

                ** while (endTimestamp <= storedValue /* !! */ .getStartTimestamp())
            }
lbl30:
            // 1 sources

            if (allowInterpolation && elValues.size() != 0 && (prevValue = (IStoredVarValue)elValues.get(elValues.size() - 1)) != storedValue /* !! */ ) {
                prevValidValue /* !! */  = prevValue.getEndTimestamp() == endTimestamp - rasterMillis && prevValue.isValid() != false ? prevValue : null;
            }
            elValues.clear();
            block3: while (storedValue /* !! */ .getIntersectInterval(endTimestamp - rasterMillis, endTimestamp) > 0L) {
                elValues.add(storedValue /* !! */ );
                if (endTimestamp < storedValue /* !! */ .getEndTimestamp()) break;
                if (j < storedValuesSize) {
                    storedValue /* !! */  = (IStoredVarValue)storedValues.get(j++);
                    while (storedValue /* !! */ .getStartTimestamp() == storedValue /* !! */ .getEndTimestamp()) {
                        if (j < storedValuesSize) {
                            storedValue /* !! */  = (IStoredVarValue)storedValues.get(j++);
                            continue;
                        }
                        storedValue /* !! */  = null;
                        continue block3;
                    }
                    continue;
                }
                storedValue /* !! */  = null;
                break;
            }
            result[i++] = StoredValuesConverter.synchronizeRaster(endTimestamp, rasterMillis, elValues, aggr, prevValidValue /* !! */ );
        }
        while (i < result.length) {
            result[i++] = VarValue.nan((long)endTimestamp);
            endTimestamp += rasterMillis;
        }
        return result;
    }

    public static <T extends IStoredVarValue> IVarValue[] convertStoredParameterValues(ArrayList<T> storedValues, long fromTs, long toTs, Raster raster) {
        long rasterMillis = raster.toMilli();
        if (fromTs % rasterMillis != 0L || toTs % rasterMillis != 0L) {
            throw new IllegalArgumentException("Bounds not in given raster");
        }
        IVarValue[] result = new IVarValue[(int)((toTs - fromTs) / rasterMillis)];
        int j = 0;
        IStoredVarValue storedValue = null;
        IStoredVarValue nextStoredValue = null;
        long nextStoredValueStartTs = Long.MAX_VALUE;
        if (storedValues.size() > 0) {
            nextStoredValue = (IStoredVarValue)storedValues.get(j++);
            nextStoredValueStartTs = nextStoredValue.getStartTimestamp();
        }
        int storedValuesSize = storedValues.size();
        long startTimestamp = fromTs;
        int i = 0;
        while (i < result.length) {
            if (storedValue == null) {
                while (startTimestamp < nextStoredValueStartTs && i < result.length) {
                    result[i++] = VarValue.nan((long)(startTimestamp += rasterMillis));
                }
                if (nextStoredValue == null) {
                    return result;
                }
            }
            storedValue = nextStoredValue;
            if (j < storedValuesSize) {
                nextStoredValue = (IStoredVarValue)storedValues.get(j++);
                nextStoredValueStartTs = nextStoredValue.getStartTimestamp();
            } else {
                nextStoredValueStartTs = toTs;
            }
            if (storedValue.getStartTimestamp() == storedValue.getEndTimestamp()) {
                while (startTimestamp < nextStoredValueStartTs && i < result.length) {
                    result[i++] = storedValue.copy(startTimestamp, startTimestamp + rasterMillis);
                    startTimestamp += rasterMillis;
                }
                continue;
            }
            long lastStartTimestamp = storedValue.getEndTimestamp() - rasterMillis;
            while (startTimestamp <= lastStartTimestamp) {
                result[i++] = storedValue.copy(startTimestamp, startTimestamp + rasterMillis);
                startTimestamp += rasterMillis;
            }
            storedValue = null;
        }
        return result;
    }

    private static <T extends IStoredVarValue> IVarValue synchronizeRaster(long endTimestamp, long rasterMillis, ArrayList<T> values, Aggregation aggr, T prevValidValue) {
        switch (aggr) {
            case Last: {
                IStoredVarValue last = (IStoredVarValue)values.get(values.size() - 1);
                if (prevValidValue != null && endTimestamp < last.getEndTimestamp()) {
                    long resultEndTimestamp = Math.min(endTimestamp, last.getEndTimestamp());
                    double interpolatedValue = prevValidValue.getValue() + (last.getValue() - prevValidValue.getValue()) * (double)(resultEndTimestamp - prevValidValue.getEndTimestamp()) / (double)(last.getEndTimestamp() - prevValidValue.getEndTimestamp());
                    return last.copy(endTimestamp - rasterMillis, resultEndTimestamp, interpolatedValue);
                }
                return last.copy(endTimestamp - rasterMillis, Math.min(endTimestamp, last.getEndTimestamp()));
            }
            case LastValid: {
                int i = values.size() - 1;
                while (i >= 0) {
                    IStoredVarValue last = (IStoredVarValue)values.get(i);
                    if (last.isValid()) {
                        if (prevValidValue != null && endTimestamp < last.getEndTimestamp()) {
                            long resultEndTimestamp = Math.min(endTimestamp, last.getEndTimestamp());
                            double interpolatedValue = prevValidValue.getValue() + (last.getValue() - prevValidValue.getValue()) * (double)(resultEndTimestamp - prevValidValue.getEndTimestamp()) / (double)(last.getEndTimestamp() - prevValidValue.getEndTimestamp());
                            return last.copy(endTimestamp - rasterMillis, resultEndTimestamp, interpolatedValue);
                        }
                        return last.copy(endTimestamp - rasterMillis, Math.min(endTimestamp, last.getEndTimestamp()));
                    }
                    --i;
                }
                break;
            }
            case Sum: {
                if (values.size() == 1) {
                    IStoredVarValue val = (IStoredVarValue)values.get(0);
                    double interpolatedValue = val.getValue() * (double)rasterMillis / (double)(val.getEndTimestamp() - val.getStartTimestamp());
                    return val.copy(Math.max(val.getStartTimestamp(), endTimestamp - rasterMillis), Math.min(endTimestamp, val.getEndTimestamp()), interpolatedValue);
                }
                Long firstValidTs = null;
                Long lastValidTs = null;
                long startTimestamp = endTimestamp - rasterMillis;
                double sum = 0.0;
                double sumQuality = 0.0;
                int duration = 0;
                long intersectMillis = 0L;
                for (IStoredVarValue tmp : values) {
                    if (!tmp.isValid()) continue;
                    if (firstValidTs == null) {
                        firstValidTs = Math.max(tmp.getStartTimestamp(), startTimestamp);
                    }
                    intersectMillis = tmp.getIntersectInterval(startTimestamp, endTimestamp);
                    lastValidTs = Math.min(endTimestamp, tmp.getEndTimestamp());
                    sum += tmp.getValue();
                    sumQuality += tmp.getQuality() * (double)intersectMillis;
                    duration = (int)((long)duration + intersectMillis);
                }
                if (duration > 0) {
                    ArchiveValue archiveValue = new ArchiveValue(firstValidTs.longValue(), lastValidTs.longValue(), sum, sumQuality / (double)(lastValidTs - firstValidTs));
                    return archiveValue;
                }
                return VarValue.nan((long)endTimestamp);
            }
            case Avg: {
                if (values.size() == 1) {
                    IStoredVarValue val = (IStoredVarValue)values.get(0);
                    return val.copy(Math.max(val.getStartTimestamp(), endTimestamp - rasterMillis), Math.min(endTimestamp, val.getEndTimestamp()));
                }
                Long firstValidTs = null;
                Long lastValidTs = null;
                long startTimestamp = endTimestamp - rasterMillis;
                double sum = 0.0;
                double sumQuality = 0.0;
                int duration = 0;
                long intersectMillis = 0L;
                for (IStoredVarValue tmp : values) {
                    if (!tmp.isValid()) continue;
                    if (firstValidTs == null) {
                        firstValidTs = Math.max(tmp.getStartTimestamp(), startTimestamp);
                    }
                    intersectMillis = tmp.getIntersectInterval(startTimestamp, endTimestamp);
                    lastValidTs = Math.min(endTimestamp, tmp.getEndTimestamp());
                    sum += tmp.getValue() * (double)intersectMillis;
                    sumQuality += tmp.getQuality() * (double)intersectMillis;
                    duration = (int)((long)duration + intersectMillis);
                }
                if (duration > 0) {
                    ArchiveValue archiveValue = new ArchiveValue(firstValidTs.longValue(), lastValidTs.longValue(), sum / (double)duration, sumQuality / (double)(lastValidTs - firstValidTs));
                    return archiveValue;
                }
                return VarValue.nan((long)endTimestamp);
            }
            case Min: {
                if (values.size() == 1) {
                    IStoredVarValue val = (IStoredVarValue)values.get(0);
                    return val.copy(Math.max(val.getStartTimestamp(), endTimestamp - rasterMillis), Math.min(endTimestamp, val.getEndTimestamp()));
                }
                Long firstValidTs = null;
                long startTimestamp = endTimestamp - rasterMillis;
                IStoredVarValue minValue = null;
                long lastValidTs = endTimestamp;
                for (IStoredVarValue tmp : values) {
                    if (!tmp.isValid()) continue;
                    if (firstValidTs == null) {
                        firstValidTs = Math.max(tmp.getStartTimestamp(), startTimestamp);
                    }
                    lastValidTs = Math.min(endTimestamp, lastValidTs);
                    if (minValue != null && !(tmp.getValue() < minValue.getValue())) continue;
                    minValue = tmp;
                }
                if (minValue != null) {
                    return new ArchiveValue(firstValidTs.longValue(), lastValidTs, minValue.getValue(), minValue.getQuality());
                }
                return VarValue.nan((long)endTimestamp);
            }
            case Max: {
                if (values.size() == 1) {
                    IStoredVarValue val = (IStoredVarValue)values.get(0);
                    return val.copy(Math.max(val.getStartTimestamp(), endTimestamp - rasterMillis), Math.min(endTimestamp, val.getEndTimestamp()));
                }
                Long firstValidTs = null;
                long startTimestamp = endTimestamp - rasterMillis;
                IStoredVarValue maxValue = null;
                long lastValidTs = endTimestamp;
                for (IStoredVarValue tmp : values) {
                    if (!tmp.isValid()) continue;
                    if (firstValidTs == null) {
                        firstValidTs = Math.max(tmp.getStartTimestamp(), startTimestamp);
                    }
                    lastValidTs = Math.min(endTimestamp, lastValidTs);
                    if (maxValue != null && !(tmp.getValue() > maxValue.getValue())) continue;
                    maxValue = tmp;
                }
                if (maxValue != null) {
                    return new VarValue(Math.min(endTimestamp, lastValidTs), maxValue.getValue(), maxValue.getQuality(), Plausibility.Ok, ValueSource.Mixed);
                }
                return VarValue.nan((long)endTimestamp);
            }
            case BitOr: {
                long lastValidTs = endTimestamp;
                double bits = 0.0;
                double bitsQuality = 0.0;
                int count = 0;
                SupplementValue firstSupplValue = null;
                boolean identicalSupplement = true;
                for (IVarValue tmp : values) {
                    if (!(tmp instanceof SupplementValue)) {
                        identicalSupplement = false;
                    }
                    if (!tmp.isValid()) continue;
                    if (identicalSupplement) {
                        SupplementValue sTmp = (SupplementValue)tmp;
                        if (firstSupplValue == null) {
                            firstSupplValue = sTmp;
                        } else if (sTmp.getRecordedTimestamp() != firstSupplValue.getRecordedTimestamp() || sTmp.getUserId() != firstSupplValue.getUserId()) {
                            identicalSupplement = false;
                        }
                    }
                    lastValidTs = tmp.getEndTimestamp();
                    bits = (int)bits | (int)tmp.getValue();
                    bitsQuality += tmp.getQuality();
                    ++count;
                }
                if (count > 0) {
                    if (identicalSupplement && firstSupplValue != null) {
                        return firstSupplValue.copy(firstSupplValue.getStartTimestamp(), lastValidTs, bits);
                    }
                    return new VarValue(endTimestamp, bits, bitsQuality / (double)values.size(), ValueSource.Mixed);
                }
                return VarValue.nan((long)endTimestamp);
            }
            case BitAnd: {
                long lastValidTs = endTimestamp;
                double bits = 0.0;
                double bitsQuality = 0.0;
                int count = 0;
                SupplementValue firstSupplValue = null;
                boolean identicalSupplement = true;
                for (IVarValue tmp : values) {
                    if (!(tmp instanceof SupplementValue)) {
                        identicalSupplement = false;
                    }
                    if (!tmp.isValid()) continue;
                    if (identicalSupplement) {
                        SupplementValue sTmp = (SupplementValue)tmp;
                        if (firstSupplValue == null) {
                            firstSupplValue = sTmp;
                        } else if (sTmp.getRecordedTimestamp() != firstSupplValue.getRecordedTimestamp() || sTmp.getUserId() != firstSupplValue.getUserId()) {
                            identicalSupplement = false;
                        }
                    }
                    lastValidTs = tmp.getEndTimestamp();
                    bits = (int)bits & (int)tmp.getValue();
                    bitsQuality += tmp.getQuality();
                    ++count;
                }
                if (count > 0) {
                    if (identicalSupplement && firstSupplValue != null) {
                        return firstSupplValue.copy(firstSupplValue.getStartTimestamp(), lastValidTs, bits);
                    }
                    return new VarValue(endTimestamp, bits, bitsQuality / (double)values.size(), ValueSource.Mixed);
                }
                return VarValue.nan((long)endTimestamp);
            }
        }
        return VarValue.nan((long)endTimestamp);
    }
}

