/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.rasterizedvalues;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.server.model.VariableInstanceValuesValidator;
import java.util.List;

class SupplementValuesHackValidator
implements IVarValueValidator {
    private final VariableInstanceValuesValidator iv;
    private final long fromTs;
    private final long toTs;
    private final Raster raster;
    private final List<SupplementValue> supplementValues;
    private final SupplementValueStrategy supplementStrategy;
    private final Aggregation aggregation;
    private int supplementIndex = 0;
    private SupplementValue supplementValue = null;
    private SupplementValue prevSupplementValue = null;
    private IVarValue prevInterpolationValue = null;

    public SupplementValuesHackValidator(VariableInstance instance, List<SupplementValue> supplementValues, long fromTs, long toTs, Raster raster, SupplementValueStrategy supplementStrategy, Aggregation aggregation) {
        this.iv = instance.getResultValuesBounds() != null ? new VariableInstanceValuesValidator(instance) : null;
        this.fromTs = fromTs;
        this.toTs = toTs;
        this.raster = raster;
        this.supplementValues = supplementValues;
        this.supplementValue = supplementValues.get(0);
        this.supplementStrategy = supplementStrategy;
        this.aggregation = aggregation;
    }

    public IVarValue validate(IVarValue val) {
        Object result;
        block11: {
            block12: {
                block13: {
                    long valStartTs;
                    long valEndTs;
                    block10: {
                        if (val.getEndTimestamp() <= this.fromTs || val.getEndTimestamp() > this.toTs) {
                            return val;
                        }
                        valEndTs = this.raster.getRasterEnd(val.getEndTimestamp());
                        valStartTs = this.raster.getRasterEnd(val.getEndTimestamp()) - this.raster.toMilli();
                        while (this.supplementValue != null && this.supplementValue.getEndTimestamp() <= valStartTs) {
                            this.nextSupplementValue();
                        }
                        if (this.supplementStrategy != SupplementValueStrategy.Unrasterized) break block10;
                        result = this.prevSupplementValue != null && this.prevSupplementValue.getStartTimestamp() <= valStartTs ? this.prevSupplementValue.copy(valStartTs, valEndTs) : val;
                        break block11;
                    }
                    if (this.supplementStrategy != SupplementValueStrategy.Rasterized) break block12;
                    if (this.supplementValue == null || this.supplementValue.getIntersectInterval(valStartTs, valEndTs) <= 0L) break block13;
                    switch (this.aggregation) {
                        case Avg: 
                        case Min: 
                        case Max: 
                        case BitOr: 
                        case BitAnd: {
                            result = this.supplementValue.copy(valStartTs, valEndTs);
                            break block11;
                        }
                        case Sum: {
                            double dVal = this.supplementValue.getValue() * ((double)(valEndTs - valStartTs) / (double)(this.supplementValue.getEndTimestamp() - this.supplementValue.getStartTimestamp()));
                            result = this.supplementValue.copy(valStartTs, valEndTs, dVal);
                            break block11;
                        }
                        case LastValid: {
                            if (this.prevInterpolationValue == null || !this.prevInterpolationValue.isValid() || this.prevInterpolationValue.getEndTimestamp() < this.supplementValue.getStartTimestamp()) {
                                result = this.supplementValue.copy(valStartTs, valEndTs);
                            } else {
                                double interpolatedValue = this.prevInterpolationValue.getValue() + (this.supplementValue.getValue() - this.prevInterpolationValue.getValue()) * (double)(valEndTs - this.prevInterpolationValue.getEndTimestamp()) / (double)(this.supplementValue.getEndTimestamp() - this.prevInterpolationValue.getEndTimestamp());
                                result = this.supplementValue.copy(valStartTs, valEndTs, interpolatedValue);
                            }
                            if (this.supplementValue.getEndTimestamp() == valEndTs) {
                                this.prevInterpolationValue = result;
                            }
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                this.prevInterpolationValue = result = val;
                break block11;
            }
            throw new IllegalStateException("Not a supplement type variable instance!");
        }
        return this.iv != null ? this.iv.validate((IVarValue)result) : result;
    }

    private void nextSupplementValue() {
        this.prevSupplementValue = this.supplementValue;
        this.prevInterpolationValue = this.supplementValue;
        this.supplementValue = this.supplementIndex < this.supplementValues.size() - 1 ? this.supplementValues.get(++this.supplementIndex) : null;
    }
}

