/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.roles;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.elpro.ewms.core.characteristic.ICharacteristic2DRole;
import de.elpro.ewms.core.characteristic.ICharacteristic3DRole;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.variable.IVariableRole;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class Roles {
    public static final String EXTENSION_POINT_ID = "de.elpro.ewms.server.roles";
    private static final Map<String, IStructureClassRole> CLASS_ROLES = new TreeMap<String, IStructureClassRole>();
    private static final Map<String, IVariableRole> VARIABLE_ROLES = new TreeMap<String, IVariableRole>();
    private static final Multimap<String, IVariableRole> CLASS_VARIABLE_ROLES = HashMultimap.create();
    private static final Map<String, ICharacteristic2DRole> CHARACTERISTIC_2D_ROLES = new TreeMap<String, ICharacteristic2DRole>();
    private static final Multimap<String, ICharacteristic2DRole> CLASS_CHARACTERISTIC_2D_ROLES = HashMultimap.create();
    private static final Map<String, ICharacteristic3DRole> CHARACTERISTIC_3D_ROLES = new TreeMap<String, ICharacteristic3DRole>();
    private static final Multimap<String, ICharacteristic3DRole> CLASS_CHARACTERISTIC_3D_ROLES = HashMultimap.create();

    public static IStructureClassRole[] getClassRoles() {
        return CLASS_ROLES.values().toArray(new IStructureClassRole[0]);
    }

    public static IStructureClassRole getClassRole(String classRoleId) {
        return CLASS_ROLES.get(classRoleId);
    }

    public static void addClassRole(IStructureClassRole classRole) throws Exception {
        if (CLASS_ROLES.containsKey(classRole.getId())) {
            throw new Exception(String.format("Class role with id '%s' allready exists", classRole.getId()));
        }
        CLASS_ROLES.put(classRole.getId(), classRole);
    }

    public static IVariableRole getVariableRole(String variableRoleId) {
        return VARIABLE_ROLES.get(variableRoleId);
    }

    public static Collection<IVariableRole> getVariableRoles(String classRoleId) {
        return Collections.unmodifiableCollection(CLASS_VARIABLE_ROLES.get((Object)classRoleId));
    }

    public static void addVariableRole(IVariableRole variableRole) throws Exception {
        if (VARIABLE_ROLES.containsKey(variableRole.getId())) {
            throw new Exception(String.format("Variable role with id '%s' allready exists", variableRole.getId()));
        }
        VARIABLE_ROLES.put(variableRole.getId(), variableRole);
        CLASS_VARIABLE_ROLES.put((Object)variableRole.getClassRoleId(), (Object)variableRole);
    }

    public static Collection<IVariableRole> getAllVariableRoles() {
        return Collections.unmodifiableCollection(VARIABLE_ROLES.values());
    }

    public static ICharacteristic2DRole getCharacteristic2DRole(String characteristic2DRoleId) {
        return CHARACTERISTIC_2D_ROLES.get(characteristic2DRoleId);
    }

    public static Collection<ICharacteristic2DRole> getCharacteristic2DRoles(String classRoleId) {
        return Collections.unmodifiableCollection(CLASS_CHARACTERISTIC_2D_ROLES.get((Object)classRoleId));
    }

    public static void addCharacteristic2DRole(ICharacteristic2DRole characteristic2DRole) throws Exception {
        if (CHARACTERISTIC_2D_ROLES.containsKey(characteristic2DRole.getId())) {
            throw new Exception(String.format("Characteristic2D role with id '%s' allready exists", characteristic2DRole.getId()));
        }
        CHARACTERISTIC_2D_ROLES.put(characteristic2DRole.getId(), characteristic2DRole);
        CLASS_CHARACTERISTIC_2D_ROLES.put((Object)characteristic2DRole.getClassRoleId(), (Object)characteristic2DRole);
    }

    public static Collection<ICharacteristic3DRole> getAllCharacteristic3DRoles() {
        return Collections.unmodifiableCollection(CHARACTERISTIC_3D_ROLES.values());
    }

    public static ICharacteristic3DRole getCharacteristic3DRole(String characteristic3DRoleId) {
        return CHARACTERISTIC_3D_ROLES.get(characteristic3DRoleId);
    }

    public static Collection<ICharacteristic3DRole> getCharacteristic3DRoles(String classRoleId) {
        return Collections.unmodifiableCollection(CLASS_CHARACTERISTIC_3D_ROLES.get((Object)classRoleId));
    }

    public static void addCharacteristic3DRole(ICharacteristic3DRole characteristic3DRole) throws Exception {
        if (CHARACTERISTIC_3D_ROLES.containsKey(characteristic3DRole.getId())) {
            throw new Exception(String.format("Characteristic3D role with id '%s' allready exists", characteristic3DRole.getId()));
        }
        CHARACTERISTIC_3D_ROLES.put(characteristic3DRole.getId(), characteristic3DRole);
        CLASS_CHARACTERISTIC_3D_ROLES.put((Object)characteristic3DRole.getClassRoleId(), (Object)characteristic3DRole);
    }

    public static Collection<ICharacteristic2DRole> getAllCharacteristic2DRoles() {
        return Collections.unmodifiableCollection(CHARACTERISTIC_2D_ROLES.values());
    }
}

