/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.schedules;

import com.google.gson.GsonBuilder;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component(service={ScheduleJobDefinition.class})
public class DemoPlayerJob
extends ScheduleJobDefinition {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DemoPlayerJob.class.getName());
    private static MeasurementsPlayer player = null;
    private static final Options defaultOptions = new Options();

    public DemoPlayerJob() {
        super("de.elpro.ewms.server.schedules.demoplayerjob", "Play Measurements Values (DEMO) Job", defaultOptions.toString(), null);
    }

    @Override
    public void run(Schedule schedule, Instant executionTimestamp) {
        if (player == null) {
            return;
        }
        Raster raster = schedule.getExecutionInterval().getRaster();
        if (raster == null) {
            return;
        }
        long currentTime = DemoPlayerJob.player.currentTime;
        long nextTime = currentTime + raster.toMilli() * (long)Math.max(1, DemoPlayerJob.player.ticksPerExecution);
        Map<VariableInstance, List<MeasuredValue>> addMV = player.tick(nextTime);
        if (!addMV.isEmpty()) {
            MeasurementsPool.appendValues(addMV);
            if (DemoPlayerJob.player.syncApplyChanges) {
                try {
                    MeasurementsPool.applyChanges(true);
                }
                catch (Exception e) {
                    logger.error("Error applying Measurement Changes", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void start(Schedule schedule) {
        super.start(schedule);
        String optionsStr = schedule.getOptions();
        Options options = defaultOptions;
        if (optionsStr != null && !optionsStr.isBlank()) {
            try {
                options = Options.parse(optionsStr);
            }
            catch (Exception e) {
                logger.error("Error parsing options", (Throwable)e);
            }
        }
        Instant beginTs = ZonedDateTime.of(schedule.getJobBegin(), ZoneId.systemDefault()).toInstant();
        RasterizedValues.ComputationBounds realtimeBounds = Server.getRawValuesViews().getRealtimeView().getComputationBounds();
        Instant realtimeEnd = realtimeBounds != null ? Instant.ofEpochMilli(realtimeBounds.getValuesEndTs()) : beginTs;
        Instant initTime = realtimeEnd.isAfter(beginTs) ? realtimeEnd : beginTs;
        player = new MeasurementsPlayer(options.getTicksPerExecution(), options.isSyncApplyChanges(), initTime);
    }

    @Override
    public void stop(Schedule schedule) {
        super.stop(schedule);
        player = null;
    }

    private static class MeasurementsPlayer {
        private final int ticksPerExecution;
        private final boolean syncApplyChanges;
        private long currentTime;
        private Long clusterEndTs = null;
        private final Raster raster = Server.getConfig().getRawValuesClusterSize();
        private Map<VariableInstance, MeasuredValue> pendingValuesBuffer = new HashMap<VariableInstance, MeasuredValue>();
        private Map<VariableInstance, Iterator<IVarValue>> clusterIterators;

        public MeasurementsPlayer(int ticksPerExecution, boolean syncApplyChanges, Instant initTime) {
            this.ticksPerExecution = ticksPerExecution;
            this.syncApplyChanges = syncApplyChanges;
            this.currentTime = initTime.toEpochMilli();
            this.clusterEndTs = this.raster.getRasterEnd(initTime.toEpochMilli());
            this.readCluster();
        }

        private void readCluster() {
            long clusterFromTs = this.clusterEndTs - this.raster.toMilli();
            try {
                Map<VariableInstance, IVarValuesCollection> valuesMap = MeasurementsStorage.getInstance().readMeasurements(clusterFromTs, this.clusterEndTs);
                this.clusterIterators = new HashMap<VariableInstance, Iterator<IVarValue>>();
                for (Map.Entry<VariableInstance, IVarValuesCollection> iv : valuesMap.entrySet()) {
                    this.clusterIterators.put(iv.getKey(), iv.getValue().iterator());
                }
            }
            catch (Exception e) {
                logger.error("Error reading clusters", (Throwable)e);
            }
        }

        private void readValues(long upToTs, Map<Integer, VariableInstance> allowedInstances, Map<VariableInstance, List<MeasuredValue>> addMV) {
            block0: for (Map.Entry<VariableInstance, Iterator<IVarValue>> entry : DemoPlayerJob.player.clusterIterators.entrySet()) {
                VariableInstance instance = allowedInstances.get(entry.getKey().getId());
                if (instance == null) continue;
                MeasuredValue pendingValue = this.pendingValuesBuffer.get(instance);
                if (pendingValue != null) {
                    if (pendingValue.getEndTimestamp() > upToTs) continue;
                    List<MeasuredValue> mvList = addMV.get(instance);
                    if (mvList == null) {
                        mvList = new ArrayList<MeasuredValue>();
                        addMV.put(instance, mvList);
                    }
                    mvList.add(pendingValue);
                    this.pendingValuesBuffer.remove(instance);
                }
                Iterator<IVarValue> iterator = entry.getValue();
                while (iterator.hasNext()) {
                    MeasuredValue mv = (MeasuredValue)iterator.next();
                    if (mv.getEndTimestamp() <= this.currentTime) continue;
                    if (mv.getEndTimestamp() <= upToTs) {
                        List<MeasuredValue> mvList = addMV.get(instance);
                        if (mvList == null) {
                            mvList = new ArrayList<MeasuredValue>();
                            addMV.put(instance, mvList);
                        }
                        mvList.add(mv);
                    } else {
                        this.pendingValuesBuffer.put(instance, mv);
                    }
                    if (mv.getEndTimestamp() >= upToTs) continue block0;
                }
            }
        }

        private Map<VariableInstance, List<MeasuredValue>> tick(long toTs) {
            HashMap<Integer, VariableInstance> instances = new HashMap<Integer, VariableInstance>();
            ORMCache.getVariableInstances().stream().forEach(i -> {
                VariableInstance variableInstance = instances.put(i.getId(), (VariableInstance)i);
            });
            HashMap<VariableInstance, List<MeasuredValue>> addMV = new HashMap<VariableInstance, List<MeasuredValue>>();
            this.readValues(toTs, instances, addMV);
            while (this.clusterEndTs < toTs) {
                this.clusterEndTs = this.clusterEndTs + this.raster.toMilli();
                this.readCluster();
                this.readValues(toTs, instances, addMV);
            }
            this.currentTime = toTs;
            return addMV;
        }
    }

    private static class Options {
        private static final GsonBuilder builder = new GsonBuilder();
        private int ticksPerExecution = 1;
        private boolean syncApplyChanges = true;

        private Options() {
        }

        public int getTicksPerExecution() {
            return this.ticksPerExecution;
        }

        public boolean isSyncApplyChanges() {
            return this.syncApplyChanges;
        }

        public static Options parse(String text) {
            return (Options)builder.create().fromJson(text, Options.class);
        }

        public String toString() {
            return builder.create().toJson((Object)this);
        }
    }
}

