/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.schedules;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.db.rawmeasurements.MeasurementsStorageUtils;
import de.elpro.ewms.server.helpers.StructureClassRoleHelper;
import de.elpro.ewms.server.helpers.VariableRoleHelper;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import de.elpro.ewms.server.schedules.OpenWeatherClientConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component(service={ScheduleJobDefinition.class})
public class ImportWeatherForecastJob
extends ScheduleJobDefinition {
    public static final String ID = "com.eos.server.schedules.import_weather_forecast_job";
    public static final String API_URL = "https://api.openweathermap.org/data/2.5/forecast?lat=%f&lon=%f&units=metric&APPID=%s";
    public static final String CONFIG_JSON = "[{\n\tobject_key: \"obj_key\",\n\turl: \"%s\"\n}]";
    @Inject
    @Log
    private transient Logger logger;

    public ImportWeatherForecastJob() {
        super(ID, "Import Weather Forecast", new OpenWeatherClientConfig("4a09fe1a87e0d97fc5ec82375c32bf0a", new OpenWeatherClientConfig.StructureObjectLocation("elpro", 52.54599480252323, 13.521857327607062)).toJson(), "");
    }

    @Override
    public void run(Schedule schedule, Instant executionTimestamp) {
        try {
            OpenWeatherClientConfig config = OpenWeatherClientConfig.parse(schedule.getOptions());
            String appId = config.getAppId();
            OpenWeatherClientConfig.StructureObjectLocation[] structureObjectLocationArray = config.getObjectLocations();
            int n = structureObjectLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                OpenWeatherClientConfig.StructureObjectLocation objectLocation = structureObjectLocationArray[n2];
                if (objectLocation.getStructureObjectKey() != null && !objectLocation.getStructureObjectKey().isBlank()) {
                    String url = String.format(Locale.US, API_URL, objectLocation.getLatitude(), objectLocation.getLongitude(), appId);
                    this.importWeatherForObject(objectLocation.getStructureObjectKey(), url);
                }
                ++n2;
            }
        }
        catch (JsonParseException e) {
            this.logger.error("json parsing failed", (Throwable)e);
            return;
        }
    }

    private void importWeatherForObject(String objectKey, String url) {
        String content;
        VariableInstance tempeartureVarInstance;
        StructureObject object;
        HashMap<VariableInstance, IVarValuesCollection> r = new HashMap<VariableInstance, IVarValuesCollection>();
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            try {
                object = this.getGUW(em, objectKey);
                tempeartureVarInstance = VariableRoleHelper.getVariableInstance(em, "com.eos.core.roles.variables.OpenWeather_T", object);
            }
            catch (IllegalConfigException exc) {
                this.logger.errorf("Could not load variable instances for role", (Throwable)exc, new Object[]{"com.eos.core.roles.variables.OpenWeather_T"});
                em.close();
                return;
            }
            catch (IllegalArgumentException exc) {
                this.logger.error("Could not find openweather object", (Throwable)exc);
                em.close();
                return;
            }
        }
        try {
            content = ImportWeatherForecastJob.fetchContent(url);
        }
        catch (IOException exc) {
            this.logger.error("Error loading content from url", (Throwable)exc);
            return;
        }
        JsonObject jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
        JsonArray weatherList = jsonObject.get("list").getAsJsonArray();
        int elementsCount = weatherList.size();
        int neededInterpolationSteps = 0;
        if (weatherList.size() > 1) {
            int timeStep0 = weatherList.get(0).getAsJsonObject().get("dt").getAsInt();
            int timeStep1 = weatherList.get(1).getAsJsonObject().get("dt").getAsInt();
            int timeDelta = timeStep1 - timeStep0;
            neededInterpolationSteps = Math.max(1, timeDelta / 3600);
        }
        try (IVarValuesCollection valuesCollection = new IVarValuesCollection();){
            int pos = 0;
            while (pos < elementsCount) {
                JsonObject weatherEntry = weatherList.get(pos).getAsJsonObject();
                double temp = weatherEntry.get("main").getAsJsonObject().get("temp").getAsDouble();
                String timeStampString = weatherEntry.get("dt").getAsString();
                long timeStart = Long.parseLong(String.format("%1$-13s", timeStampString).replace(' ', '0'));
                timeStart = Raster.Hour.getRasterBegin(timeStart);
                long timeEnd = timeStart + Raster.Hour.toMilli();
                MeasuredValue svTemperature = new MeasuredValue(timeStart, timeEnd, temp, 0.7);
                valuesCollection.add((IVarValue)svTemperature);
                if (pos + 1 < elementsCount && neededInterpolationSteps > 1) {
                    JsonObject weatherEntryNext = weatherList.get(pos + 1).getAsJsonObject();
                    double tempNext = weatherEntryNext.get("main").getAsJsonObject().get("temp").getAsDouble();
                    double rise = (tempNext - temp) / (double)neededInterpolationSteps;
                    int i = 1;
                    while (i < neededInterpolationSteps) {
                        timeEnd = (timeStart += Raster.Hour.toMilli()) + Raster.Hour.toMilli();
                        MeasuredValue svTemperatureInterpolated = new MeasuredValue(timeStart, timeEnd, temp += rise, 0.5);
                        valuesCollection.add((IVarValue)svTemperatureInterpolated);
                        ++i;
                    }
                }
                ++pos;
            }
        }
        r.put(tempeartureVarInstance, valuesCollection);
        this.logger.infof("%s: %d predicted temperature values into %s imported.", new Object[]{object, valuesCollection.size(), tempeartureVarInstance.getVariable()});
        try {
            MeasurementsStorageUtils.importPredictedValues(r, true);
        }
        catch (Exception e) {
            this.logger.error("could not import measurements", (Throwable)e);
        }
    }

    private static String fetchContent(String uri) throws IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        return null;
    }

    private StructureObject getGUW(EntityManager em, String objectKey) throws IllegalArgumentException {
        StructureObject[] allObjects;
        StructureObject[] structureObjectArray = allObjects = StructureClassRoleHelper.getObjectsByRole(em, "com.eos.core.roles.classes.OpenWeatherClient");
        int n = allObjects.length;
        int n2 = 0;
        while (n2 < n) {
            StructureObject structureObject = structureObjectArray[n2];
            if (!structureObject.getKey().isBlank() && objectKey.trim().toLowerCase().equals(structureObject.getKey().trim().toLowerCase())) {
                return structureObject;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Structure Object by objectKey " + objectKey + " not found");
    }
}

