/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.schedules;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarInstanceValuesCollectionMap;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.db.rawmeasurements.MeasurementsStorageUtils;
import de.elpro.ewms.server.helpers.StructureClassRoleHelper;
import de.elpro.ewms.server.helpers.VariableRoleHelper;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import de.elpro.ewms.server.schedules.OpenWeatherClientConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Locale;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component(service={ScheduleJobDefinition.class})
public class ImportWeatherNowJob
extends ScheduleJobDefinition {
    public static final String ID = "com.eos.server.schedules.import_weather_now_job";
    public static final String API_URL = "https://api.openweathermap.org/data/2.5/weather?lat=%f&lon=%f&units=metric&APPID=%s";
    private transient MeasuredValue lastTempMv;
    @Inject
    @Log
    private transient Logger logger;

    public ImportWeatherNowJob() {
        super(ID, "Import Weather Now", new OpenWeatherClientConfig("4a09fe1a87e0d97fc5ec82375c32bf0a", new OpenWeatherClientConfig.StructureObjectLocation("elpro", 52.54599480252323, 13.521857327607062)).toJson(), "");
    }

    @Override
    public void run(Schedule schedule, Instant executionTimestamp) {
        try {
            OpenWeatherClientConfig config = OpenWeatherClientConfig.parse(schedule.getOptions());
            String appId = config.getAppId();
            OpenWeatherClientConfig.StructureObjectLocation[] structureObjectLocationArray = config.getObjectLocations();
            int n = structureObjectLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                OpenWeatherClientConfig.StructureObjectLocation objectLocation = structureObjectLocationArray[n2];
                if (objectLocation.getStructureObjectKey() != null && !objectLocation.getStructureObjectKey().isBlank()) {
                    String url = String.format(Locale.US, API_URL, objectLocation.getLatitude(), objectLocation.getLongitude(), appId);
                    this.importWeatherForObject(objectLocation.getStructureObjectKey(), url);
                }
                ++n2;
            }
        }
        catch (JsonParseException e) {
            this.logger.error("json parsing failed", (Throwable)e);
            return;
        }
    }

    private void importWeatherForObject(String objectKey, String url) {
        String content;
        VariableInstance tempeartureVarInstance;
        StructureObject chosenGUW;
        VarInstanceValuesCollectionMap values = new VarInstanceValuesCollectionMap();
        Raster realtimeValuesRaster = Server.getRawValuesViews().getRealtimeView().getRaster();
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            try {
                chosenGUW = this.getObject(em, objectKey);
                tempeartureVarInstance = VariableRoleHelper.getVariableInstance(em, "com.eos.core.roles.variables.OpenWeather_T", chosenGUW);
            }
            catch (IllegalArgumentException ex) {
                this.logger.error("Could not find openweather object", (Throwable)ex);
                em.close();
                return;
            }
            catch (IllegalConfigException ex) {
                this.logger.error("Could not load variable instances", (Throwable)ex);
                em.close();
                return;
            }
        }
        try {
            content = ImportWeatherNowJob.fetchContent(url);
        }
        catch (IOException exc) {
            this.logger.error("Error loading content from url", (Throwable)exc);
            return;
        }
        JsonObject jsonObject = JsonParser.parseString((String)content).getAsJsonObject();
        double temp = jsonObject.get("main").getAsJsonObject().get("temp").getAsDouble();
        if (!Double.isFinite(temp)) {
            return;
        }
        String timestampString = jsonObject.get("dt").getAsString();
        long timestamp = Long.parseLong(String.format("%1$-13s", timestampString).replace(' ', '0'));
        long timeEnd = realtimeValuesRaster.getRasterEnd(timestamp);
        long timeStart = timeEnd - realtimeValuesRaster.toMilli();
        if (this.lastTempMv != null && timeEnd == this.lastTempMv.getEndTimestamp() && Double.compare(temp, this.lastTempMv.getValue()) == 0) {
            return;
        }
        Throwable throwable = null;
        Object var20_22 = null;
        try (IVarValuesCollection guwPlusTVals = new IVarValuesCollection();){
            long timeDelta;
            MeasuredValue mv = null;
            long l = timeDelta = this.lastTempMv != null ? timeEnd - this.lastTempMv.getEndTimestamp() : 0L;
            if (timeDelta > 0L && timeDelta < Raster.Hour.toMilli()) {
                long interpolatedValueEndTs = this.lastTempMv.getEndTimestamp();
                while (interpolatedValueEndTs < timeEnd) {
                    double ratio = (double)((interpolatedValueEndTs += realtimeValuesRaster.toMilli()) - this.lastTempMv.getEndTimestamp()) / (double)(timeEnd - this.lastTempMv.getEndTimestamp());
                    double interpolatedTemp = this.lastTempMv.getValue() + (temp - this.lastTempMv.getValue()) * ratio;
                    mv = new MeasuredValue(interpolatedValueEndTs - realtimeValuesRaster.toMilli(), interpolatedValueEndTs, interpolatedTemp, 1.0);
                    guwPlusTVals.add((IVarValue)mv);
                }
            } else {
                mv = new MeasuredValue(timeStart, timeEnd, temp, 1.0);
                guwPlusTVals.add((IVarValue)mv);
            }
            values.put(tempeartureVarInstance, guwPlusTVals);
            this.lastTempMv = mv;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.logger.debugf("Temperature for %s at %s: %.1f [C\u00b0]", new Object[]{chosenGUW, LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()), temp});
        try {
            MeasurementsStorageUtils.importMeasurements(values, true);
        }
        catch (Exception e) {
            this.logger.error("could not import measurements", (Throwable)e);
        }
    }

    private static String fetchContent(String uri) throws IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                return response.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private StructureObject getObject(EntityManager em, String objectKey) throws IllegalArgumentException {
        StructureObject[] guwObjects;
        StructureObject[] structureObjectArray = guwObjects = StructureClassRoleHelper.getObjectsByRole(em, "com.eos.core.roles.classes.OpenWeatherClient");
        int n = guwObjects.length;
        int n2 = 0;
        while (n2 < n) {
            StructureObject structureObject = structureObjectArray[n2];
            if (!structureObject.getKey().isBlank() && objectKey.trim().toLowerCase().equals(structureObject.getKey().trim().toLowerCase())) {
                return structureObject;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Structure Object by objectKey " + objectKey + " not found");
    }
}

