/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.schedules;

import de.elpro.ewms.core.schedules.JobDescriptor;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.model.IScheduleJob;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.eclipse.fx.core.log.Logger;

public class Jobs {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Jobs.class.getName());
    private static final Map<String, ScheduleJobDefinition> jobs = new HashMap<String, ScheduleJobDefinition>();
    private static final Map<Integer, JobThread> workers = new HashMap<Integer, JobThread>();

    static {
        TransactionChangeset.addPostCommitEventHandler(Schedule.class, (modifications, properties) -> {
            for (Modification scheduleModification : modifications) {
                Schedule schedule = (Schedule)scheduleModification.getObject();
                try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
                    Schedule modifiedSchedule = (Schedule)em.find(Schedule.class, (Object)schedule.getId());
                    if (modifiedSchedule != null) {
                        Jobs.updateSchedule(modifiedSchedule);
                        continue;
                    }
                    Jobs.removeSchedule(schedule);
                }
            }
        });
    }

    public static final void addJob(ScheduleJobDefinition scheduleJob) {
        jobs.put(scheduleJob.getJobId(), scheduleJob);
    }

    public static Collection<JobDescriptor> getDescriptors() {
        return jobs.values().stream().collect(Collectors.toList());
    }

    public static IScheduleJob getJob(String jobId) {
        return jobs.get(jobId);
    }

    public static void executeSync(int scheduleId) {
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            Schedule schedule = (Schedule)em.createQuery("SELECT o FROM Schedule o WHERE o.id = :id", Schedule.class).setParameter("id", (Object)scheduleId).getSingleResultOrNull();
            if (schedule == null) {
                return;
            }
            IScheduleJob job = Jobs.getJob(schedule.getJobId());
            if (job != null) {
                job.run(schedule, Instant.now());
            }
        }
    }

    public static void initSchedules() {
        try (EntityManager em = Server.getEntityManagerFactory().createEntityManager();){
            for (Schedule schedule : em.createQuery("SELECT o FROM Schedule o WHERE o.active IS NULL OR o.active = TRUE", Schedule.class).getResultList()) {
                IScheduleJob job = Jobs.getJob(schedule.getJobId());
                if (job == null) {
                    logger.error(String.format("Job Definition for Job ID '%s' not found.", schedule.getJobId()));
                    continue;
                }
                JobThread jt = workers.get(schedule.getId());
                if (jt != null) {
                    jt.interrupt();
                }
                jt = new JobThread(schedule, job);
                job.start(schedule);
                jt.start();
                workers.put(schedule.getId(), jt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSchedule(Schedule schedule) {
        String string = schedule.getJobId();
        synchronized (string) {
            IScheduleJob job = Jobs.getJob(schedule.getJobId());
            JobThread jt = workers.remove(schedule.getId());
            if (jt != null) {
                jt.interrupt();
                if (job != null) {
                    job.stop(schedule);
                }
            }
            if (job == null) {
                logger.error(String.format("Job Definition for Job ID '%s' not found.", schedule.getJobId()));
                return;
            }
            if (schedule.isActive()) {
                jt = new JobThread(schedule, job);
                job.start(schedule);
                jt.start();
                workers.put(schedule.getId(), jt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeSchedule(Schedule schedule) {
        String string = schedule.getJobId();
        synchronized (string) {
            IScheduleJob job = Jobs.getJob(schedule.getJobId());
            JobThread jt = workers.remove(schedule.getId());
            if (jt != null) {
                jt.interrupt();
                if (job != null) {
                    job.stop(schedule);
                }
            }
        }
    }

    private static class JobThread
    extends Thread {
        public JobThread(final Schedule schedule, final IScheduleJob job) {
            super(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    interval = schedule.getExecutionInterval();
                    jobEnd = schedule.getJobEnd() != null ? schedule.getJobEnd().atZone(ZoneOffset.systemDefault()).toInstant() : null;
                    now = Instant.now();
                    if (jobEnd != null && now.isAfter(jobEnd)) {
                        return;
                    }
                    jobBegin = schedule.getJobBegin().atZone(ZoneOffset.systemDefault()).toInstant();
                    executionOffset = jobBegin.toEpochMilli() - (jobBegin.equals(interval.getRasterEnd(jobBegin)) != false ? jobBegin.toEpochMilli() : interval.getRasterBegin(jobBegin).toEpochMilli());
                    nextExecutionTime = interval.getRasterBegin(now).plusMillis(executionOffset);
                    if (!nextExecutionTime.isBefore(now)) ** GOTO lbl29
                    nextExecutionTime = interval.getRasterEnd(nextExecutionTime.plusMillis(1L)).plusMillis(executionOffset);
                    ** GOTO lbl29
                    {
                        try {
                            Thread.sleep(nextExecutionTime.toEpochMilli() - now.toEpochMilli());
                        }
                        catch (InterruptedException v0) {
                            return;
                        }
                        do {
                            if ((now = Instant.now()).isBefore(nextExecutionTime)) continue block4;
                            try {
                                job.run(schedule, nextExecutionTime);
                            }
                            catch (Exception exc) {
                                Jobs.logger.error(String.format("Error occured during execution of '%s' schedule job", new Object[]{schedule.getName()}), (Throwable)exc);
                            }
                            do {
                                nextExecutionTime = interval.getRasterEnd(nextExecutionTime.plusMillis(1L)).plusMillis(executionOffset);
                            } while ((now = Instant.now()).isAfter(nextExecutionTime));
                            if (jobEnd == null || !nextExecutionTime.isAfter(jobEnd)) continue;
                            return;
lbl29:
                            // 3 sources

                        } while (!JobThread.interrupted());
                    }
                }
            }, schedule.getName());
        }
    }
}

