/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.schedules;

import de.elpro.ewms.core.json.JsonUtils;

public class OpenWeatherClientConfig {
    private String appId;
    private StructureObjectLocation[] objectLocations;

    public OpenWeatherClientConfig(String appId, StructureObjectLocation ... objectLocations) {
        this.appId = appId;
        this.objectLocations = objectLocations;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public StructureObjectLocation[] getObjectLocations() {
        return this.objectLocations;
    }

    public void setObjectLocations(StructureObjectLocation[] objectLocations) {
        this.objectLocations = objectLocations;
    }

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static OpenWeatherClientConfig parse(String json) {
        return (OpenWeatherClientConfig)JsonUtils.GSON.fromJson(json, OpenWeatherClientConfig.class);
    }

    public static class StructureObjectLocation {
        private String structureObjectKey;
        private double latitude;
        private double longitude;

        public StructureObjectLocation(String structureObjectKey, double latitude, double longitude) {
            this.structureObjectKey = structureObjectKey;
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public String getStructureObjectKey() {
            return this.structureObjectKey;
        }

        public void setStructureObjectKey(String structureObjectKey) {
            this.structureObjectKey = structureObjectKey;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }
    }
}

