/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.schedules;

import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import de.elpro.ewms.server.storage.ArchiveStorages;
import de.elpro.ewms.server.supplement.SupplementStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.core.log.Logger;

public class ValuesDBBackupJob
extends ScheduleJobDefinition {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ValuesDBBackupJob.class.getName());
    private static final DateTimeFormatter tsFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmm");

    public ValuesDBBackupJob() {
        super("de.elpro.ewms.server.schedules.valuesdbbackupjob", "Backup Values Databases", null, null);
    }

    @Override
    public void run(Schedule schedule, Instant executionTimestamp) {
        IPath backupPath;
        block28: {
            LocalDateTime ldt = LocalDateTime.ofInstant(executionTimestamp, ZoneOffset.systemDefault());
            IPath destination = Server.getConfig().getBackupPath().append(tsFormatter.format(ldt));
            boolean lowResDbClosed = false;
            boolean highResDbClosed = false;
            boolean supplementDbCloed = false;
            Server.getRawValuesViews().writeLockAllViews();
            try {
                try {
                    ArchiveStorages.getGlobalViewInstance().compressDb();
                    ArchiveStorages.getRealtimeViewInstance().compressDb();
                    SupplementStorage.getInstance().compressDb();
                    lowResDbClosed = ArchiveStorages.getGlobalViewInstance().close();
                    highResDbClosed = ArchiveStorages.getRealtimeViewInstance().close();
                    supplementDbCloed = SupplementStorage.getInstance().close();
                    File lowResArchive = new File(ArchiveStorages.getGlobalViewInstance().getDbPath());
                    File highResArchive = new File(ArchiveStorages.getRealtimeViewInstance().getDbPath());
                    File supplementArchive = new File(SupplementStorage.getInstance().getDbPath());
                    FileUtils.copyDirectory((File)lowResArchive, (File)destination.append("data/archive/global").toFile());
                    FileUtils.copyDirectory((File)highResArchive, (File)destination.append("data/archive/realtime").toFile());
                    FileUtils.copyDirectory((File)supplementArchive, (File)destination.append("data/supplement").toFile());
                }
                catch (IOException e) {
                    logger.error("Error creating DB backup", (Throwable)e);
                    try {
                        if (lowResDbClosed) {
                            ArchiveStorages.getGlobalViewInstance().open();
                        }
                        if (highResDbClosed) {
                            ArchiveStorages.getRealtimeViewInstance().open();
                        }
                        if (supplementDbCloed) {
                            SupplementStorage.getInstance().open();
                        }
                    }
                    catch (Exception exc) {
                        logger.error("Error opening databases after backup", (Throwable)exc);
                    }
                    Server.getRawValuesViews().writeUnlockAllViews();
                    return;
                }
            }
            finally {
                try {
                    if (lowResDbClosed) {
                        ArchiveStorages.getGlobalViewInstance().open();
                    }
                    if (highResDbClosed) {
                        ArchiveStorages.getRealtimeViewInstance().open();
                    }
                    if (supplementDbCloed) {
                        SupplementStorage.getInstance().open();
                    }
                }
                catch (Exception exc) {
                    logger.error("Error opening databases after backup", (Throwable)exc);
                }
                Server.getRawValuesViews().writeUnlockAllViews();
            }
            backupPath = Server.getConfig().getBackupPath();
            ZipOutputStream zipFile = null;
            try {
                try {
                    File zipFilePath = backupPath.append(String.valueOf(tsFormatter.format(ldt)) + ".zip").toFile();
                    if (!zipFilePath.exists()) {
                        zipFilePath.createNewFile();
                    }
                    zipFile = ValuesDBBackupJob.compressZipfile(String.valueOf(destination.toString()) + File.separator, zipFilePath.toString());
                    FileUtils.deleteDirectory((File)destination.toFile());
                }
                catch (IOException e) {
                    logger.error("Error zipping folder", (Throwable)e);
                    IOUtils.closeQuietly(zipFile);
                    break block28;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)zipFile);
        }
        TreeMap<LocalDateTime, File> files = new TreeMap<LocalDateTime, File>();
        File backupFile = backupPath.toFile().getAbsoluteFile();
        File[] fileArray = backupFile.listFiles((FilenameFilter)FileFilterUtils.suffixFileFilter((String)".zip"));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                LocalDateTime fileTs = LocalDateTime.from(tsFormatter.parse(file.getName().replace(".zip", "")));
                files.put(fileTs, file);
            }
            catch (Exception exception) {}
            ++n2;
        }
        File[] sortedFiles = files.values().toArray(new File[0]);
        int i = 0;
        while (i < sortedFiles.length - Math.max(1, Server.getConfig().getBackupSize())) {
            sortedFiles[i].delete();
            ++i;
        }
    }

    public static ZipOutputStream compressZipfile(String sourceDir, String outputFile) throws IOException, FileNotFoundException {
        ZipOutputStream zipFile = new ZipOutputStream(new FileOutputStream(outputFile));
        ValuesDBBackupJob.compressDirectoryToZipfile(sourceDir, sourceDir, zipFile);
        return zipFile;
    }

    private static void compressDirectoryToZipfile(String rootDir, String sourceDir, ZipOutputStream out) throws IOException, FileNotFoundException {
        File[] fileArray = new File(sourceDir).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ValuesDBBackupJob.compressDirectoryToZipfile(rootDir, String.valueOf(sourceDir) + file.getName() + File.separator, out);
            } else {
                ZipEntry entry = new ZipEntry(String.valueOf(sourceDir.replace(rootDir, "")) + file.getName());
                out.putNextEntry(entry);
                FileInputStream in = new FileInputStream(String.valueOf(sourceDir) + file.getName());
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
            }
            ++n2;
        }
    }
}

