/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.statistics;

import de.elpro.ewms.core.statistics.RasterizedValuesStatistics;
import de.elpro.ewms.core.statistics.VariableInstancesStatistics;
import de.elpro.ewms.core.variable.VariableInstance;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class RasterizedValuesStatisticsInstance {
    public static final RasterizedValuesStatisticsInstance INSTANCE = new RasterizedValuesStatisticsInstance();
    private final ConcurrentMap<VariableInstance, AtomicReference<Duration>> instanceStatistics = new ConcurrentHashMap<VariableInstance, AtomicReference<Duration>>();

    public void clear() {
        this.instanceStatistics.clear();
    }

    public void addNanos(VariableInstance instance, long nanos) {
        AtomicReference<Duration> duration = (AtomicReference<Duration>)this.instanceStatistics.get(instance);
        if (duration == null) {
            duration = new AtomicReference<Duration>(Duration.ZERO);
            this.instanceStatistics.put(instance, duration);
        }
        duration.getAndUpdate(d -> d.plusNanos(nanos));
    }

    public RasterizedValuesStatistics toStatistics() {
        RasterizedValuesStatistics stats = new RasterizedValuesStatistics();
        for (Map.Entry entry : this.instanceStatistics.entrySet()) {
            stats.getInstanceStatistics().add(new VariableInstancesStatistics((VariableInstance)entry.getKey(), (Duration)((AtomicReference)entry.getValue()).get()));
        }
        return stats;
    }
}

