/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.server.db.randomaccess.RADBOptions;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.db.randomaccess.RandomAccessDB;
import de.elpro.ewms.server.storage.ArchiveStorageConfig;
import de.elpro.ewms.server.storage.ArchiveStorageEntityDescriptior;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import de.elpro.ewms.server.storage.TimeRangeMetadataReader;
import de.elpro.ewms.server.storage.ValuePersister;
import de.elpro.ui.text.LocaleText;

public class ArchiveStorage
extends RandomAccessDB<TimeRangeMetadata, VariableInstance, Void, ArchiveValue> {
    private final ArchiveStorageConfig config;
    private volatile TimeRangeMetadata cachedMetadata;

    protected ArchiveStorage(ArchiveStorageConfig config, RADBOptions options) {
        super(config.getPath(), new TimeRangeMetadataReader(config.getFile()), new ArchiveStorageEntityDescriptior(config.getBaseClusterWidth()), new ValuePersister(), options);
        this.config = config;
    }

    public LocaleText getName() {
        return this.config.getName();
    }

    public Raster getBaseRaster() {
        return this.config.getBaseRaster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeRangeMetadata getCachedMetadata() {
        if (this.cachedMetadata == null) {
            ArchiveStorage archiveStorage = this;
            synchronized (archiveStorage) {
                this.cachedMetadata = (TimeRangeMetadata)this.getMetadata();
            }
        }
        return this.cachedMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(RADbTransaction<TimeRangeMetadata> transaction) {
        super.commitTransaction(transaction);
        ArchiveStorage archiveStorage = this;
        synchronized (archiveStorage) {
            this.cachedMetadata = (TimeRangeMetadata)this.getMetadata();
        }
    }
}

