/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ui.text.LocaleText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.fx.core.log.Logger;

class ArchiveStorageConfig {
    private static Logger logger = Activator.getLoggerFactory().createLogger(ArchiveStorageConfig.class.getName());
    private static final int DEFAULT_CLUSTER_SIZE = 256;
    private final String path;
    private final File file;
    private LocaleText name;
    private long baseClusterWidth;
    private Raster baseRaster;

    private ArchiveStorageConfig(String path) {
        this.path = path;
        this.file = new File(path, "METADATA");
    }

    public ArchiveStorageConfig(String path, Raster baseRaster) {
        this(path);
        if (!this.file.exists()) {
            this.createNewFile(baseRaster);
        }
        this.readProperties();
    }

    private void readProperties() {
        Properties props = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream is = new FileInputStream(this.file);){
                props = new Properties();
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String nameStr = props.getProperty("name");
        String baseClusterWidthStr = props.getProperty("base_cluster_width");
        String baseRasterStr = props.getProperty("base_raster");
        this.name = LocaleText.tryParse((String)nameStr);
        this.baseClusterWidth = baseClusterWidthStr != null ? Long.parseLong(baseClusterWidthStr) : ArchiveStorageConfig.getOptimalClusterWidth(this.baseRaster);
        this.baseRaster = Raster.valueOf((String)baseRasterStr);
    }

    private void createNewFile(Raster baseRaster) {
        block14: {
            File oldFormatFile = new File(this.path, "values_bounds.prefs");
            try {
                if (oldFormatFile.exists()) {
                    Throwable throwable = null;
                    Object var5_5 = null;
                    try (FileInputStream is = new FileInputStream(oldFormatFile);){
                        Properties props = new Properties();
                        props.load(is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    this.baseRaster = baseRaster;
                    this.baseClusterWidth = baseRaster.ordinal() >= Raster.Minute_1.ordinal() ? 604800000L : 900000L;
                    this.file.createNewFile();
                    this.persist();
                    oldFormatFile.delete();
                    break block14;
                }
                File parent = this.file.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IllegalStateException("Couldn't create dir: " + parent);
                }
                this.baseRaster = baseRaster;
                this.baseClusterWidth = ArchiveStorageConfig.getOptimalClusterWidth(baseRaster);
                this.file.createNewFile();
                this.persist();
            }
            catch (IOException exc) {
                logger.error("Error creating new metadata file", (Throwable)exc);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public LocaleText getName() {
        return this.name;
    }

    public void setName(LocaleText name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name.getTextOrDefault(Locale.getDefault());
    }

    public long getBaseClusterWidth() {
        return this.baseClusterWidth;
    }

    private void setBaseClusterWidth(long baseClusterWidth) {
        this.baseClusterWidth = baseClusterWidth;
    }

    public Raster getBaseRaster() {
        return this.baseRaster;
    }

    private void setBaseRaster(Raster baseRaster) {
        this.baseRaster = baseRaster;
    }

    public final void persist() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream out = new FileOutputStream(this.file);){
                Properties props = new Properties();
                props.setProperty("name", this.name != null ? this.name.toJson() : LocaleText.tryParse(null).toJson());
                props.setProperty("base_cluster_width", Long.toString(this.baseClusterWidth));
                props.setProperty("base_raster", this.baseRaster.name());
                props.store(out, "Archive Storage Metadata");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Error writing core data interval", (Throwable)e);
        }
    }

    public static long getOptimalClusterWidth(Raster baseValueWidth) {
        return baseValueWidth.toMilli() * 256L;
    }

    public static ArchiveStorageConfig readMetadata(String path) {
        ArchiveStorageConfig metadata = new ArchiveStorageConfig(path);
        metadata.readProperties();
        return metadata;
    }

    public static ArchiveStorageConfig create(String path, LocaleText name, Raster baseRaster) throws IOException {
        ArchiveStorageConfig metadata = new ArchiveStorageConfig(path);
        File parent = metadata.file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException("Couldn't create dir: " + parent);
        }
        metadata.file.createNewFile();
        metadata.setName(name);
        metadata.setBaseClusterWidth(ArchiveStorageConfig.getOptimalClusterWidth(baseRaster));
        metadata.setBaseRaster(baseRaster);
        metadata.persist();
        return metadata;
    }
}

