/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.db.randomaccess.IEntityDescriptor;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Map;

public class ArchiveStorageEntityDescriptior
implements IEntityDescriptor<VariableInstance, Void> {
    private final long clusterWidth;

    public ArchiveStorageEntityDescriptior(long clusterWidth) {
        this.clusterWidth = clusterWidth;
    }

    @Override
    public byte[] getId(VariableInstance entity, Void entityParam) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putInt(entity.getVariable().getId());
        buffer.putInt(entity.getStructureObject().getId());
        return buffer.array();
    }

    @Override
    public Map.Entry<VariableInstance, Void> getEntity(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        VariableInstance instance = new VariableInstance();
        instance.setVariable(new Variable(buffer.getInt()));
        instance.setStructureObject(new StructureObject(buffer.getInt()));
        return new AbstractMap.SimpleEntry<VariableInstance, Object>(instance, null);
    }

    @Override
    public long getClusterWidth(VariableInstance entity, Void entityParam) {
        return this.clusterWidth;
    }
}

