/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.server.Configuration;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.db.randomaccess.RADBOptions;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.storage.ArchiveStorageConfig;

public class ArchiveStorages {
    public static final String GLOBAL_VIEW_PATH_REL = "data/archive/global";
    public static final String REALTIME_VIEW_PATH_REL = "data/archive/realtime";
    public static final String GENERIC_DB_PATH_REL = "data/generic";
    private static ArchiveStorage GLOBAL_VIEW_INSTANCE;
    private static ArchiveStorage REALTIME_VIEW_INSTANCE;

    public static ArchiveStorage initGlobalViewInstance(Configuration config) {
        if (GLOBAL_VIEW_INSTANCE != null) {
            throw new IllegalStateException();
        }
        RADBOptions options = new RADBOptions().setSyncInterval(config.getGlobalViewSyncInterval());
        GLOBAL_VIEW_INSTANCE = new ArchiveStorage(new ArchiveStorageConfig(Activator.getWorkspaceLocation().append(GLOBAL_VIEW_PATH_REL).toString(), Server.getConfig().getGlobalViewRaster()), options);
        return GLOBAL_VIEW_INSTANCE;
    }

    public static ArchiveStorage getGlobalViewInstance() {
        if (GLOBAL_VIEW_INSTANCE == null) {
            throw new IllegalStateException();
        }
        return GLOBAL_VIEW_INSTANCE;
    }

    public static ArchiveStorage initRealtimeViewInstance(Configuration config) {
        if (REALTIME_VIEW_INSTANCE != null) {
            throw new IllegalStateException();
        }
        RADBOptions options = new RADBOptions().setSyncInterval(config.getRealtimeViewSyncInterval());
        REALTIME_VIEW_INSTANCE = new ArchiveStorage(new ArchiveStorageConfig(Activator.getWorkspaceLocation().append(REALTIME_VIEW_PATH_REL).toString(), Server.getConfig().getRealtimeViewRaster()), options);
        return REALTIME_VIEW_INSTANCE;
    }

    public static ArchiveStorage getRealtimeViewInstance() {
        if (REALTIME_VIEW_INSTANCE == null) {
            throw new IllegalStateException();
        }
        return REALTIME_VIEW_INSTANCE;
    }
}

