/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.db.randomaccess.RADBOptions;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.storage.ArchiveStorageConfig;
import de.elpro.ui.text.LocaleText;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;

public class RawValuesCustomViewStorages {
    public static final String ROOT_PATH_REL = "data/views/";
    private static final File ROOT_DIR_FILE = Activator.getWorkspaceLocation().append("data/views/").toFile();
    private static final String VIEW_PATH_PREFIX = "view_";
    private static final Map<Integer, ArchiveStorage> STORAGES = new HashMap<Integer, ArchiveStorage>();

    public static synchronized void init() {
        TreeMap<Integer, File> storageFolders = RawValuesCustomViewStorages.scanRootFolder();
        for (Map.Entry<Integer, File> entry : storageFolders.entrySet()) {
            Integer index = entry.getKey();
            File folder = entry.getValue();
            ArchiveStorageConfig metadata = ArchiveStorageConfig.readMetadata(folder.getAbsolutePath());
            ArchiveStorage storage = new ArchiveStorage(metadata, new RADBOptions());
            STORAGES.put(index, storage);
        }
    }

    protected static synchronized TreeMap<Integer, File> scanRootFolder() {
        TreeMap<Integer, File> storageIndexes = new TreeMap<Integer, File>();
        String[] directories = ROOT_DIR_FILE.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                if (!name.startsWith(RawValuesCustomViewStorages.VIEW_PATH_PREFIX)) {
                    return false;
                }
                String indexName = name.replace(RawValuesCustomViewStorages.VIEW_PATH_PREFIX, "");
                try {
                    Integer.parseInt(indexName);
                }
                catch (Exception exception) {
                    return false;
                }
                return new File(current, name).isDirectory();
            }
        });
        if (directories == null) {
            return storageIndexes;
        }
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            storageIndexes.put(Integer.parseInt(dir.replace(VIEW_PATH_PREFIX, "")), new File(ROOT_DIR_FILE, dir));
            ++n2;
        }
        return storageIndexes;
    }

    public static synchronized Integer createNew(LocaleText name, Raster baseRaster) throws IOException {
        TreeMap<Integer, File> storageIndexes = RawValuesCustomViewStorages.scanRootFolder();
        int nextIndex = 0;
        if (!storageIndexes.isEmpty()) {
            nextIndex = storageIndexes.lastKey() + 1;
        }
        String folderName = "data/views/view_" + nextIndex;
        String path = Activator.getWorkspaceLocation().append(folderName).toString();
        ArchiveStorageConfig metadata = ArchiveStorageConfig.create(path, name, baseRaster);
        ArchiveStorage storage = new ArchiveStorage(metadata, new RADBOptions());
        STORAGES.put(nextIndex, storage);
        return nextIndex;
    }

    public static synchronized void delete(int index) throws IOException {
        String folderName = "data/views/view_" + index;
        String path = Activator.getWorkspaceLocation().append(folderName).toString();
        FileUtils.deleteDirectory((File)new File(path));
    }

    public static synchronized ArchiveStorage getStorage(int index) {
        return STORAGES.get(index);
    }

    public static synchronized Collection<Integer> getStorageIndexes() {
        return Collections.unmodifiableCollection(STORAGES.keySet());
    }
}

