/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.db.randomaccess.IMetadataReader;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.eclipse.fx.core.log.Logger;

public class TimeRangeMetadataReader
implements IMetadataReader<TimeRangeMetadata> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(TimeRangeMetadataReader.class.getName());
    private final File defaultMetadata;

    public TimeRangeMetadataReader(File defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @Override
    public TimeRangeMetadata read(byte[] data) {
        TimeRangeMetadata metadata = new TimeRangeMetadata();
        if (data == null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(this.defaultMetadata);){
                    Properties props = new Properties();
                    props.load(is);
                    String beginStr = props.getProperty("time_range_begin");
                    String endStr = props.getProperty("time_range_end");
                    if (beginStr != null && endStr != null) {
                        try {
                            Long timeRangeBegin = Long.parseLong(beginStr);
                            Long timeRangeEnd = Long.parseLong(endStr);
                            metadata.setTimeRangeBegin(timeRangeBegin);
                            metadata.setTimeRangeEnd(timeRangeEnd);
                        }
                        catch (Exception exc) {
                            logger.error("Cannot parse database data interval", (Throwable)exc);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
            return metadata;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int version = buffer.getInt();
        if (version != 1) {
            throw new IllegalStateException("Wrong Version!");
        }
        metadata.setTimeRangeBegin(buffer.getLong());
        metadata.setTimeRangeEnd(buffer.getLong());
        return metadata;
    }
}

