/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.storage;

import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.server.db.randomaccess.IValuePersister;
import java.nio.ByteBuffer;

public class ValuePersister
implements IValuePersister<ArchiveValue> {
    @Override
    public int getElementSize() {
        return 20;
    }

    @Override
    public void serialize(ByteBuffer buffer, long clusterId, ArchiveValue value) {
        int partialStart = (int)(value.getStartTimestamp() - clusterId + Integer.MIN_VALUE);
        int partialEnd = (int)(value.getEndTimestamp() - clusterId + Integer.MIN_VALUE);
        if (ValuePersister.getTimestamp(clusterId, partialStart) != value.getStartTimestamp() || ValuePersister.getTimestamp(clusterId, partialEnd) != value.getEndTimestamp()) {
            throw new IllegalStateException("Cluster size is to small!");
        }
        buffer.putInt(partialStart);
        buffer.putInt(partialEnd);
        buffer.putDouble(value.getValue());
        buffer.putFloat((float)value.getQuality());
    }

    private static long getTimestamp(long clusterId, int timespan) {
        return clusterId - Integer.MIN_VALUE + (long)timespan;
    }

    @Override
    public ArchiveValue deserialize(ByteBuffer buffer, long clusterId) {
        long startTs = ValuePersister.getTimestamp(clusterId, buffer.getInt());
        long endTs = ValuePersister.getTimestamp(clusterId, buffer.getInt());
        return new ArchiveValue(startTs, endTs, buffer.getDouble(), (double)buffer.getFloat());
    }

    public ArchiveValue[] createArray(int size) {
        return new ArchiveValue[size];
    }
}

