/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.supplement;

import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.db.randomaccess.IEntityDescriptor;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Map;

class SupplementStorageEntityDescriptior
implements IEntityDescriptor<VariableInstance, Integer> {
    public static final long RASTERIZED_CLUSTER_MAX_WIDTH_V1 = 31708800000L;

    SupplementStorageEntityDescriptior() {
    }

    @Override
    public byte[] getId(VariableInstance entity, Integer selector) {
        int idSize = 8 + (selector != null ? 4 : 0);
        ByteBuffer buffer = ByteBuffer.allocate(idSize);
        buffer.putInt(entity.getVariable().getId());
        buffer.putInt(entity.getStructureObject().getId());
        if (selector != null) {
            buffer.putInt(selector);
        }
        return buffer.array();
    }

    @Override
    public Map.Entry<VariableInstance, Integer> getEntity(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        VariableInstance instance = new VariableInstance();
        instance.setVariable(new Variable(buffer.getInt()));
        instance.setStructureObject(new StructureObject(buffer.getInt()));
        Integer selector = null;
        if (buffer.position() == data.length - 4) {
            selector = buffer.getInt();
        }
        return new AbstractMap.SimpleEntry<VariableInstance, Integer>(instance, selector);
    }

    @Override
    public long getClusterWidth(VariableInstance entity, Integer selector) {
        return entity.getSupplementValueStrategy() == SupplementValueStrategy.Rasterized ? 31708800000L : Long.MAX_VALUE;
    }
}

