/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.transactions;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javafx.util.Pair;
import javax.persistence.EntityManager;

public class TransactionChangeset {
    private static final Map<Integer, Set<Modification<?>>> CHANGESET = new HashMap();
    private static final Map<Integer, Set<TransactionProperty>> PROPERTIES = new HashMap<Integer, Set<TransactionProperty>>();
    private static final Set<PreCommitHandlerDescriptor<?>> PRE_COMMIT_HANDLERS = new LinkedHashSet();
    private static final Set<PostCommitHandlerDescriptor<?>> POST_COMMIT_HANDLERS = new LinkedHashSet();

    public static synchronized void changedOrRemoved(int trx, Modification<?> object) {
        Set<Modification<?>> objects = CHANGESET.get(trx);
        if (objects == null) {
            objects = new LinkedHashSet();
            CHANGESET.put(trx, objects);
        }
        objects.add(object);
    }

    public static synchronized <T> void changedOrNew(int trx, T object) {
        Set<Modification<?>> objects = CHANGESET.get(trx);
        if (objects == null) {
            objects = new HashSet();
            CHANGESET.put(trx, objects);
        }
        objects.add(new Modification<T>(object));
    }

    public static synchronized <T> void removed(int trx, T object) {
        Set<Modification<?>> objects = CHANGESET.get(trx);
        if (objects == null) {
            objects = new HashSet();
            CHANGESET.put(trx, objects);
        }
        objects.add(new Modification<T>(object));
    }

    public static synchronized void addProperty(int trx, TransactionProperty property) {
        Set<TransactionProperty> properties = PROPERTIES.get(trx);
        if (properties == null) {
            properties = new HashSet<TransactionProperty>();
            PROPERTIES.put(trx, properties);
        }
        properties.add(property);
    }

    public static void doPostCommitSync(int trx) {
        TransactionChangeset.handleCommit(trx, false);
    }

    public static void doPostCommitAsync(int trx) {
        TransactionChangeset.handleCommit(trx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareCommit(int trx, User user) throws Exception {
        Class<TransactionChangeset> clazz = TransactionChangeset.class;
        synchronized (TransactionChangeset.class) {
            if (PRE_COMMIT_HANDLERS.isEmpty()) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            Set<Object> changes = CHANGESET.containsKey(trx) ? CHANGESET.get(trx) : new HashSet();
            Set<Object> properties = PROPERTIES.containsKey(trx) ? PROPERTIES.get(trx) : new HashSet();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (!changes.isEmpty() || !properties.isEmpty()) {
                for (PreCommitHandlerDescriptor<?> entry : PRE_COMMIT_HANDLERS) {
                    TransactionChangeset.handlePreCommitEvent(EntityManagerPool.getEntityManager(trx, user), entry, changes, properties);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleCommit(int trx, boolean async) {
        Class<TransactionChangeset> clazz = TransactionChangeset.class;
        synchronized (TransactionChangeset.class) {
            if (POST_COMMIT_HANDLERS.isEmpty()) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            Set<Object> changes = CHANGESET.containsKey(trx) ? CHANGESET.remove(trx) : new HashSet();
            Set<Object> properties = PROPERTIES.containsKey(trx) ? PROPERTIES.remove(trx) : new HashSet();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (!changes.isEmpty() || !properties.isEmpty()) {
                if (async) {
                    new Thread(() -> {
                        for (PostCommitHandlerDescriptor<?> entry : POST_COMMIT_HANDLERS) {
                            TransactionChangeset.handlePostCommitEvent(entry, changes, properties);
                        }
                    }).start();
                } else {
                    for (PostCommitHandlerDescriptor<?> entry : POST_COMMIT_HANDLERS) {
                        TransactionChangeset.handlePostCommitEvent(entry, changes, properties);
                    }
                }
            }
            return;
        }
    }

    private static <T> void handlePreCommitEvent(EntityManager em, PreCommitHandlerDescriptor<T> descriptor, Collection<Modification<?>> changes, Collection<TransactionProperty> properties) throws Exception {
        Class clazz = (Class)descriptor.getKey();
        PreCommitEventHandler handler = (PreCommitEventHandler)descriptor.getValue();
        HashSet filteredChanges = new HashSet();
        changes.stream().filter(c -> clazz.isAssignableFrom(c.getObject().getClass())).forEach(c -> {
            boolean bl = filteredChanges.add(c);
        });
        handler.onCommit(em, filteredChanges, properties);
    }

    private static <T> void handlePostCommitEvent(PostCommitHandlerDescriptor<T> descriptor, Collection<Modification<?>> changes, Collection<TransactionProperty> properties) {
        Class clazz = (Class)descriptor.getKey();
        PostCommitEventHandler handler = (PostCommitEventHandler)descriptor.getValue();
        HashSet filteredChanges = new HashSet();
        changes.stream().filter(c -> clazz.isAssignableFrom(c.getObject().getClass())).forEach(c -> {
            boolean bl = filteredChanges.add(c);
        });
        handler.onCommit(filteredChanges, properties);
    }

    public static synchronized void doPostRollback(int trx) {
        CHANGESET.remove(trx);
        PROPERTIES.remove(trx);
    }

    public static synchronized <T> void addPreCommitEventHandler(Class<T> clazz, PreCommitEventHandler<T> handler) {
        PRE_COMMIT_HANDLERS.add(new PreCommitHandlerDescriptor<T>(clazz, handler));
    }

    public static synchronized <T> void addPostCommitEventHandler(Class<T> clazz, PostCommitEventHandler<T> handler) {
        POST_COMMIT_HANDLERS.add(new PostCommitHandlerDescriptor<T>(clazz, handler));
    }

    public static interface PostCommitEventHandler<T> {
        public void onCommit(Collection<Modification<T>> var1, Collection<TransactionProperty> var2);
    }

    private static class PostCommitHandlerDescriptor<T>
    extends Pair<Class<T>, PostCommitEventHandler<T>> {
        private static final long serialVersionUID = -6388100867674225802L;

        public PostCommitHandlerDescriptor(Class<T> key, PostCommitEventHandler<T> value) {
            super(key, value);
        }
    }

    public static interface PreCommitEventHandler<T> {
        public void onCommit(EntityManager var1, Collection<Modification<T>> var2, Collection<TransactionProperty> var3) throws Exception;
    }

    private static class PreCommitHandlerDescriptor<T>
    extends Pair<Class<T>, PreCommitEventHandler<T>> {
        private static final long serialVersionUID = 8773076559066122656L;

        public PreCommitHandlerDescriptor(Class<T> key, PreCommitEventHandler<T> value) {
            super(key, value);
        }
    }
}

