/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.update;

import com.google.common.io.Files;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.model.IUpdateHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class U_05_0_0_UpgradeLMDB_0_8_1_to_MDBX_0_10_4_UpdateHandler
implements IUpdateHandler {
    public static final String VERSION_TEST = "0|com.castortech.mdbxjni_0.10.4";

    @Override
    public String getSerialNumber() {
        return "1.0.0";
    }

    @Override
    public String getDescription() {
        return "Convert LMDB Database to MDBX";
    }

    @Override
    public String getUpdateFromVersion() {
        return null;
    }

    @Override
    public String getUpdateToVersion() {
        return null;
    }

    private boolean checkVersionFileForUpdate(File folder) throws IOException {
        File versionFile = new File(folder, "version.txt");
        if (!versionFile.exists()) {
            return false;
        }
        String text = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream is = new FileInputStream(versionFile);){
            Iterator iterator = IOUtils.readLines((InputStream)is, (Charset)Charset.defaultCharset()).iterator();
            if (iterator.hasNext()) {
                String s;
                text = s = (String)iterator.next();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return "prev_ver_id".equals(text);
    }

    @Override
    public boolean update() throws Exception {
        boolean upgrade = false;
        File global = Activator.getWorkspaceLocation().append("data/archive/global").toFile();
        upgrade |= this.upgrade(global);
        File realtime = Activator.getWorkspaceLocation().append("data/archive/realtime").toFile();
        upgrade |= this.upgrade(realtime);
        File supplement = Activator.getWorkspaceLocation().append("data/supplement").toFile();
        upgrade |= this.upgrade(supplement);
        File views = Activator.getWorkspaceLocation().append("data/views").toFile();
        if (views.exists()) {
            File[] fileArray = views.listFiles(f -> f.isDirectory());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File view = fileArray[n2];
                upgrade |= this.upgrade(view);
                ++n2;
            }
        }
        return upgrade;
    }

    private boolean upgrade(File folder) throws IOException {
        if (!this.checkVersionFileForUpdate(folder)) {
            return false;
        }
        File tempFolder = new File(String.valueOf(folder.getAbsolutePath()) + "_tmp");
        if (!folder.exists() && !tempFolder.exists()) {
            return false;
        }
        if (tempFolder.exists()) {
            FileUtils.deleteDirectory((File)folder);
        } else {
            Files.move((File)folder, (File)tempFolder);
        }
        folder.mkdir();
        File metadata = new File(tempFolder, "METADATA");
        if (metadata.exists()) {
            Files.copy((File)metadata, (File)new File(folder, "METADATA"));
        }
        File versionFile = new File(folder, "version.txt");
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(versionFile));){
            writer.write(VERSION_TEST);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FileUtils.deleteDirectory((File)tempFolder);
        return true;
    }
}

