/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.valueswriter;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.core.worker.WorkerState;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.model.IValuesWriter;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.rasterizedvalues.StoredValuesConverter;
import de.elpro.ewms.server.storage.ArchiveStorage;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.validation.constraints.NotNull;
import org.eclipse.fx.core.log.Logger;

public abstract class AbstractValuesWriter
extends AbstractWorker
implements IValuesWriter {
    private static Logger logger = Activator.getLoggerFactory().createLogger(AbstractValuesWriter.class.getName());
    protected final Raster raster;
    protected final RasterizedValues rasterizedValues;
    protected final ArchiveStorage storage;
    private final Long archiveValuesTsRange;
    private Map<VariableInstance, ArrayList<ArchiveValue>> newPLCValues;
    private final Map<VariableInstance, ArrayList<ArchiveValue>> writeBuffer = new HashMap<VariableInstance, ArrayList<ArchiveValue>>();
    private final Thread writeThread;
    private final long writeRaster;

    public AbstractValuesWriter(String workerId, String workerName, @NotNull ArchiveStorage storage, @NotNull RasterizedValues rasterizedValues, Long archiveValuesTsRange) {
        super(workerId, workerName, 10000L, false);
        this.raster = rasterizedValues.getRaster();
        this.rasterizedValues = rasterizedValues;
        this.storage = storage;
        this.archiveValuesTsRange = archiveValuesTsRange;
        this.writeRaster = Math.max(Raster.Second_10.toMilli(), Math.min(Server.getConfig().getRealtimeViewRaster().toMilli() * 32L, Raster.Minute_1.toMilli()));
        this.writeThread = new Thread(() -> {
            while (!Thread.interrupted()) {
                HashMap<VariableInstance, ArrayList<ArchiveValue>> toWrite = new HashMap<VariableInstance, ArrayList<ArchiveValue>>();
                Map<VariableInstance, ArrayList<ArchiveValue>> map = this.writeBuffer;
                synchronized (map) {
                    if (!this.writeBuffer.isEmpty()) {
                        for (Map.Entry<VariableInstance, ArrayList<ArchiveValue>> entry : this.writeBuffer.entrySet()) {
                            ArrayList<ArchiveValue> values = entry.getValue();
                            if (values.isEmpty()) continue;
                            toWrite.put(entry.getKey(), values);
                        }
                        this.writeBuffer.clear();
                    }
                }
                if (this.getState() == WorkerState.Running && !toWrite.isEmpty()) {
                    this.writeArchiveValues(toWrite, true);
                }
                try {
                    Thread.sleep(this.writeRaster);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }, String.format("%s persister thread", workerName));
        this.writeThread.start();
    }

    private TsInterval writeArchiveValues(Map<VariableInstance, ArrayList<ArchiveValue>> toWrite, boolean updateValuesBounds) {
        long minStartTimestamp;
        long maxEndTimestamp;
        block17: {
            RADbTransaction<TimeRangeMetadata> trx = this.storage.beginTransaction();
            maxEndTimestamp = Long.MIN_VALUE;
            minStartTimestamp = Long.MAX_VALUE;
            long storageNano = 0L;
            long removeOldClustersNano = 0L;
            long commitNano = 0L;
            long compressNano = 0L;
            boolean clustersRemoved = false;
            try {
                try {
                    long ts;
                    TimeRangeMetadata metadata = (TimeRangeMetadata)trx.getMetadata();
                    Long deleteClustersUpToTs = null;
                    long startNano = ts = System.nanoTime();
                    for (Map.Entry<VariableInstance, ArrayList<ArchiveValue>> instanceValues : toWrite.entrySet()) {
                        VariableInstance instance = instanceValues.getKey();
                        for (IStoredVarValue iStoredVarValue : instanceValues.getValue()) {
                            maxEndTimestamp = Math.max(maxEndTimestamp, iStoredVarValue.getEndTimestamp());
                            minStartTimestamp = Math.min(minStartTimestamp, iStoredVarValue.getStartTimestamp());
                        }
                        this.storage.saveValues(trx, instance, (Collection)instanceValues.getValue());
                    }
                    storageNano += System.nanoTime() - ts;
                    if (updateValuesBounds) {
                        long expectedNewStartTs;
                        if (this.archiveValuesTsRange != null && metadata.getTimeRangeBegin() != null && this.raster.getRasterEnd(maxEndTimestamp) - this.archiveValuesTsRange > metadata.getTimeRangeBegin() && (expectedNewStartTs = this.raster.getRasterEnd(maxEndTimestamp) - this.archiveValuesTsRange) - metadata.getTimeRangeBegin() > this.storage.getEntityDescriptor().getClusterWidth(null, null)) {
                            deleteClustersUpToTs = maxEndTimestamp - this.archiveValuesTsRange;
                            metadata.setTimeRangeBegin(expectedNewStartTs);
                        }
                        if (metadata.getTimeRangeBegin() == null && metadata.getTimeRangeEnd() == null) {
                            metadata.setTimeRangeBegin(this.raster.getRasterBegin(minStartTimestamp));
                            metadata.setTimeRangeEnd(this.raster.getRasterEnd(maxEndTimestamp));
                        } else {
                            if (maxEndTimestamp > metadata.getTimeRangeEnd()) {
                                metadata.setTimeRangeEnd(this.raster.getRasterEnd(maxEndTimestamp));
                            }
                            if (minStartTimestamp < metadata.getTimeRangeBegin()) {
                                long newBegin = this.raster.getRasterBegin(minStartTimestamp);
                                metadata.setTimeRangeBegin(newBegin);
                            }
                        }
                    }
                    ts = System.nanoTime();
                    this.storage.commitTransaction(trx);
                    commitNano += System.nanoTime() - ts;
                    if (deleteClustersUpToTs != null) {
                        ts = System.nanoTime();
                        clustersRemoved |= this.storage.deleteClusters(deleteClustersUpToTs);
                        removeOldClustersNano += System.nanoTime() - ts;
                    }
                    ts = System.nanoTime();
                    if (clustersRemoved) {
                        this.storage.compressDb();
                        compressNano += System.nanoTime() - ts;
                    }
                    if (Server.getConfig().isDebug() || (double)(ts - startNano) / 1000000.0 > (double)(this.writeRaster / 2L) || compressNano > 15000000000L) {
                        String warning = String.format("Write operation for storage in [%s] raster done in %.2f ms. Write interval is %d ms\r\n", this.raster, (double)(ts - startNano) / 1000000.0, this.writeRaster);
                        warning = String.valueOf(warning) + String.format("\t\t%.2f ms for storage\r\n", (double)storageNano / 1000000.0);
                        warning = String.valueOf(warning) + String.format("\t\t%.2f ms for remove old clusters \r\n", (double)removeOldClustersNano / 1000000.0);
                        warning = String.valueOf(warning) + String.format("\t\t%.2f ms for commit", (double)commitNano / 1000000.0);
                        if (clustersRemoved) {
                            warning = String.valueOf(warning) + String.format("\r\n\t\t%.2f ms for compress db on cluster remove", (double)compressNano / 1000000.0);
                        }
                        logger.warning(warning);
                    }
                }
                catch (Exception exc) {
                    logger.error("Error writing high res archive values to persistent storage", (Throwable)exc);
                    this.storage.abortTransaction(trx);
                    toWrite = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                toWrite = null;
                throw throwable;
            }
            toWrite = null;
        }
        return new TsInterval(minStartTimestamp, maxEndTimestamp);
    }

    public void synchronizeWithRAWDB(Instant from, Instant to) {
        if (!from.isBefore(to)) {
            throw new IllegalArgumentException();
        }
        long fromTs = this.raster.getRasterBegin(from.toEpochMilli());
        long toTs = this.raster.getRasterEnd(to.toEpochMilli());
        if (this.archiveValuesTsRange != null) {
            long maxToTs = toTs;
            TimeRangeMetadata metadata = this.storage.getCachedMetadata();
            if (metadata != null && metadata.getTimeRangeEnd() != null) {
                maxToTs = Math.max(maxToTs, metadata.getTimeRangeEnd());
            }
            fromTs = Math.max(fromTs, this.raster.getRasterBegin(maxToTs - this.archiveValuesTsRange));
        }
        if (toTs <= fromTs) {
            return;
        }
        Raster step = Server.getConfig().getRawValuesClusterSize();
        long stepBegin = fromTs;
        long stepEnd = Math.min(toTs, step.getRasterEnd(fromTs));
        if (stepEnd == fromTs) {
            stepEnd += step.toMilli();
        }
        while (stepBegin < toTs) {
            Map<VariableInstance, TsIntervals> invalidValuesIntervals = this.rasterizedValues.getInvalidValuesIntervals(Instant.ofEpochMilli(stepBegin), Instant.ofEpochMilli(stepEnd), i -> i.getType() == VariableInstanceType.PLC);
            if (!invalidValuesIntervals.isEmpty()) {
                logger.debugf("Synchronize archive with RAW DB from %s to %s", new Object[]{Instant.ofEpochMilli(stepBegin), Instant.ofEpochMilli(stepEnd)});
                this.synchronizeWithRAWDB(invalidValuesIntervals, true);
            }
            stepBegin = stepEnd;
            stepEnd = Math.min(toTs, stepEnd + step.toMilli());
        }
    }

    public void synchronizeWithRAWDB(Map<VariableInstance, TsIntervals> instanceIntervals, boolean updateValuesBounds) {
        this.rasterizedValues.writeLock();
        try {
            Set<VariableInstance> instances = instanceIntervals.keySet();
            long fromTs = Long.MAX_VALUE;
            long toTs = Long.MIN_VALUE;
            for (TsIntervals intervals : instanceIntervals.values()) {
                for (TsInterval tsInterval : intervals.getIntervals()) {
                    fromTs = Math.min(fromTs, tsInterval.getFromTs());
                    toTs = Math.max(toTs, tsInterval.getToTs());
                }
            }
            if (fromTs >= toTs) {
                return;
            }
            try {
                fromTs = this.raster.getRasterBegin(fromTs);
                toTs = this.raster.getRasterEnd(toTs);
                Map<VariableInstance, IVarValuesCollection> measurementValues = MeasurementsStorage.getOrCreateInstance().readMeasurements((Long)fromTs, (Long)toTs, instances);
                HashMap<VariableInstance, ArrayList<ArchiveValue>> archiveValues = new HashMap<VariableInstance, ArrayList<ArchiveValue>>();
                for (Map.Entry entry : measurementValues.entrySet()) {
                    VariableInstance instance = ORMCache.getVariableInstance(((VariableInstance)entry.getKey()).getId());
                    if (((IVarValuesCollection)entry.getValue()).isEmpty()) continue;
                    List<MeasuredValue> mvValues = Arrays.asList((MeasuredValue[])((IVarValuesCollection)entry.getValue()).toArray(MeasuredValue[]::new));
                    IVarValue[] aggregatedValues = StoredValuesConverter.convertStoredNoParameterValues(mvValues, fromTs, toTs, this.raster, instance.getResultPlcRawValueAggregation(), false);
                    ArrayList<ArchiveValue> instanceArchiveValues = new ArrayList<ArchiveValue>();
                    IVarValue[] iVarValueArray = aggregatedValues;
                    int n = aggregatedValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVarValue val = iVarValueArray[n2];
                        if (val instanceof IStoredVarValue) {
                            IStoredVarValue mv = (IStoredVarValue)val;
                            instanceArchiveValues.add(new ArchiveValue(mv.getStartTimestamp(), mv.getEndTimestamp(), mv.getValue(), mv.getQuality()));
                        } else if (val.isValid()) {
                            long startTimestamp = this.raster.getRasterBegin(val.getEndTimestamp());
                            if (startTimestamp == val.getEndTimestamp()) {
                                startTimestamp -= this.raster.toMilli();
                            }
                            instanceArchiveValues.add(new ArchiveValue(startTimestamp, val.getEndTimestamp(), val.getValue(), val.getQuality()));
                        }
                        ++n2;
                    }
                    if (instanceArchiveValues.isEmpty()) continue;
                    archiveValues.put(instance, instanceArchiveValues);
                }
                if (!archiveValues.isEmpty()) {
                    this.rasterizedValues.pushPLCValues(archiveValues, this.archiveValuesTsRange, updateValuesBounds);
                    this.writeArchiveValues(archiveValues, updateValuesBounds);
                }
            }
            catch (Exception exc) {
                logger.error("Error writing scheduled values to persistent storage", (Throwable)exc);
            }
        }
        finally {
            this.rasterizedValues.writeUnlock();
        }
    }

    protected final boolean doStart() {
        return true;
    }

    protected final boolean canDoWork() {
        if (this.newPLCValues == null || this.newPLCValues.isEmpty()) {
            this.newPLCValues = MeasurementsPool.getNewMeasurements(this.getId(), this.raster);
        }
        return !this.newPLCValues.isEmpty();
    }

    protected final Callable<Void> createWorkTask() {
        return () -> {
            Map<VariableInstance, ArrayList<ArchiveValue>> plcValues;
            try {
                try {
                    this.rasterizedValues.writeLock();
                    this.rasterizedValues.pushPLCValues(this.newPLCValues, this.archiveValuesTsRange, true);
                }
                catch (Exception exc) {
                    logger.error("Error writing scheduled values to persistent storage", (Throwable)exc);
                    throw exc;
                }
            }
            finally {
                plcValues = this.newPLCValues;
                this.newPLCValues = null;
                this.rasterizedValues.writeUnlock();
            }
            this.rasterizedValues.getComputationWorker().wake();
            Map<VariableInstance, ArrayList<ArchiveValue>> map = this.writeBuffer;
            synchronized (map) {
                for (Map.Entry<VariableInstance, ArrayList<ArchiveValue>> entry : plcValues.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    ArrayList<ArchiveValue> writeValues = this.writeBuffer.get(entry.getKey());
                    if (writeValues == null) {
                        this.writeBuffer.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    ArchiveValue firstValue = entry.getValue().get(0);
                    int i = writeValues.size() - 1;
                    while (i >= 0 && writeValues.get(i).getEndTimestamp() > firstValue.getStartTimestamp()) {
                        writeValues.remove(i--);
                    }
                    writeValues.addAll((Collection<ArchiveValue>)entry.getValue());
                }
            }
            return null;
        };
    }

    protected final void doStop() {
        this.writeThread.interrupt();
    }
}

