/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.valueswriter;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.randomaccess.RADbTransaction;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.storage.ArchiveStorages;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import de.elpro.ewms.server.supplement.SupplementStorage;
import de.elpro.ewms.server.valueswriter.AbstractValuesWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.fx.core.log.Logger;

public class GlobalValuesWriter
extends AbstractValuesWriter {
    private static Logger logger = Activator.getLoggerFactory().createLogger(GlobalValuesWriter.class.getName());

    public GlobalValuesWriter(RasterizedValues values) {
        super("de.elpro.ewms.server.valueswriter.global", "Global Values Writer", ArchiveStorages.getGlobalViewInstance(), values, Server.getConfig().getGlobalViewWindowWidth() > 0L ? Long.valueOf(Server.getConfig().getGlobalViewRaster().toMilli() * Server.getConfig().getGlobalViewWindowWidth()) : null);
    }

    public boolean importSupplementValues(VariableInstance instance, SupplementValue[] values) {
        if (instance == null || values == null) {
            return false;
        }
        if (values.length == 0) {
            return true;
        }
        RADbTransaction trx = null;
        try {
            Server.getRawValuesViews().writeLockAllViews();
            TimeRangeMetadata globalViewMetadata = (TimeRangeMetadata)this.storage.getMetadata();
            trx = SupplementStorage.getInstance().beginTransaction();
            boolean updateGlobalViewMetadata = false;
            long fromTs = Long.MAX_VALUE;
            long toTs = Long.MIN_VALUE;
            SupplementValue[] supplementValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                SupplementValue av = supplementValueArray[n2];
                fromTs = Math.min(av.getStartTimestamp(), fromTs);
                toTs = Math.max(av.getEndTimestamp(), toTs);
                ++n2;
            }
            if (globalViewMetadata.getTimeRangeBegin() == null && globalViewMetadata.getTimeRangeEnd() == null) {
                globalViewMetadata.setTimeRangeBegin(this.raster.getRasterBegin(fromTs));
                globalViewMetadata.setTimeRangeEnd(this.raster.getRasterEnd(toTs));
                updateGlobalViewMetadata = true;
            }
            if (fromTs < globalViewMetadata.getTimeRangeBegin()) {
                globalViewMetadata.setTimeRangeBegin(this.rasterizedValues.getRaster().getRasterBegin(fromTs));
                updateGlobalViewMetadata = true;
            }
            if (toTs > globalViewMetadata.getTimeRangeEnd()) {
                globalViewMetadata.setTimeRangeEnd(this.rasterizedValues.getRaster().getRasterEnd(toTs));
                updateGlobalViewMetadata = true;
            }
            SupplementStorage.getInstance().saveValues(trx, instance, null, Arrays.asList(values));
            SupplementStorage.getInstance().commitTransaction(trx);
            SupplementStorage.getInstance().compressDb();
            if (updateGlobalViewMetadata) {
                RADbTransaction<TimeRangeMetadata> gTrx = this.storage.beginTransaction();
                try {
                    ((TimeRangeMetadata)gTrx.getMetadata()).setTimeRangeBegin(globalViewMetadata.getTimeRangeBegin());
                    ((TimeRangeMetadata)gTrx.getMetadata()).setTimeRangeEnd(globalViewMetadata.getTimeRangeEnd());
                    this.storage.commitTransaction(gTrx);
                }
                catch (Exception exception) {
                    this.storage.abortTransaction(gTrx);
                }
            }
            return true;
        }
        catch (Exception exc) {
            logger.error("Error writing supplement value", (Throwable)exc);
            if (trx != null) {
                SupplementStorage.getInstance().abortTransaction(trx);
            }
            SupplementStorage.getInstance().compressDb();
            return false;
        }
        finally {
            Server.getRawValuesViews().writeUnlockAllViews();
        }
    }

    @Override
    @Secured
    public boolean deleteSupplementValue(VariableInstance instance, Integer selector, long fromTs, long toTs, User user) {
        Server.getRawValuesViews().writeLockAllViews();
        RADbTransaction trx = SupplementStorage.getInstance().beginTransaction();
        try {
            long erasedFrom = fromTs;
            long erasedTo = toTs;
            if (instance.getSupplementValueStrategy() == SupplementValueStrategy.Unrasterized) {
                Server.getRawValuesViews().markGlobalViewValuesInvalid(instance, fromTs, null);
            } else {
                long clusterBegin = VirtualRaster.Year.getRasterBegin(Instant.ofEpochMilli(fromTs)).toEpochMilli();
                ArrayList nextValues = SupplementStorage.getInstance().loadValues(instance, clusterBegin, toTs + this.raster.toMilli());
                for (SupplementValue sv : nextValues) {
                    if (sv.getIntersectInterval(fromTs, toTs) <= 0L) continue;
                    erasedFrom = Math.min(erasedFrom, sv.getStartTimestamp());
                    erasedTo = Math.max(erasedTo, sv.getEndTimestamp());
                }
                nextValues = SupplementStorage.getInstance().loadValues(instance, erasedFrom, erasedTo + this.raster.toMilli());
                long changedTo = this.raster.getRasterEnd(erasedTo);
                for (SupplementValue sv : nextValues) {
                    if (sv.getStartTimestamp() != changedTo) continue;
                    changedTo = Math.max(changedTo, sv.getEndTimestamp());
                }
                Server.getRawValuesViews().markGlobalViewValuesInvalid(instance, erasedFrom, changedTo);
            }
            SupplementStorage.getInstance().deleteValues(trx, instance, selector, erasedFrom, erasedTo);
            SupplementStorage.getInstance().commitTransaction(trx);
            this.rasterizedValues.markValuesInvalid(instance, fromTs, toTs);
            return true;
        }
        catch (Exception exc) {
            logger.error("Error writing supplement value", (Throwable)exc);
            SupplementStorage.getInstance().abortTransaction(trx);
            return false;
        }
        finally {
            Server.getRawValuesViews().writeUnlockAllViews();
        }
    }

    @Override
    public boolean applySupplementValuesChanges(SupplementValueChange[] changes, boolean overwriteLaterUnrasterizedValues, User user) {
        try {
            Server.getRawValuesViews().writeLockAllViews();
            RasterizedValues.ComputationBounds bounds = this.rasterizedValues.getComputationBounds();
            Instant ts = Instant.now();
            long maxToTs = Long.MIN_VALUE;
            SupplementValueChange[] supplementValueChangeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                RADbTransaction trx;
                SupplementValueChange change = supplementValueChangeArray[n2];
                VariableInstance instance = ORMCache.getVariableInstance(change.getInstance().getId());
                Aggregation aggregation = instance.getVariable().getResultAggregation();
                if ((change.getFrom() == null || change.getTo() == null) && instance.getSupplementValueStrategy() != SupplementValueStrategy.Unrasterized) {
                    throw new Exception("Realtime Parameter value cannot be writen in an not unrasterized variable instance");
                }
                long fromTs = change.getFrom() != null ? change.getFrom().toEpochMilli() : ts.toEpochMilli();
                long toTs = change.getTo() != null ? change.getTo().toEpochMilli() : fromTs;
                long erasedFrom = fromTs;
                long erasedTo = toTs;
                maxToTs = Math.max(toTs, maxToTs);
                if (change.getFrom() == null || change.getTo() == null) {
                    fromTs = this.raster.getRasterBegin(fromTs);
                    toTs = this.raster.getRasterEnd(toTs);
                }
                Integer selector = change.getSelector();
                double value = change.getValue();
                ArrayList<SupplementValue> supplementValues = new ArrayList<SupplementValue>();
                if (instance.getSupplementValueStrategy() == SupplementValueStrategy.Unrasterized) {
                    Server.getRawValuesViews().markGlobalViewValuesInvalid(instance, fromTs, null);
                    if (Double.isFinite(value)) {
                        SupplementValue sv = new SupplementValue(fromTs, toTs, value, ts.toEpochMilli(), user.getId().intValue());
                        supplementValues.add(sv);
                    }
                } else {
                    long clusterBegin = VirtualRaster.Year.getRasterBegin(Instant.ofEpochMilli(fromTs)).toEpochMilli();
                    ArrayList nextValues = SupplementStorage.getInstance().loadValues(instance, selector, clusterBegin, toTs + this.raster.toMilli());
                    for (SupplementValue sv : nextValues) {
                        if (sv.getIntersectInterval(fromTs, toTs) <= 0L) continue;
                        erasedFrom = Math.min(erasedFrom, sv.getStartTimestamp());
                        erasedTo = Math.max(erasedTo, sv.getEndTimestamp());
                        if (Double.isFinite(value)) {
                            GlobalValuesWriter.mergeSupplementValues(aggregation, supplementValues, sv, fromTs, toTs, value, ts.toEpochMilli(), user.getId());
                            continue;
                        }
                        GlobalValuesWriter.mergeSupplementValueWithNaN(aggregation, supplementValues, sv, fromTs, toTs, ts.toEpochMilli(), user.getId());
                    }
                    if (Double.isFinite(value) && supplementValues.isEmpty()) {
                        SupplementValue sv;
                        sv = new SupplementValue(fromTs, toTs, value, ts.toEpochMilli(), user.getId().intValue());
                        supplementValues.add(sv);
                    }
                    nextValues = SupplementStorage.getInstance().loadValues(instance, selector, erasedFrom, erasedTo + this.raster.toMilli());
                    long changedTo = this.raster.getRasterEnd(erasedTo);
                    for (SupplementValue sv : nextValues) {
                        if (sv.getStartTimestamp() != changedTo) continue;
                        changedTo = Math.max(changedTo, sv.getEndTimestamp());
                    }
                    Server.getRawValuesViews().markGlobalViewValuesInvalid(instance, erasedFrom, changedTo);
                }
                if (fromTs == toTs && overwriteLaterUnrasterizedValues) {
                    trx = SupplementStorage.getInstance().beginTransaction();
                    long overwriteTo = bounds != null ? bounds.getValuesEndTs() : Long.MAX_VALUE;
                    SupplementStorage.getInstance().deleteValues(trx, instance, selector, fromTs, overwriteTo);
                    SupplementStorage.getInstance().commitTransaction(trx);
                }
                trx = SupplementStorage.getInstance().beginTransaction();
                SupplementStorage.getInstance().deleteValues(trx, instance, selector, erasedFrom, erasedTo);
                if (!supplementValues.isEmpty()) {
                    SupplementStorage.getInstance().saveValues(trx, instance, selector, supplementValues);
                }
                SupplementStorage.getInstance().commitTransaction(trx);
                ++n2;
            }
            return true;
        }
        catch (Exception exc) {
            logger.error("Error writing supplement value", (Throwable)exc);
            return false;
        }
        finally {
            Server.getRawValuesViews().writeUnlockAllViews();
        }
    }

    private static void mergeSupplementValues(Aggregation aggregation, ArrayList<SupplementValue> supplementValues, SupplementValue oldValue, long fromTs, long toTs, double value, long recTs, int uId) {
        Long prevValueEndTs = supplementValues.isEmpty() ? null : Long.valueOf(supplementValues.get(supplementValues.size() - 1).getEndTimestamp());
        switch (aggregation) {
            case Last: 
            case LastValid: {
                SupplementValue sv;
                if (oldValue.getStartTimestamp() < fromTs) {
                    sv = new SupplementValue(oldValue.getStartTimestamp(), toTs, value, recTs, uId);
                    supplementValues.add(sv);
                } else if (prevValueEndTs == null || prevValueEndTs <= fromTs) {
                    sv = new SupplementValue(fromTs, toTs, value, recTs, uId);
                    supplementValues.add(sv);
                }
                if (oldValue.getEndTimestamp() <= toTs) break;
                sv = new SupplementValue(toTs, oldValue.getEndTimestamp(), oldValue.getValue(), recTs, uId);
                supplementValues.add(sv);
                break;
            }
            case Sum: {
                SupplementValue sv;
                double partialValue;
                double lenRatio;
                if (oldValue.getStartTimestamp() < fromTs) {
                    lenRatio = (double)(fromTs - oldValue.getStartTimestamp()) / (double)(oldValue.getEndTimestamp() - oldValue.getStartTimestamp());
                    partialValue = oldValue.getValue() * lenRatio;
                    sv = new SupplementValue(oldValue.getStartTimestamp(), fromTs, partialValue, recTs, uId);
                    supplementValues.add(sv);
                }
                if (prevValueEndTs == null || prevValueEndTs <= fromTs) {
                    sv = new SupplementValue(fromTs, toTs, value, recTs, uId);
                    supplementValues.add(sv);
                }
                if (oldValue.getEndTimestamp() <= toTs) break;
                lenRatio = (double)(oldValue.getEndTimestamp() - toTs) / (double)(oldValue.getEndTimestamp() - oldValue.getStartTimestamp());
                partialValue = oldValue.getValue() * lenRatio;
                sv = new SupplementValue(toTs, oldValue.getEndTimestamp(), partialValue, recTs, uId);
                supplementValues.add(sv);
                break;
            }
            case Avg: 
            case Min: 
            case Max: 
            case BitOr: 
            case BitAnd: {
                SupplementValue sv;
                if (oldValue.getStartTimestamp() < fromTs) {
                    sv = new SupplementValue(oldValue.getStartTimestamp(), fromTs, oldValue.getValue(), recTs, uId);
                    supplementValues.add(sv);
                }
                if (prevValueEndTs == null || prevValueEndTs <= fromTs) {
                    sv = new SupplementValue(fromTs, toTs, value, recTs, uId);
                    supplementValues.add(sv);
                }
                if (oldValue.getEndTimestamp() <= toTs) break;
                sv = new SupplementValue(toTs, oldValue.getEndTimestamp(), oldValue.getValue(), recTs, uId);
                supplementValues.add(sv);
                break;
            }
        }
    }

    private static void mergeSupplementValueWithNaN(Aggregation aggregation, ArrayList<SupplementValue> supplementValues, SupplementValue oldValue, long fromTs, long toTs, long recTs, int uId) {
        switch (aggregation) {
            case Last: 
            case LastValid: {
                SupplementValue sv;
                if (oldValue.getStartTimestamp() < fromTs) {
                    sv = new SupplementValue(oldValue.getStartTimestamp(), fromTs, oldValue.getValue(), recTs, uId);
                    supplementValues.add(sv);
                }
                if (oldValue.getEndTimestamp() <= toTs) break;
                sv = new SupplementValue(toTs, oldValue.getEndTimestamp(), oldValue.getValue(), recTs, uId);
                supplementValues.add(sv);
                break;
            }
            case Sum: {
                SupplementValue sv;
                double partialValue;
                double lenRatio;
                if (oldValue.getStartTimestamp() < fromTs) {
                    lenRatio = (double)(fromTs - oldValue.getStartTimestamp()) / (double)(oldValue.getEndTimestamp() - oldValue.getStartTimestamp());
                    partialValue = oldValue.getValue() * lenRatio;
                    sv = new SupplementValue(oldValue.getStartTimestamp(), fromTs, partialValue, recTs, uId);
                    supplementValues.add(sv);
                }
                if (oldValue.getEndTimestamp() <= toTs) break;
                lenRatio = (double)(oldValue.getEndTimestamp() - toTs) / (double)(oldValue.getEndTimestamp() - oldValue.getStartTimestamp());
                partialValue = oldValue.getValue() * lenRatio;
                sv = new SupplementValue(toTs, oldValue.getEndTimestamp(), partialValue, recTs, uId);
                supplementValues.add(sv);
                break;
            }
            case Avg: 
            case Min: 
            case Max: 
            case BitOr: 
            case BitAnd: {
                SupplementValue sv;
                if (oldValue.getStartTimestamp() < fromTs) {
                    sv = new SupplementValue(oldValue.getStartTimestamp(), fromTs, oldValue.getValue(), recTs, uId);
                    supplementValues.add(sv);
                }
                if (oldValue.getEndTimestamp() <= toTs) break;
                sv = new SupplementValue(toTs, oldValue.getEndTimestamp(), oldValue.getValue(), recTs, uId);
                supplementValues.add(sv);
                break;
            }
        }
    }
}

