/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.valueswriter;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.bundle.Activator;
import de.elpro.ewms.server.model.VariableInstanceValuesValidator;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.rasterizedvalues.StoredValuesConverter;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.fx.core.log.Logger;

public class MeasurementsPool {
    public static final Logger logger = Activator.getLoggerFactory().createLogger(MeasurementsPool.class.getName());
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    public static final long POOL_WIDTH = Math.max(Server.getConfig().getGlobalViewRaster().toMilli() + Server.getGlobalValuesWriter().getExecutionInterval() * 3L, Server.getRawValuesWriter().getExecutionInterval() * 2L);
    private static final Map<VariableInstance, LinkedList<MeasuredValue>> MEASURED_VALUES = new HashMap<VariableInstance, LinkedList<MeasuredValue>>();
    private static final Table<String, VariableInstance, Long> PERSISTED_END_TIMESTAMPS = HashBasedTable.create();
    private static final Table<String, VariableInstance, Long> RESTORED_END_TIMESTAMPS = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendValues(Map<VariableInstance, List<MeasuredValue>> newValues) {
        MeasurementsPool.checkTimeIntervals(newValues);
        Map<VariableInstance, LinkedList<MeasuredValue>> map = MEASURED_VALUES;
        synchronized (map) {
            for (Map.Entry<VariableInstance, List<MeasuredValue>> entry : newValues.entrySet()) {
                VariableInstance instance = entry.getKey();
                List<MeasuredValue> measuredValues = entry.getValue();
                if (measuredValues == null || measuredValues.isEmpty()) continue;
                LinkedList<Object> values = null;
                values = MEASURED_VALUES.get(instance);
                if (values == null) {
                    values = new LinkedList();
                    MEASURED_VALUES.put(instance, values);
                } else {
                    MEASURED_VALUES.remove(instance);
                    MEASURED_VALUES.put(instance, values);
                }
                LinkedList<MeasuredValue> addAfter = new LinkedList<MeasuredValue>();
                if (!values.isEmpty()) {
                    Object lastValue = (MeasuredValue)values.getLast();
                    MeasuredValue firstNewValue = measuredValues.get(0);
                    MeasuredValue lastNewValue = measuredValues.get(measuredValues.size() - 1);
                    while (lastValue != null && lastValue.getEndTimestamp() > firstNewValue.getStartTimestamp()) {
                        values.removeLast();
                        if (lastNewValue.getEndTimestamp() <= lastValue.getStartTimestamp()) {
                            addAfter.addFirst((MeasuredValue)lastValue);
                        }
                        lastValue = !values.isEmpty() ? (MeasuredValue)values.getLast() : null;
                    }
                }
                values.addAll(measuredValues);
                for (MeasuredValue tailValues : addAfter) {
                    values.addLast(tailValues);
                }
                Object firstValue = (IStoredVarValue)values.getFirst();
                IStoredVarValue lastValue = (IStoredVarValue)values.getLast();
                while (firstValue != null && firstValue.getStartTimestamp() < lastValue.getEndTimestamp() - POOL_WIDTH) {
                    values.removeFirst();
                    firstValue = !values.isEmpty() ? (IStoredVarValue)values.getFirst() : null;
                }
            }
        }
    }

    public static void applyChanges(boolean syncExec) throws InterruptedException, ExecutionException {
        if (syncExec) {
            Future<?> realtimeFuture = EXECUTORS.submit(() -> Server.getRealtimeValuesWriter().execute());
            Future<?> globalFuture = EXECUTORS.submit(() -> Server.getGlobalValuesWriter().execute());
            realtimeFuture.get();
            globalFuture.get();
        } else {
            Server.getRealtimeValuesWriter().wake();
            Server.getGlobalValuesWriter().wake();
        }
    }

    private static void checkTimeIntervals(Map<VariableInstance, List<MeasuredValue>> newValues) {
        for (List<MeasuredValue> values : newValues.values()) {
            if (values.isEmpty()) continue;
            Iterator<MeasuredValue> mvi = values.iterator();
            MeasuredValue prevValue = mvi.next();
            while (mvi.hasNext()) {
                MeasuredValue value = mvi.next();
                if (prevValue.getEndTimestamp() != value.getStartTimestamp()) {
                    throw new IllegalArgumentException(String.format("Inconsistent measurements values timestamp for measured values %s und %s", prevValue, value));
                }
                if (value.getStartTimestamp() >= value.getEndTimestamp()) {
                    throw new IllegalArgumentException(String.format("Illegal time interval of value %s", value));
                }
                prevValue = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<VariableInstance, IVarValuesCollection> getNewMeasurements(String persisterKey) {
        HashMap<VariableInstance, IVarValuesCollection> allUnpersistedValues = new HashMap<VariableInstance, IVarValuesCollection>();
        Map<VariableInstance, LinkedList<MeasuredValue>> map = MEASURED_VALUES;
        synchronized (map) {
            for (Map.Entry<VariableInstance, LinkedList<MeasuredValue>> instanceValues : MEASURED_VALUES.entrySet()) {
                long newPersistedTs;
                VariableInstance instance = instanceValues.getKey();
                LinkedList<MeasuredValue> values = instanceValues.getValue();
                LinkedList<MeasuredValue> unpersistedValues = new LinkedList<MeasuredValue>();
                Long persistedTs = (Long)PERSISTED_END_TIMESTAMPS.get((Object)persisterKey, (Object)instance);
                long l = newPersistedTs = persistedTs != null ? persistedTs : 0L;
                if (persistedTs == null) {
                    for (MeasuredValue mv : values) {
                        newPersistedTs = mv.getEndTimestamp();
                        unpersistedValues.add(mv);
                    }
                } else {
                    Iterator<MeasuredValue> descedingIterator = values.descendingIterator();
                    while (descedingIterator.hasNext()) {
                        MeasuredValue measuredValue = descedingIterator.next();
                        if (measuredValue.getEndTimestamp() > persistedTs) {
                            unpersistedValues.addFirst(measuredValue);
                            newPersistedTs = Math.max(newPersistedTs, measuredValue.getEndTimestamp());
                            continue;
                        }
                        break;
                    }
                }
                PERSISTED_END_TIMESTAMPS.put((Object)persisterKey, (Object)instance, (Object)newPersistedTs);
                if (unpersistedValues.isEmpty()) continue;
                allUnpersistedValues.put(instance, IVarValuesCollection.create(unpersistedValues));
            }
        }
        return allUnpersistedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<VariableInstance, ArrayList<ArchiveValue>> getNewMeasurements(String persisterKey, Raster raster) {
        Iterator descedingIterator;
        HashMap allUnpersistedValues = new HashMap();
        long minPersistedTs = Long.MAX_VALUE;
        long maxValuesStartTs = Long.MIN_VALUE;
        HashMap<VariableInstance, TsInterval> rawValuesSearchIntervals = new HashMap<VariableInstance, TsInterval>();
        Map<VariableInstance, LinkedList<MeasuredValue>> map = MEASURED_VALUES;
        synchronized (map) {
            for (Map.Entry<VariableInstance, LinkedList<MeasuredValue>> entry : MEASURED_VALUES.entrySet()) {
                long newPersistedTs;
                VariableInstance variableInstance = entry.getKey();
                LinkedList<MeasuredValue> linkedList = entry.getValue();
                LinkedList<MeasuredValue> unpersistedValues = new LinkedList<MeasuredValue>();
                Long persistedTs = (Long)PERSISTED_END_TIMESTAMPS.get((Object)persisterKey, (Object)variableInstance);
                long l = newPersistedTs = persistedTs != null ? persistedTs : 0L;
                if (persistedTs == null) {
                    for (MeasuredValue mv : linkedList) {
                        newPersistedTs = raster.getRasterBegin(mv.getEndTimestamp());
                        unpersistedValues.add(mv);
                    }
                } else {
                    descedingIterator = linkedList.descendingIterator();
                    if (!linkedList.isEmpty() && persistedTs >= linkedList.getLast().getEndTimestamp()) continue;
                    persistedTs = raster.getRasterBegin(persistedTs.longValue());
                    while (descedingIterator.hasNext()) {
                        MeasuredValue measuredValue = descedingIterator.next();
                        if (measuredValue.getEndTimestamp() > persistedTs) {
                            Long restoredEndTimestamp;
                            unpersistedValues.addFirst(measuredValue);
                            newPersistedTs = Math.max(newPersistedTs, measuredValue.getEndTimestamp());
                            if (descedingIterator.hasNext() || persistedTs >= measuredValue.getStartTimestamp() || (restoredEndTimestamp = (Long)RESTORED_END_TIMESTAMPS.get((Object)persisterKey, (Object)variableInstance)) != null && restoredEndTimestamp >= measuredValue.getStartTimestamp()) continue;
                            RESTORED_END_TIMESTAMPS.put((Object)persisterKey, (Object)variableInstance, (Object)measuredValue.getStartTimestamp());
                            TsInterval rawSearchInterval = new TsInterval(persistedTs.longValue(), measuredValue.getStartTimestamp());
                            rawValuesSearchIntervals.put(variableInstance, rawSearchInterval);
                            minPersistedTs = Math.min(minPersistedTs, persistedTs);
                            maxValuesStartTs = Math.max(maxValuesStartTs, measuredValue.getStartTimestamp());
                            continue;
                        }
                        break;
                    }
                }
                PERSISTED_END_TIMESTAMPS.put((Object)persisterKey, (Object)variableInstance, (Object)newPersistedTs);
                if (unpersistedValues.isEmpty()) continue;
                allUnpersistedValues.put(variableInstance, unpersistedValues);
            }
        }
        if (!rawValuesSearchIntervals.isEmpty()) {
            try {
                MeasuredValue mv;
                long ts = System.nanoTime();
                HashMap restoredRawValues = new HashMap();
                block11: for (Map.Entry<VariableInstance, IVarValuesCollection> entry : MeasurementsStorage.getOrCreateInstance().readMeasurements((Long)minPersistedTs, (Long)maxValuesStartTs, rawValuesSearchIntervals.keySet()).entrySet()) {
                    VariableInstance instance2 = entry.getKey();
                    LinkedList instanceUnpersistedValues = (LinkedList)allUnpersistedValues.get(instance2);
                    LinkedList<MeasuredValue> rawValues = new LinkedList<MeasuredValue>();
                    for (IVarValue rv : entry.getValue()) {
                        rawValues.add((MeasuredValue)rv);
                    }
                    TsInterval missingInterval = (TsInterval)rawValuesSearchIntervals.get(instance2);
                    descedingIterator = rawValues.descendingIterator();
                    MeasuredValue firstUnpersistedValue = (MeasuredValue)instanceUnpersistedValues.getFirst();
                    LinkedList<MeasuredValue> restoredInstanceRawValues = null;
                    while (descedingIterator.hasNext()) {
                        mv = (MeasuredValue)descedingIterator.next();
                        if (mv.getEndTimestamp() <= missingInterval.getFromTs()) continue block11;
                        if (mv.getEndTimestamp() > firstUnpersistedValue.getStartTimestamp()) continue;
                        instanceUnpersistedValues.addFirst(mv);
                        if (restoredInstanceRawValues == null) {
                            restoredInstanceRawValues = new LinkedList<MeasuredValue>();
                            restoredRawValues.put(instance2, restoredInstanceRawValues);
                        }
                        restoredInstanceRawValues.addFirst(mv);
                    }
                }
                if (!restoredRawValues.isEmpty()) {
                    Map<VariableInstance, LinkedList<MeasuredValue>> map2 = MEASURED_VALUES;
                    synchronized (map2) {
                        for (Map.Entry entry : restoredRawValues.entrySet()) {
                            VariableInstance instance3 = (VariableInstance)entry.getKey();
                            LinkedList restoredMeasurements = (LinkedList)entry.getValue();
                            LinkedList<MeasuredValue> poolMeasurements = MEASURED_VALUES.get(instance3);
                            if (poolMeasurements == null || poolMeasurements.isEmpty()) continue;
                            long firstTs = poolMeasurements.getFirst().getStartTimestamp();
                            Iterator descedingIterator2 = restoredMeasurements.descendingIterator();
                            while (descedingIterator2.hasNext()) {
                                mv = (MeasuredValue)descedingIterator2.next();
                                if (mv.getEndTimestamp() >= firstTs) continue;
                                poolMeasurements.addFirst(mv);
                            }
                        }
                    }
                }
                TsInterval tsInterval = new TsInterval(minPersistedTs, maxValuesStartTs);
                long l = (System.nanoTime() - ts) / 1000000L;
                if (l > 100L) {
                    logger.warningf("%s: measurement pool outranged. %s interval filled over RAW DB in %d ms", new Object[]{persisterKey, tsInterval, l});
                }
            }
            catch (Exception exc) {
                logger.error("Error searching new measurents in RAW db", (Throwable)exc);
            }
        }
        HashMap<VariableInstance, ArrayList<ArchiveValue>> allWriteValues = new HashMap<VariableInstance, ArrayList<ArchiveValue>>();
        for (Map.Entry<Object, LinkedList<Object>> entry : allUnpersistedValues.entrySet()) {
            VariableInstance variableInstance = (VariableInstance)entry.getKey();
            LinkedList<Object> linkedList = entry.getValue();
            ArrayList<ArchiveValue> writeValues = new ArrayList<ArchiveValue>();
            Aggregation aggr = variableInstance.getResultPlcRawValueAggregation();
            if (aggr == null) {
                throw new IllegalArgumentException("Trying to write archive value for instance without plc raw value aggregation property");
            }
            long toTs = raster.getRasterEnd(((MeasuredValue)linkedList.getFirst()).getEndTimestamp());
            long fromTs = toTs - raster.toMilli();
            long firstTs = ((MeasuredValue)linkedList.getFirst()).getStartTimestamp();
            ArrayList<MeasuredValue> oneRasterValues = new ArrayList<MeasuredValue>();
            for (MeasuredValue measuredValue : linkedList) {
                if (measuredValue.getEndTimestamp() > toTs) {
                    MeasurementsPool.addRasterizedValue(writeValues, oneRasterValues, variableInstance, raster, fromTs, toTs, firstTs, aggr);
                    oneRasterValues.clear();
                    toTs = raster.getRasterEnd(measuredValue.getEndTimestamp());
                    fromTs = toTs - raster.toMilli();
                    firstTs = measuredValue.getStartTimestamp();
                }
                oneRasterValues.add(measuredValue);
            }
            MeasurementsPool.addRasterizedValue(writeValues, oneRasterValues, variableInstance, raster, fromTs, toTs, firstTs, aggr);
            allWriteValues.put(variableInstance, writeValues);
        }
        return allWriteValues;
    }

    private static void addRasterizedValue(ArrayList<ArchiveValue> writeValues, ArrayList<MeasuredValue> oneRasterValues, VariableInstance instance, Raster raster, long fromTs, long toTs, long firstTs, Aggregation aggr) {
        if (oneRasterValues.size() > 1) {
            RasterizedValues.validateResult(oneRasterValues.toArray(new IVarValue[0]), new VariableInstanceValuesValidator(instance));
            IVarValue aggregatedValue = StoredValuesConverter.convertStoredNoParameterValues(oneRasterValues, fromTs, toTs, raster, aggr, false)[0];
            writeValues.add(new ArchiveValue(firstTs, aggregatedValue.getEndTimestamp(), aggregatedValue.getValue(), aggregatedValue.getQuality()));
        } else if (oneRasterValues.size() == 1) {
            MeasuredValue oneRasterValue = oneRasterValues.get(0);
            writeValues.add(new ArchiveValue(oneRasterValue.getStartTimestamp(), oneRasterValue.getEndTimestamp(), oneRasterValue.getValue(), oneRasterValue.getQuality()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeValues(VariableInstance instance) {
        Map<VariableInstance, LinkedList<MeasuredValue>> map = MEASURED_VALUES;
        synchronized (map) {
            MEASURED_VALUES.remove(instance);
            HashSet keys = new HashSet(PERSISTED_END_TIMESTAMPS.column((Object)instance).keySet());
            for (String key : keys) {
                PERSISTED_END_TIMESTAMPS.remove((Object)key, (Object)instance);
            }
        }
    }
}

