/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.valueswriter;

import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.server.db.rawmeasurements.RawDB;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import java.util.Map;
import java.util.concurrent.Callable;

public class RawValuesWriter
extends AbstractWorker {
    private Map<VariableInstance, IVarValuesCollection> toWrite;
    private final RawDB storage;
    private final Callable<Void> workTask = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            RawValuesWriter.this.storage.storeMeasurements(RawValuesWriter.this.toWrite);
            RawValuesWriter.this.toWrite.clear();
            return null;
        }
    };

    public RawValuesWriter(long executionInterval) {
        super("de.elpro.ewms.server.valueswriter.raw", "RAW Values Writer", executionInterval, false);
        this.storage = MeasurementsStorage.getOrCreateInstance();
    }

    protected boolean doStart() {
        return this.storage.start();
    }

    protected boolean canDoWork() {
        if (this.toWrite == null || this.toWrite.isEmpty()) {
            this.toWrite = MeasurementsPool.getNewMeasurements(this.getId());
        }
        return !this.toWrite.isEmpty();
    }

    protected Callable<Void> createWorkTask() {
        return this.workTask;
    }

    protected void doStop() {
        this.storage.stop();
    }
}

