/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.hibernate.model;

import com.neovisionaries.i18n.CountryCode;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="core_address")
public class Address {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="core_address_sequence")
    @SequenceGenerator(name="core_address_sequence", sequenceName="core_address_sequence")
    private int id;
    @Column(name="street")
    private String street;
    @Column(name="street_additional")
    private String streetAdditional;
    @Column(name="zip")
    private String zip;
    @Column(name="city")
    private String city;
    @Column(name="region")
    private String region;
    @Column(name="country")
    private CountryCode countryCode = CountryCode.DE;

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetAdditional() {
        return this.streetAdditional;
    }

    public void setStreetAdditional(String streetAdditional) {
        this.streetAdditional = streetAdditional;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCode countryCode) {
        this.countryCode = countryCode;
    }

    public int getId() {
        return this.id;
    }

    public boolean isEmpty() {
        if (this.street != null && !this.street.isEmpty()) {
            return false;
        }
        if (this.streetAdditional != null && !this.streetAdditional.isEmpty()) {
            return false;
        }
        if (this.zip != null && !this.zip.isEmpty()) {
            return false;
        }
        if (this.city != null && !this.city.isEmpty()) {
            return false;
        }
        if (this.region != null && !this.region.isEmpty()) {
            return false;
        }
        return this.countryCode == null || this.countryCode == CountryCode.UNDEFINED;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Address)) {
            return false;
        }
        Address a = (Address)obj;
        return (this.street + this.streetAdditional + this.zip + this.city + this.region + this.countryCode).equals(a.street + a.streetAdditional + a.zip + a.city + a.region + a.countryCode);
    }
}

