/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.hibernate.service.internal;

import de.elpro.hibernate.model.IHbmConfigExtension;
import de.elpro.hibernate.model.ServerConfiguration;
import de.elpro.hibernate.model.SqlServerType;
import de.elpro.hibernate.service.IHibernateConfigurationService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.fx.core.ServiceUtils;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class HibernateConfigurationService
implements IHibernateConfigurationService {
    private static final String REGISTRY_EXTENSION_POINT_ID = "de.elpro.hibernate.config";
    private Map<String, HibernateConfig> configs = new HashMap<String, HibernateConfig>();
    private Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();
    private Map<String, ServerConfiguration> loginDatas = new HashMap<String, ServerConfiguration>();
    private Map<String, Map<String, String>> customProperties = new HashMap<String, Map<String, String>>();

    private HibernateConfig createConfig(String key) {
        this.configs.put(key, new HibernateConfig());
        return this.getConfig(key);
    }

    private HibernateConfig getConfig(String key) {
        return this.configs.get(key);
    }

    @Override
    public ServerConfiguration getServerConfiguration(SqlServerType type) {
        return this.getServerConfiguration("default", type);
    }

    @Override
    public ServerConfiguration getServerConfiguration(String key, SqlServerType type) {
        ServerConfiguration loginData = this.loginDatas.get(key);
        if (loginData == null) {
            loginData = new ServerConfiguration(key, type);
            this.loginDatas.put(key, loginData);
        }
        return loginData;
    }

    @Override
    public void setCustomProperty(String property, String value) {
        this.setCustomProperty("default", property, value);
    }

    @Override
    public void setCustomProperty(String key, String property, String value) {
        Map<String, String> properties = this.customProperties.get(key);
        if (properties == null) {
            properties = new LinkedHashMap<String, String>();
            this.customProperties.put(key, properties);
        }
        properties.put(property, value);
    }

    @Override
    public Configuration createHibernateConfiguration() {
        return this.createHibernateConfiguration("default");
    }

    @Override
    public Configuration createHibernateConfiguration(String key) {
        return this.createConfig(key).getHibernateConfigurations();
    }

    @Override
    public Configuration getHibernateConfiguration() {
        return this.getHibernateConfiguration("default");
    }

    @Override
    public Configuration getHibernateConfiguration(String key) {
        return this.getConfig(key).getHibernateConfigurations();
    }

    @Override
    public void registerClass(Class<?> clazz) {
        this.registerClass("default", clazz);
    }

    @Override
    public void registerClass(String key, Class<?> clazz) {
        this.getConfig(key).registerClass(clazz);
    }

    public SessionFactory createEntityManagerFactory() {
        return this.createEntityManagerFactory("default");
    }

    public SessionFactory createEntityManagerFactory(String key) {
        HibernateConfig hbmConfig = this.getConfig(key);
        for (IHbmConfigExtension configExt : ServiceUtils.getServiceList(IHbmConfigExtension.class)) {
            for (Class<?> clazz : configExt.getMappings(key)) {
                hbmConfig.getHibernateConfigurations().addAnnotatedClass(clazz);
            }
        }
        SessionFactory sessionFactory = hbmConfig.createSessionFactory();
        this.sessionFactories.put(key, sessionFactory);
        return sessionFactory;
    }

    public SessionFactory createEntityManagerFactory(ServerConfiguration serverConfiguration) {
        Configuration cfg = this.getHibernateConfiguration(serverConfiguration.getKey());
        cfg.setProperty("hibernate.id.sequence.increment_size_mismatch_strategy", "fix");
        cfg.setProperty("hibernate.show_sql", "false");
        cfg.setProperty("hibernate.hbm2ddl.auto", "update");
        cfg.setProperty("hibernate.connection.pool_size", "5");
        cfg.setProperty("hibernate.c3p0.min_size", Integer.toString(serverConfiguration.getC3P0MinPoolSize()));
        cfg.setProperty("hibernate.c3p0.max_size", Integer.toString(serverConfiguration.getC3P0MaxPoolSize()));
        cfg.setProperty("hibernate.c3p0.timeout", "600");
        cfg.setProperty("hibernate.c3p0.max_statements", "100");
        cfg.setProperty("hibernate.c3p0.idle_test_period", "300");
        cfg.setProperty("hibernate.connection.username", serverConfiguration.getLogin());
        cfg.setProperty("hibernate.connection.password", serverConfiguration.getPassword());
        switch (serverConfiguration.getType()) {
            case POSTGRES: {
                String connectionString = "jdbc:postgresql://" + serverConfiguration.getServerName() + "/" + serverConfiguration.getDbName();
                cfg.setProperty("hibernate.connection.url", connectionString);
                cfg.setProperty("hibernate.connection.driver_class", "org.postgresql.Driver");
                break;
            }
            case MSSQL: {
                cfg.setProperty("hibernate.default_schema", "dbo");
                String connectionString = "jdbc:jtds:sqlserver://" + serverConfiguration.getServerName() + "/" + serverConfiguration.getDbName() + (serverConfiguration.getInstance() != null && !serverConfiguration.getInstance().isEmpty() ? ";instance=" + serverConfiguration.getInstance() : "");
                cfg.setProperty("hibernate.connection.url", connectionString);
            }
        }
        Map<String, String> properties = this.customProperties.get(serverConfiguration.getKey());
        if (properties != null) {
            properties.entrySet().forEach(e -> {
                Configuration configuration2 = cfg.setProperty((String)e.getKey(), (String)e.getValue());
            });
        }
        return this.createEntityManagerFactory(serverConfiguration.getKey());
    }

    public SessionFactory getEntityManagerFactory() {
        return this.getEntityManagerFactory("default");
    }

    public SessionFactory getEntityManagerFactory(String key) {
        return this.sessionFactories.get(key);
    }

    private static class HibernateConfig {
        private Configuration cfg = new Configuration();
        private BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = new BootstrapServiceRegistryBuilder();

        private HibernateConfig() {
        }

        public Configuration getHibernateConfigurations() {
            return this.cfg;
        }

        public void registerClass(Class<?> clazz) {
            this.cfg.addAnnotatedClass(clazz);
            this.bootstrapServiceRegistryBuilder.applyClassLoader(clazz.getClassLoader());
        }

        public SessionFactory createSessionFactory() {
            StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder(this.bootstrapServiceRegistryBuilder.build());
            SessionFactory sessionFactory = this.cfg.buildSessionFactory((ServiceRegistry)ssrb.applySettings((Map)this.cfg.getProperties()).build());
            return sessionFactory;
        }
    }
}

