/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.sankey;

import com.google.common.base.Preconditions;
import de.elpro.ui.fx.charts.Messages;
import de.elpro.ui.fx.charts.sankey.SankeyFXChart;
import de.elpro.ui.fx.charts.sankey.SankeyFXNode;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Text;
import javafx.util.StringConverter;

public class SankeyFXLink
extends Group {
    private final MoveTo startPoint = new MoveTo();
    private final CubicCurveTo topCurve = new CubicCurveTo();
    private final VLineTo rightLine = new VLineTo();
    private final CubicCurveTo bottomCurve = new CubicCurveTo();
    private final Path path = new Path(new PathElement[]{this.startPoint, this.topCurve, this.rightLine, this.bottomCurve, new ClosePath()});
    private final Text valueText = new Text();
    private SankeyFXNode source;
    private SankeyFXNode target;
    private ReadOnlyObjectWrapper<SankeyFXChart> chart = new ReadOnlyObjectWrapper();
    private DoubleProperty value;

    public SankeyFXLink(SankeyFXNode source, SankeyFXNode target, DoubleProperty value, StringConverter<Double> valueFormatter) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source cannot be null");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target cannot be null");
        this.source = source;
        this.target = target;
        this.value = value;
        this.value.addListener((observable, oldValue, newValue) -> this.getChart().valueHasChangedFor(this));
        this.setColor();
        this.valueText.setText(valueFormatter != null ? valueFormatter.toString((Object)value.getValue()) : value.getValue().toString());
        this.getChildren().addAll((Object[])new Node[]{this.path, this.valueText});
        Tooltip tt = new Tooltip();
        tt.setAutoFix(true);
        tt.setAutoHide(false);
        this.setOnMouseEntered(e -> {
            this.setDarkerColor();
            String valueText = valueFormatter != null ? valueFormatter.toString((Object)value.getValue()) : value.getValue().toString();
            tt.setText(String.format(Messages.sankey_SankeyFXLink_Value, source.getName(), target.getName(), valueText));
            tt.show((Node)this, e.getScreenX() + 20.0, e.getSceneY() + 40.0);
        });
        this.setOnMouseExited(e -> {
            this.setNormalColor();
            tt.hide();
        });
        this.setOnMouseMoved(e -> {
            tt.setAnchorX(e.getScreenX() + 20.0);
            tt.setAnchorY(e.getSceneY() + 40.0);
        });
    }

    public double getValue() {
        return this.value.get();
    }

    public void setValue(double value) {
        this.value.set(value);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public SankeyFXNode getSource() {
        return this.source;
    }

    public SankeyFXNode getTarget() {
        return this.target;
    }

    public void setRefPoints(double leftX, double leftY, double rightX, double rightY, double heigth) {
        this.startPoint.setX(leftX);
        this.startPoint.setY(leftY);
        double distance = rightX - leftX;
        this.topCurve.setControlX1(leftX + distance / 3.0);
        this.topCurve.setControlY1(leftY);
        this.topCurve.setControlX2(rightX - distance / 3.0);
        this.topCurve.setControlY2(rightY);
        this.topCurve.setX(rightX);
        this.topCurve.setY(rightY);
        this.rightLine.setY(rightY + heigth);
        this.bottomCurve.setControlX1(rightX - distance / 3.0);
        this.bottomCurve.setControlY1(rightY + heigth);
        this.bottomCurve.setControlX2(leftX + distance / 3.0);
        this.bottomCurve.setControlY2(leftY + heigth);
        this.bottomCurve.setX(leftX);
        this.bottomCurve.setY(leftY + heigth);
        double textHeight = this.valueText.getBoundsInLocal().getHeight();
        double textWidth = this.valueText.getBoundsInLocal().getWidth();
        if (this.getChart().isShowLinkValues() && heigth > textHeight && rightX - leftX > textWidth) {
            this.valueText.setX((leftX + rightX - textWidth) / 2.0);
            this.valueText.setY((leftY + rightY + heigth + textHeight / 2.0) / 2.0);
            if (!this.getChildren().contains((Object)this.valueText)) {
                this.getChildren().add((Object)this.valueText);
            }
            this.valueText.setRotate(Math.atan((rightY - leftY) / ((rightX - leftX) * 0.75)) * 180.0 / Math.PI);
        } else {
            this.getChildren().remove((Object)this.valueText);
        }
    }

    private void setColor() {
        if (this.source.getFill() instanceof Color && this.target.getFill() instanceof Color) {
            Color sourceColor = (Color)this.source.getFill();
            Color targetColor = (Color)this.target.getFill();
            LinearGradient gradientColor = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, sourceColor), new Stop(1.0, targetColor)});
            this.path.setFill((Paint)gradientColor);
        } else {
            this.path.setFill(this.source.getFill());
        }
        this.setNormalColor();
        this.path.setStroke(null);
    }

    public void setDarkerColor() {
        this.path.setOpacity(0.7);
    }

    public void setNormalColor() {
        this.path.setOpacity(0.5);
    }

    public void setChart(SankeyFXChart chart) {
        this.chart.setValue((Object)chart);
    }

    public SankeyFXChart getChart() {
        return (SankeyFXChart)((Object)this.chart.get());
    }

    public ReadOnlyObjectWrapper<SankeyFXChart> chartProperty() {
        return this.chart;
    }

    public boolean isRelatedTo(SankeyFXNode node) {
        return ((Object)((Object)this.source)).equals((Object)node) || ((Object)((Object)this.target)).equals((Object)node);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ((Object)((Object)this.source)).hashCode();
        result = 31 * result + ((Object)((Object)this.target)).hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.chart.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SankeyFXLink that = (SankeyFXLink)((Object)o);
        if (!((Object)((Object)this.source)).equals((Object)that.source)) {
            return false;
        }
        if (!((Object)((Object)this.target)).equals((Object)that.target)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.chart.equals(that.chart);
    }
}

