/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.sankey;

import de.elpro.ui.fx.charts.sankey.SankeyFXChart;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;

public class SankeyFXNode
extends Group {
    private final Rectangle rect = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private final Label label = new Label();
    private final SimpleBooleanProperty showGraphicProperty = new SimpleBooleanProperty(true);
    private final StringConverter<Double> valueFormatter;
    private StringProperty name = new StringPropertyBase(){

        protected void invalidated() {
            if (SankeyFXNode.this.chart.get() != null) {
                ((SankeyFXChart)((Object)SankeyFXNode.this.chart.get())).nameHasChangedFor(SankeyFXNode.this);
            }
        }

        public Object getBean() {
            return SankeyFXNode.this;
        }

        public String getName() {
            return "nodeName";
        }
    };
    private Double value;
    private int horizontalPosition;
    private int verticalPosition;
    private Integer fixedHorizontalPosition;
    private ReadOnlyObjectWrapper<SankeyFXChart> chart = new ReadOnlyObjectWrapper(null, "chart");
    double originalX;
    double originalY;
    EventHandler<MouseEvent> nodeOnMousePressedEventHandler = t -> {
        this.originalX = t.getSceneX();
        this.originalY = t.getSceneY();
    };
    EventHandler<MouseEvent> nodeOnMouseDraggedEventHandler = t -> {
        SankeyFXNode sankeyFXNode = this;
        synchronized (sankeyFXNode) {
            this.setX(this.getX() + t.getSceneX() - this.originalX);
            this.setY(this.getY() + t.getSceneY() - this.originalY);
            this.originalX = t.getSceneX();
            this.originalY = t.getSceneY();
            ((SankeyFXChart)((Object)((Object)this.chart.get()))).positionHasChangedFor(this);
        }
    };

    public Double getValue() {
        return this.value;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public Paint getFill() {
        return this.rect.getFill();
    }

    public void setFill(Paint fill) {
        this.rect.setFill(fill);
    }

    public double getX() {
        return this.getLayoutX();
    }

    public void setX(double x) {
        this.setLayoutX(x);
    }

    public double getY() {
        return this.getLayoutY();
    }

    public void setY(double y) {
        this.setLayoutY(y);
    }

    public double getWidth() {
        return this.rect.getWidth();
    }

    public double getLabelWidth() {
        if (this.getChildren().size() > 1) {
            this.label.autosize();
            return this.label.getWidth();
        }
        return 0.0;
    }

    public double getHeight() {
        return this.rect.getHeight();
    }

    public void setWidth(double width) {
        this.rect.setWidth(width);
    }

    public void setHeight(double height) {
        this.rect.setHeight(height);
    }

    public void setValue(Double value) {
        this.value = value;
        this.updateLabel();
    }

    public boolean showGraphic() {
        return this.showGraphicProperty.get();
    }

    public void setShowGraphic(boolean showGraphic) {
        this.showGraphicProperty.set(showGraphic);
    }

    public int getHorizontalPosition() {
        return this.fixedHorizontalPosition == null ? this.horizontalPosition : this.fixedHorizontalPosition;
    }

    public void setFixedHorizontalPosition(Integer pos) {
        this.fixedHorizontalPosition = pos;
    }

    protected void setHorizontalPosition(int horizontalPosition) {
        this.horizontalPosition = horizontalPosition;
    }

    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    protected void setVerticalPosition(int verticalPosition) {
        this.verticalPosition = verticalPosition;
        this.updateLabel();
    }

    private SankeyFXChart getChart() {
        return (SankeyFXChart)((Object)this.chart.get());
    }

    public void setChart(SankeyFXChart chart) {
        this.chart.set((Object)chart);
    }

    public SankeyFXNode(Node graphic, String name, StringConverter<Double> valueFormatter) {
        this.name.setValue(name);
        this.value = 0.0;
        this.horizontalPosition = 0;
        this.verticalPosition = 0;
        this.valueFormatter = valueFormatter;
        this.setCursor(Cursor.OPEN_HAND);
        this.setOnMousePressed(this.nodeOnMousePressedEventHandler);
        this.setOnMouseDragged(this.nodeOnMouseDraggedEventHandler);
        Group g = new Group(new Node[]{this.label});
        StackPane.setAlignment((Node)g, (Pos)Pos.CENTER);
        this.label.setGraphic((Node)(this.showGraphic() ? graphic : null));
        this.label.setText(name);
        this.showGraphicProperty.addListener(il -> this.label.setGraphic((Node)(this.showGraphic() ? graphic : null)));
        this.rect.heightProperty().addListener((o, ov, nv) -> {
            double height = nv.doubleValue();
            this.label.autosize();
            if (height > this.label.getWidth()) {
                this.label.setRotate(-90.0);
                this.label.setLayoutX(0.0);
                this.label.setLayoutY(0.0);
                this.label.setTextFill((Paint)Color.WHITE);
                g.getChildren().setAll((Object[])new Node[]{this.label});
                this.getChildren().setAll((Object[])new Node[]{new StackPane(new Node[]{this.rect, g})});
            } else {
                this.label.setRotate(0.0);
                this.label.setLayoutX(30.0);
                this.label.setLayoutY((height - 18.0) / 2.0);
                this.label.setTextFill((Paint)Color.BLACK);
                this.getChildren().setAll((Object[])new Node[]{this.rect, this.label});
            }
        });
        this.getChildren().add((Object)new StackPane(new Node[]{this.rect, g}));
    }

    protected void updateLabel() {
        String displayName = this.getName();
        if (this.getChart() != null && this.getChart().isShowLinkValues() && this.getVerticalPosition() == 0) {
            displayName = String.valueOf(displayName) + String.format(" (%s)", this.valueFormatter != null ? this.valueFormatter.toString((Object)this.getValue()) : this.getValue().toString());
        }
        this.label.setText(displayName);
    }

    protected void moveToRight() {
        ++this.horizontalPosition;
    }
}

