/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz;

import de.elpro.ui.fx.charts.xyz.axis.XYZAxes;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZItem;
import de.elpro.ui.fx.charts.xyz.series.XYZItemSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import java.util.Collection;

public class XYZDataViewRange {
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final double minZ;
    private final double maxZ;
    private final double minW;
    private final double maxW;

    public XYZDataViewRange(double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minW, double maxW) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.minW = minW;
        this.maxW = maxW;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinW() {
        return this.minW;
    }

    public double getMaxW() {
        return this.maxW;
    }

    public boolean contains(XYZItem item) {
        return this.minX <= item.getX() && item.getX() <= this.maxX && this.minY <= item.getY() && item.getY() <= this.maxY && this.minZ <= item.getZ() && item.getZ() <= this.maxZ;
    }

    public static XYZDataViewRange compute(XYZAxes axes, Collection<XYZSeries> seriesList, double dataViewMargin) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double minW = Double.POSITIVE_INFINITY;
        double maxW = Double.NEGATIVE_INFINITY;
        for (XYZSeries series : seriesList) {
            XYZDataViewRange areaViewRange;
            if (series instanceof XYZItemSeries) {
                XYZItemSeries itemSeries = (XYZItemSeries)series;
                for (XYZItem item : itemSeries.getItems()) {
                    minX = Double.min(minX, item.getX());
                    maxX = Double.max(maxX, item.getX());
                    minY = Double.min(minY, item.getY());
                    maxY = Double.max(maxY, item.getY());
                    minZ = Double.min(minZ, item.getZ());
                    maxZ = Double.max(maxZ, item.getZ());
                    if (!Double.isFinite(item.getW())) continue;
                    minW = Math.min(minW, item.getW());
                    maxW = Math.max(maxW, item.getW());
                }
                continue;
            }
            if (!(series instanceof XYZAreaSeries) || (areaViewRange = ((XYZAreaSeries)series).getDataViewRange()) == null) continue;
            minX = Double.min(minX, areaViewRange.getMinX());
            maxX = Double.max(maxX, areaViewRange.getMaxX());
            minY = Double.min(minY, areaViewRange.getMinY());
            maxY = Double.max(maxY, areaViewRange.getMaxY());
            minZ = Double.min(minZ, areaViewRange.getMinZ());
            maxZ = Double.max(maxZ, areaViewRange.getMaxZ());
            if (!Double.isFinite(areaViewRange.getMinW())) continue;
            minW = Math.min(minW, areaViewRange.getMinW());
            maxW = Math.max(maxW, areaViewRange.getMaxW());
        }
        if (!(Double.isFinite(minX) && Double.isFinite(maxX) && Double.isFinite(minZ) && Double.isFinite(maxZ) && Double.isFinite(minY) && Double.isFinite(maxY))) {
            return null;
        }
        if (axes.getXAxis().getLowerBound() != null && Double.isFinite(axes.getXAxis().getLowerBound())) {
            minX = Math.min(maxX, axes.getXAxis().getLowerBound());
        }
        if (axes.getXAxis().getUpperBound() != null && Double.isFinite(axes.getXAxis().getUpperBound())) {
            maxX = Math.max(minX, axes.getXAxis().getUpperBound());
        }
        if (axes.getYAxis().getLowerBound() != null && Double.isFinite(axes.getYAxis().getLowerBound())) {
            minY = Math.min(maxY, axes.getYAxis().getLowerBound());
        }
        if (axes.getYAxis().getUpperBound() != null && Double.isFinite(axes.getYAxis().getUpperBound())) {
            maxY = Math.max(minY, axes.getYAxis().getUpperBound());
        }
        if (axes.getZAxis().getLowerBound() != null && Double.isFinite(axes.getZAxis().getLowerBound())) {
            minZ = Math.min(maxZ, axes.getZAxis().getLowerBound());
        }
        if (axes.getZAxis().getUpperBound() != null && Double.isFinite(axes.getZAxis().getUpperBound())) {
            maxZ = Math.max(minZ, axes.getZAxis().getUpperBound());
        }
        if (axes.getWAxis() != null && axes.getWAxis().getUpperBound() != null && Double.isFinite(axes.getWAxis().getUpperBound())) {
            maxW = Math.max(minW, axes.getWAxis().getUpperBound());
        }
        if (axes.getWAxis() != null && axes.getWAxis().getLowerBound() != null && Double.isFinite(axes.getWAxis().getLowerBound())) {
            minW = Math.min(maxW, axes.getWAxis().getLowerBound());
        }
        if (axes.getXAxis().getLowerBound() == null) {
            minX = minX >= 0.0 ? Math.max(0.0, minX - (maxX - minX) * dataViewMargin) : (minX -= (maxX - minX) * dataViewMargin);
        }
        if (axes.getXAxis().getUpperBound() == null) {
            maxX += (maxX - minX) * dataViewMargin;
        }
        if (axes.getYAxis().getLowerBound() == null) {
            minY = minY >= 0.0 ? Math.max(0.0, minY - (maxY - minY) * dataViewMargin) : (minY -= (maxY - minY) * dataViewMargin);
        }
        if (axes.getYAxis().getUpperBound() == null) {
            maxY += (maxY - minY) * dataViewMargin;
        }
        if (axes.getZAxis().getLowerBound() == null) {
            minZ = minZ >= 0.0 ? Math.max(0.0, minZ - (maxZ - minZ) * dataViewMargin) : (minZ -= (maxZ - minZ) * dataViewMargin);
        }
        if (axes.getZAxis().getUpperBound() == null) {
            maxZ += (maxZ - minZ) * dataViewMargin;
        }
        if (axes.getWAxis() != null && axes.getWAxis().getLowerBound() == null) {
            minW = minW >= 0.0 ? Math.max(0.0, minW - (maxW - minW) * dataViewMargin) : (minW -= (maxW - minW) * dataViewMargin);
        }
        if (axes.getWAxis() != null && axes.getWAxis().getUpperBound() == null) {
            maxW += (maxW - minW) * dataViewMargin;
        }
        if (minX == maxX) {
            minX -= 1.0;
            maxX += 1.0;
        }
        if (minY == maxY) {
            minY -= 1.0;
            maxY += 1.0;
        }
        if (minZ == maxZ) {
            minZ -= 1.0;
            maxZ += 1.0;
        }
        if (axes.getWAxis() != null && minW == maxW) {
            minW -= 1.0;
            maxW += 1.0;
        }
        return new XYZDataViewRange(minX, maxX, minY, maxY, minZ, maxZ, minW, maxW);
    }
}

