/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.axis;

import javafx.scene.paint.Color;

public enum ItemColorPolicy {
    SeriesBaseColor,
    WMonoscale,
    WRedToGreen,
    WGreenToRed,
    WRedToBlue,
    WBlueToRed,
    WRGB,
    WBGR;


    public Color mapHpToColor(Color baseColor, double input, double minHealth, double maxHealth) {
        if (this == SeriesBaseColor) {
            return baseColor;
        }
        if (!Double.isFinite(input) || input < minHealth || input > maxHealth) {
            return Color.color((double)0.9, (double)0.9, (double)0.9);
        }
        switch (this) {
            case WMonoscale: {
                double ratio = Math.pow((input - minHealth) / (maxHealth - minHealth), 2.0);
                Color derivedColor = Color.color((double)(1.0 - (1.0 - baseColor.getRed()) * ratio), (double)(1.0 - (1.0 - baseColor.getGreen()) * ratio), (double)(1.0 - (1.0 - baseColor.getBlue()) * ratio));
                return derivedColor;
            }
            case WRedToGreen: 
            case WGreenToRed: 
            case WRedToBlue: 
            case WBlueToRed: {
                double topValue;
                double bottomValue;
                double maxColValue = 1.0;
                double colorMargin = 0.1;
                input -= minHealth;
                maxHealth -= minHealth;
                double thirdValue = 0.0;
                if (input <= maxHealth * colorMargin) {
                    bottomValue = 1.0;
                    topValue = 0.0;
                } else if (input >= maxHealth * (1.0 - colorMargin)) {
                    bottomValue = 0.0;
                    topValue = 1.0;
                } else if (input >= maxHealth * (0.5 - colorMargin / 2.0) && input <= maxHealth * (0.5 + colorMargin / 2.0)) {
                    topValue = 1.0;
                    bottomValue = 1.0;
                } else if (input < maxHealth * 0.5) {
                    bottomValue = 1.0;
                    topValue = (input - maxHealth * colorMargin) / (maxHealth * (0.5 - colorMargin * 1.5));
                } else {
                    bottomValue = (maxHealth * (1.0 - colorMargin) - input) / (maxHealth * (0.5 - colorMargin * 1.5));
                    topValue = 1.0;
                }
                topValue = Math.max(0.0, Math.min(topValue, 1.0));
                bottomValue = Math.max(0.0, Math.min(bottomValue, 1.0));
                if (this == WRedToGreen) {
                    return Color.color((double)(bottomValue * maxColValue), (double)(topValue * maxColValue), (double)(thirdValue * maxColValue));
                }
                if (this == WGreenToRed) {
                    return Color.color((double)(topValue * maxColValue), (double)(bottomValue * maxColValue), (double)(thirdValue * maxColValue));
                }
                if (this == WRedToBlue) {
                    return Color.color((double)(topValue * maxColValue), (double)(thirdValue * maxColValue), (double)(bottomValue * maxColValue));
                }
                return Color.color((double)(bottomValue * maxColValue), (double)(thirdValue * maxColValue), (double)(topValue * maxColValue));
            }
            case WRGB: 
            case WBGR: {
                double topValue;
                double middleValue;
                double bottomValue;
                double maxColValue = 1.0;
                input -= minHealth;
                maxHealth -= minHealth;
                if (input < maxHealth * 0.28) {
                    bottomValue = 1.0;
                    middleValue = input / (maxHealth * 0.28);
                    topValue = 0.0;
                } else if (input >= maxHealth * 0.28 && input < maxHealth * 0.5) {
                    middleValue = 1.0;
                    bottomValue = (maxHealth * 0.5 - input) / (maxHealth * 0.22);
                    topValue = 0.0;
                } else if (input >= maxHealth * 0.5 && input < maxHealth * 0.72) {
                    bottomValue = 0.0;
                    middleValue = 1.0;
                    topValue = (input - maxHealth * 0.5) / (maxHealth * 0.22);
                } else {
                    bottomValue = 0.0;
                    middleValue = (maxHealth - input) / (maxHealth * 0.28);
                    topValue = 1.0;
                }
                topValue = Math.max(0.0, Math.min(topValue, 1.0));
                bottomValue = Math.max(0.0, Math.min(bottomValue, 1.0));
                if (this == WRGB) {
                    return Color.color((double)(bottomValue * maxColValue), (double)(middleValue * maxColValue), (double)(topValue * maxColValue));
                }
                return Color.color((double)(topValue * maxColValue), (double)(middleValue * maxColValue), (double)(bottomValue * maxColValue));
            }
        }
        return null;
    }
}

