/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.axis;

import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.charts.xyz.XYZChart3D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.XYZViewSpace;
import de.elpro.ui.fx.charts.xyz.axis.AxisLegend;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis;
import de.elpro.ui.fx.charts.xyz.axis.XYZAxis3DRenderer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

final class WAxisLegend
extends Group
implements AxisLegend {
    private static final String CSS_FILE = WAxisLegend.class.getResource("xyz-axis-legend.css").toExternalForm();
    private static final double WIDTH = 150.0;
    private static final double MIN_HEIGHT = 200.0;
    private static final double HEADER_HEIGTH = 100.0;
    private static final double RECT_MARGIN = 5.0;
    private static final double TICK_LINE_LENGTH = 5.0;
    private final Label name = new Label();
    private final Label mu = new Label();
    private final VBox header = new VBox(5.0, new Node[]{this.name, this.mu});
    private final Rectangle backgroundRectangle = new Rectangle(150.0, 200.0);
    private final Group legend = new Group();
    private final Group ticks = new Group();
    private final Rectangle colorRect;
    private final XYZChart3D chart;
    private double mouseClickY;
    double prevRectHeight = 0.0;

    public WAxisLegend(XYZChart3D chart) {
        this.chart = chart;
        this.backgroundRectangle.setFill((Paint)Color.TRANSPARENT);
        this.header.setAlignment(Pos.CENTER);
        this.header.setMaxWidth(140.0);
        this.header.setPrefWidth(140.0);
        this.header.setMaxHeight(100.0);
        this.header.setPrefHeight(100.0);
        this.header.setLayoutX(5.0);
        this.header.setLayoutY(5.0);
        this.colorRect = new Rectangle(20.0, 20.0);
        this.prevRectHeight = this.colorRect.getHeight();
        this.legend.getChildren().addAll((Object[])new Node[]{this.colorRect, this.ticks});
        this.getChildren().addAll((Object[])new Node[]{this.backgroundRectangle, this.header, this.legend});
        this.setOnScroll(e -> {
            this.prevRectHeight = -1.0;
            double ratio = (this.colorRect.getHeight() - e.getY()) / this.colorRect.getHeight();
            XYZDataViewRange range = chart.getDataViewRange();
            double minZW = chart.isSwapZWAxes() ? range.getMinZ() : range.getMinW();
            double maxZW = chart.isSwapZWAxes() ? range.getMaxZ() : range.getMaxW();
            double center = (maxZW - minZW) * ratio + minZW;
            double delta = e.getDeltaY() / 300.0;
            double newMinZW = minZW - (center - minZW) * delta;
            double newMaxZW = maxZW + (maxZW - center) * delta;
            XYZAxis zwAxis = chart.isSwapZWAxes() ? chart.getAxes().getZAxis() : chart.getAxes().getWAxis();
            zwAxis.setLowerBound(newMinZW);
            zwAxis.setUpperBound(newMaxZW);
            chart.draw();
        });
        this.setOnMousePressed(e -> {
            this.mouseClickY = e.getY();
            if (e.isMiddleButtonDown()) {
                this.setCursor(Cursor.MOVE);
            }
        });
        this.setOnMouseDragged(e -> {
            double deltaY = e.getY() - this.mouseClickY;
            this.mouseClickY = e.getY();
            if (e.isMiddleButtonDown()) {
                this.prevRectHeight = -1.0;
                XYZDataViewRange range = chart.getDataViewRange();
                double minZW = chart.isSwapZWAxes() ? range.getMinZ() : range.getMinW();
                double maxZW = chart.isSwapZWAxes() ? range.getMaxZ() : range.getMaxW();
                double rangeDelta = (maxZW - minZW) * deltaY / this.colorRect.getHeight();
                XYZAxis zwAxis = chart.isSwapZWAxes() ? chart.getAxes().getZAxis() : chart.getAxes().getWAxis();
                zwAxis.setLowerBound(minZW + rangeDelta);
                zwAxis.setUpperBound(maxZW + rangeDelta);
                chart.draw();
            }
        });
        this.setOnMouseReleased(e -> this.setCursor(null));
        this.getStylesheets().add((Object)CSS_FILE);
        this.getStyleClass().add((Object)"w-axis-legend-container");
    }

    protected void layoutChildren() {
        this.header.autosize();
        double totalHeight = this.backgroundRectangle.getHeight();
        double totalWidth = this.backgroundRectangle.getWidth();
        double legendLayoutX = totalWidth / 2.0 - 20.0;
        double legendLayoutY = 100.0;
        this.legend.setLayoutX(legendLayoutX);
        this.legend.setLayoutY(legendLayoutY);
        this.ticks.setLayoutX(this.colorRect.getWidth());
        double legendHeight = totalHeight - 100.0 - 10.0;
        double colorRectHeight = legendHeight - 10.0;
        if (this.prevRectHeight != colorRectHeight) {
            this.prevRectHeight = colorRectHeight;
            this.colorRect.setHeight(colorRectHeight);
            XYZDataViewRange dataViewRange = this.chart.getDataViewRange();
            double minZW = this.chart.isSwapZWAxes() ? dataViewRange.getMinZ() : dataViewRange.getMinW();
            double maxZW = this.chart.isSwapZWAxes() ? dataViewRange.getMaxZ() : dataViewRange.getMaxW();
            XYZAxis zwAxis = this.chart.isSwapZWAxes() ? this.chart.getAxes().getZAxis() : this.chart.getAxes().getWAxis();
            int tickCount = Math.max(2, (int)colorRectHeight / 35);
            double range = maxZW - minZW;
            if (!Double.isFinite(range)) {
                this.colorRect.setFill((Paint)Color.TRANSPARENT);
                this.ticks.getChildren().clear();
                super.layoutChildren();
                return;
            }
            double tickStep = XYZAxis3DRenderer.getLinearAxisTickStep(range, tickCount);
            double tick = Math.ceil(minZW / tickStep) * tickStep;
            DecimalFormat optimalFormat = NumberFormats.getOptimalShortestFormat((double)tickStep);
            ArrayList<Object> shapes = new ArrayList<Object>();
            while (tick < maxZW) {
                if (tick < minZW) {
                    tick += tickStep;
                    continue;
                }
                double ratio = (tick - minZW) / range;
                double y = colorRectHeight - 1.0 - (colorRectHeight - 1.0) * ratio;
                Line line = new Line(0.0, y, 5.0, y);
                line.setStroke((Paint)this.chart.getItemColorPolicy().mapHpToColor(zwAxis.getColor(), tick, minZW, maxZW));
                shapes.add(line);
                Text text = new Text(optimalFormat.format(tick));
                text.getStyleClass().add((Object)"w-axis-tick-label");
                text.setFont(Font.font(null, (double)9.0));
                text.setLayoutX(10.0);
                text.setLayoutY(y + 3.0);
                shapes.add(text);
                tick += tickStep;
            }
            this.ticks.getChildren().setAll(shapes);
            super.layoutChildren();
        }
    }

    private void updateLabels() {
        this.prevRectHeight = -1.0;
        XYZAxis zwAxis = this.chart.isSwapZWAxes() ? this.chart.getAxes().getZAxis() : this.chart.getAxes().getWAxis();
        this.name.setText(zwAxis.getName());
        this.name.getStyleClass().add((Object)"w-axis-name");
        if (zwAxis.getMeasuringUnit() != null) {
            this.mu.setText(String.format("[%s]", zwAxis.getMeasuringUnit()));
        }
        this.mu.getStyleClass().add((Object)"w-axis-mu");
    }

    @Override
    public void updateLegend(XYZViewSpace viewSpace) {
        this.prevRectHeight = -1.0;
        XYZAxis zwAxis = this.chart.isSwapZWAxes() ? this.chart.getAxes().getZAxis() : this.chart.getAxes().getWAxis();
        Stop[] stops = new Stop[100];
        int i = 0;
        while (i < stops.length) {
            stops[i] = new Stop((double)i / 99.0, this.chart.getItemColorPolicy().mapHpToColor(zwAxis.getColor(), (double)i / 99.0, 0.0, 1.0).deriveColor(1.0, 1.0, 1.0, 0.7));
            ++i;
        }
        this.colorRect.setFill((Paint)new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, stops));
        this.updateLabels();
        this.requestLayout();
    }

    @Override
    public void layoutInChart(double top, double left, double width, double height) {
        double rectangleHeight = Math.max(200.0, height - 30.0 - 30.0);
        this.setLayoutX(width - 150.0);
        this.setLayoutY(top - 30.0);
        this.backgroundRectangle.setHeight(rectangleHeight);
        this.layoutChildren();
    }
}

