/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import javafx.geometry.Point2D;
import javafx.scene.shape.Polygon;

public class XYAreaBounds {
    private Polygon polygon;
    private Point2D[] points;

    public XYAreaBounds(double ... points) {
        this.polygon = new Polygon(points);
        this.points = new Point2D[points.length / 2];
        int i = 0;
        while (i < points.length) {
            this.points[i / 2] = new Point2D(points[i], points[i + 1]);
            i += 2;
        }
    }

    public Point2D[] getPoints() {
        return this.points;
    }

    public Point2D findPoint(Point2D point, double xEpsilon, double yEpsilon) {
        Point2D closestPoint = null;
        double minDistance = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D candidate = point2DArray[n2];
            if (Math.abs(candidate.getX() - point.getX()) <= xEpsilon && Math.abs(candidate.getY() - point.getY()) <= yEpsilon) {
                double distance = Math.sqrt(Math.pow((candidate.getX() - point.getX()) / xEpsilon, 2.0) + Math.pow((candidate.getY() - point.getY()) / yEpsilon, 2.0));
                if (!Double.isInfinite(minDistance) || distance < minDistance) {
                    minDistance = distance;
                    closestPoint = candidate;
                }
            }
            ++n2;
        }
        return closestPoint;
    }

    public double getMinX() {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        double minX = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            minX = Double.isFinite(minX) && Double.isFinite(point.getX()) ? Math.min(minX, point.getX()) : point.getX();
            ++n2;
        }
        return minX;
    }

    public double getMinX(double y) {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        Point2D prevPoint = this.points[this.points.length - 1];
        double minX = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            if (prevPoint.getY() <= y && y <= point.getY() || point.getY() <= y && y <= prevPoint.getY()) {
                double x = prevPoint.getX() + (point.getX() - prevPoint.getX()) * ((y - prevPoint.getY()) / (point.getY() - prevPoint.getY()));
                minX = Double.isFinite(minX) && Double.isFinite(x) ? Math.min(minX, x) : y;
            }
            prevPoint = point;
            ++n2;
        }
        return minX;
    }

    public double getMaxX() {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        double maxX = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            maxX = Double.isFinite(maxX) && Double.isFinite(point.getX()) ? Math.max(maxX, point.getX()) : point.getX();
            ++n2;
        }
        return maxX;
    }

    public double getMaxX(double y) {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        Point2D prevPoint = this.points[this.points.length - 1];
        double maxX = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            if (prevPoint.getY() <= y && y <= point.getY() || point.getY() <= y && y <= prevPoint.getY()) {
                double x = prevPoint.getX() + (point.getX() - prevPoint.getX()) * ((y - prevPoint.getY()) / (point.getY() - prevPoint.getY()));
                maxX = Double.isFinite(maxX) && Double.isFinite(x) ? Math.max(maxX, x) : x;
            }
            prevPoint = point;
            ++n2;
        }
        return maxX;
    }

    public double getMinY() {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        double minY = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            minY = Double.isFinite(minY) && Double.isFinite(point.getY()) ? Math.min(minY, point.getY()) : point.getY();
            ++n2;
        }
        return minY;
    }

    public double getMinY(double x) {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        Point2D prevPoint = this.points[this.points.length - 1];
        double minY = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            if (prevPoint.getX() <= x && x <= point.getX() || point.getX() <= x && x <= prevPoint.getX()) {
                double y = prevPoint.getY() + (point.getY() - prevPoint.getY()) * ((x - prevPoint.getX()) / (point.getX() - prevPoint.getX()));
                minY = Double.isFinite(minY) && Double.isFinite(y) ? Math.min(minY, y) : y;
            }
            prevPoint = point;
            ++n2;
        }
        return minY;
    }

    public double getMaxY() {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        double maxY = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            maxY = Double.isFinite(maxY) && Double.isFinite(point.getY()) ? Math.max(maxY, point.getY()) : point.getY();
            ++n2;
        }
        return maxY;
    }

    public double getMaxY(double x) {
        if (this.points.length < 3) {
            return Double.NaN;
        }
        Point2D prevPoint = this.points[this.points.length - 1];
        double maxY = Double.NaN;
        Point2D[] point2DArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            if (prevPoint.getX() <= x && x <= point.getX() || point.getX() <= x && x <= prevPoint.getX()) {
                double y = prevPoint.getY() + (point.getY() - prevPoint.getY()) * ((x - prevPoint.getX()) / (point.getX() - prevPoint.getX()));
                maxY = Double.isFinite(maxY) && Double.isFinite(y) ? Math.max(maxY, y) : y;
            }
            prevPoint = point;
            ++n2;
        }
        return maxY;
    }

    public void addPoint(Point2D point, double xFactor, double yFactor) {
        if (this.points.length == 0) {
            this.polygon = new Polygon(new double[]{point.getX(), point.getY()});
            this.points = new Point2D[]{new Point2D(point.getX(), point.getY())};
            return;
        }
        if (this.points.length == 1) {
            this.polygon = new Polygon(new double[]{this.points[0].getX(), this.points[0].getY(), point.getX(), point.getY()});
            this.points = new Point2D[]{this.points[0], new Point2D(point.getX(), point.getY())};
            return;
        }
        int insertIndex = -1;
        double closestDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < this.points.length) {
            Point2D candidate1 = this.points[i];
            Point2D candidate2 = this.points[i == this.points.length - 1 ? 0 : i + 1];
            Point2D v1 = new Point2D((point.getX() - candidate1.getX()) / xFactor, (point.getY() - candidate1.getY()) / yFactor);
            Point2D v2 = new Point2D((candidate2.getX() - candidate1.getX()) / xFactor, (candidate2.getY() - candidate1.getY()) / yFactor);
            double l1 = Math.sqrt(Math.pow(v1.getX(), 2.0) + Math.pow(v1.getY(), 2.0));
            double l2 = Math.sqrt(Math.pow(v2.getX(), 2.0) + Math.pow(v2.getY(), 2.0));
            double cosAlpha = (v1.getX() * v2.getX() + v1.getY() * v2.getY()) / (l1 * l2);
            double dl2 = l1 * cosAlpha;
            double hl2 = Math.sqrt(Math.pow(l1, 2.0) - Math.pow(dl2, 2.0));
            if (dl2 < 0.0) {
                hl2 = l1 + Math.abs(dl2) / 1000.0;
            } else if (dl2 > l2) {
                hl2 = Math.sqrt(Math.pow(v1.getX() - v2.getX(), 2.0) + Math.pow(v1.getY() - v2.getY(), 2.0)) + (dl2 - l2) / 1000.0;
            }
            if (hl2 < closestDistance) {
                closestDistance = hl2;
                insertIndex = i;
            }
            ++i;
        }
        Point2D[] newPoints = new Point2D[this.points.length + 1];
        double[] newPointsArray = new double[(this.points.length + 1) * 2];
        int i2 = 0;
        while (i2 < this.points.length) {
            if (i2 <= insertIndex) {
                newPoints[i2] = this.points[i2];
                newPointsArray[i2 * 2] = this.points[i2].getX();
                newPointsArray[i2 * 2 + 1] = this.points[i2].getY();
                if (i2 == insertIndex) {
                    newPoints[i2 + 1] = point;
                    newPointsArray[(i2 + 1) * 2] = point.getX();
                    newPointsArray[(i2 + 1) * 2 + 1] = point.getY();
                }
            } else {
                newPoints[i2 + 1] = this.points[i2];
                newPointsArray[(i2 + 1) * 2] = this.points[i2].getX();
                newPointsArray[(i2 + 1) * 2 + 1] = this.points[i2].getY();
            }
            ++i2;
        }
        this.polygon = new Polygon(newPointsArray);
        this.points = newPoints;
    }

    public void movePoints(Point2D point, Point2D toPoint, double xFactor, double yFactor) {
        this.removePoint(point);
        this.addPoint(toPoint, xFactor, yFactor);
    }

    public void removePoint(Point2D point) {
        int j = 0;
        Point2D[] newPoints = new Point2D[this.points.length - 1];
        double[] newPointsArray = new double[(this.points.length - 1) * 2];
        int i = 0;
        while (i < this.points.length) {
            Point2D p = this.points[i];
            if (!p.equals((Object)point)) {
                newPoints[j] = p;
                newPointsArray[j * 2] = p.getX();
                newPointsArray[j * 2 + 1] = p.getY();
                ++j;
            }
            ++i;
        }
        this.polygon = new Polygon(newPointsArray);
        this.points = newPoints;
    }

    public synchronized boolean contains(Point2D point) {
        return this.polygon.contains(point);
    }

    public synchronized boolean contains(double x, double y) {
        return this.polygon.contains(x, y);
    }
}

