/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.charts.xyz.XYZChart2D;
import de.elpro.ui.fx.charts.xyz.XYZDataViewRange;
import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import de.elpro.ui.fx.charts.xyz.series.XYZAreaSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries;
import de.elpro.ui.fx.charts.xyz.series.XYZSeries2DRenderer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class XYZAreaSeries2DRenderer
implements XYZSeries2DRenderer {
    private int resolution = 100;
    private int isoLines = 10;

    @Override
    public boolean canRender(XYZSeries series) {
        return series instanceof XYZAreaSeries;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public int getIsoLines() {
        return this.isoLines;
    }

    public void setIsoLines(int isoLines) {
        this.isoLines = isoLines;
    }

    @Override
    public void drawXYZSeries(XYZChart2D chart, XYZSeries series, GraphicsContext ctx, XYZChart2D.DrawBounds drawBounds) {
        block24: {
            XYZAreaSeries areaSeries = (XYZAreaSeries)series;
            boolean editArea = areaSeries == chart.getEditAreaSeries();
            ctx.save();
            try {
                ItemColorPolicy zAxisIsolineColorPolicy = chart.getZAxisColorPolicy();
                ItemColorPolicy wAxisIsolineColorPolicy = chart.getWAxisColorPolicy();
                double[] xs = new double[this.resolution + 1];
                double[] ys = new double[this.resolution + 1];
                XYZDataViewRange viewRange = drawBounds.getViewRange();
                int xStep = 0;
                while (xStep <= this.resolution) {
                    xs[xStep] = viewRange.getMinX() + (double)xStep / (double)this.resolution * (viewRange.getMaxX() - viewRange.getMinX());
                    ++xStep;
                }
                int yStep = 0;
                while (yStep <= this.resolution) {
                    ys[yStep] = viewRange.getMinY() + (double)yStep / (double)this.resolution * (viewRange.getMaxY() - viewRange.getMinY());
                    ++yStep;
                }
                double[][][] zws = areaSeries.getZW(xs, ys);
                ctx.save();
                try {
                    ItemColorPolicy areaColorPolicy;
                    int zwIndex;
                    boolean useZ = chart.isDeriveItemColorFromZAxis() || zws[0][0].length == 1;
                    int n = zwIndex = useZ ? 0 : 1;
                    if (useZ) {
                        areaColorPolicy = series.getZAxisColorPolicy() != null ? series.getZAxisColorPolicy() : chart.getZAxisColorPolicy();
                    } else {
                        ItemColorPolicy itemColorPolicy = areaColorPolicy = series.getWAxisColorPolicy() != null ? series.getWAxisColorPolicy() : chart.getWAxisColorPolicy();
                    }
                    if (areaColorPolicy != null) {
                        int x = 0;
                        while (x < xs.length - 1) {
                            int y = 0;
                            while (y < ys.length - 1) {
                                boolean drawRect;
                                double v00 = zws[x][y][zwIndex];
                                double v01 = zws[x][y + 1][zwIndex];
                                double v10 = zws[x + 1][y][zwIndex];
                                double v11 = zws[x + 1][y + 1][zwIndex];
                                double v = (v00 + v01 + v10 + v11) / 4.0;
                                boolean bl = Double.isFinite(v) && (useZ ? viewRange.getMinZ() <= v && v <= viewRange.getMaxZ() : viewRange.getMinW() <= v && v <= viewRange.getMaxW()) ? true : (drawRect = false);
                                if (drawRect) {
                                    Color vColor = areaColorPolicy.mapHpToColor(series.getBaseColor(), v, useZ ? viewRange.getMinZ() : viewRange.getMinW(), useZ ? viewRange.getMaxZ() : viewRange.getMaxW());
                                    ctx.setFill((Paint)new Color(vColor.getRed(), vColor.getGreen(), vColor.getBlue(), 0.3));
                                    Point2D p00 = drawBounds.domainToDraw(new Point2D(xs[x], ys[y]));
                                    Point2D p01 = drawBounds.domainToDraw(new Point2D(xs[x], ys[y + 1]));
                                    Point2D p10 = drawBounds.domainToDraw(new Point2D(xs[x + 1], ys[y]));
                                    Point2D p11 = drawBounds.domainToDraw(new Point2D(xs[x + 1], ys[y + 1]));
                                    ctx.fillPolygon(new double[]{p00.getX(), p01.getX(), p11.getX(), p10.getX()}, new double[]{p00.getY(), p01.getY(), p11.getY(), p10.getY()}, 4);
                                }
                                ++y;
                            }
                            ++x;
                        }
                    }
                }
                finally {
                    ctx.restore();
                }
                int i = 0;
                while (i < this.isoLines) {
                    if (chart.isShowZIsolines()) {
                        double z = viewRange.getMinZ() + (viewRange.getMaxZ() - viewRange.getMinZ()) * ((double)i / (double)(this.isoLines - 1));
                        Color zColor = zAxisIsolineColorPolicy.mapHpToColor(series.getBaseColor(), z, viewRange.getMinZ(), viewRange.getMaxZ());
                        XYZAreaSeries2DRenderer.drawIsoLine(ctx, drawBounds, zColor, xs, ys, zws, z, true);
                    }
                    if (chart.isShowWIsolines()) {
                        double w = viewRange.getMinW() + (viewRange.getMaxW() - viewRange.getMinW()) * ((double)i / (double)(this.isoLines - 1));
                        Color wColor = wAxisIsolineColorPolicy.mapHpToColor(series.getBaseColor(), w, viewRange.getMinW(), viewRange.getMaxW());
                        XYZAreaSeries2DRenderer.drawIsoLine(ctx, drawBounds, wColor, xs, ys, zws, w, false);
                    }
                    ++i;
                }
                if (!editArea || areaSeries.getXYAreaBounds() == null) break block24;
                ctx.save();
                try {
                    ctx.setFill((Paint)Color.WHITE);
                    ctx.setStroke((Paint)Color.DARKORANGE);
                    XYAreaBounds bounds = areaSeries.getXYAreaBounds();
                    int i2 = 0;
                    Point2D[] point2DArray = bounds.getPoints();
                    int n = point2DArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Point2D domainPoint = point2DArray[n2];
                        Point2D drawPoint = drawBounds.domainToDraw(domainPoint);
                        drawPoint.add(drawPoint);
                        if (i2 == 0) {
                            ctx.moveTo(drawPoint.getX(), drawPoint.getY());
                        } else {
                            ctx.lineTo(drawPoint.getX(), drawPoint.getY());
                        }
                        ctx.fillRect(drawPoint.getX() - 3.0, drawPoint.getY() - 3.0, 6.0, 6.0);
                        ctx.strokeRect(drawPoint.getX() - 3.0, drawPoint.getY() - 3.0, 6.0, 6.0);
                        ++i2;
                        ++n2;
                    }
                    ctx.closePath();
                    ctx.stroke();
                }
                finally {
                    ctx.restore();
                }
            }
            finally {
                ctx.restore();
            }
        }
    }

    private static void drawIsoLine(GraphicsContext ctx, XYZChart2D.DrawBounds drawBounds, Color strokeColor, double[] xs, double[] ys, double[][][] zws, double v, boolean useZ) {
        if (zws == null || zws.length < 2 || zws[0].length < 2) {
            return;
        }
        if (!useZ && zws[0][0].length < 2) {
            return;
        }
        ctx.save();
        try {
            LinkedList<Edge> vPoints = new LinkedList<Edge>();
            int xStep = 0;
            while (xStep < xs.length) {
                int yStep = 0;
                while (yStep < ys.length) {
                    if (yStep < ys.length - 1) {
                        Edge edge = Edge.vertEdge(xs, ys, zws, xStep, yStep, v, useZ);
                        if (edge.vPoint != null) {
                            vPoints.add(edge);
                        }
                    }
                    if (xStep < xs.length - 1) {
                        Edge edge = Edge.horzEdge(xs, ys, zws, xStep, yStep, v, useZ);
                        if (edge.vPoint != null) {
                            vPoints.add(edge);
                        }
                    }
                    ++yStep;
                }
                ++xStep;
            }
            ctx.setStroke((Paint)strokeColor);
            LinkedList<IsoPathPart> parts = new LinkedList<IsoPathPart>();
            while (!vPoints.isEmpty()) {
                Edge e = (Edge)vPoints.removeFirst();
                for (Edge edge : vPoints) {
                    boolean drawLine = false;
                    if (e.vertical && edge.vertical) {
                        if (Math.abs(e.xC - edge.xC) == 1 && e.yC == edge.yC) {
                            drawLine = true;
                        }
                    } else if (!e.vertical && !edge.vertical) {
                        if (e.xC == edge.xC && Math.abs(e.yC - edge.yC) == 1) {
                            drawLine = true;
                        }
                    } else if (e.vertical) {
                        if (e.xC == edge.xC && e.yC == edge.yC || e.xC == edge.xC && e.yC == edge.yC - 1 || e.xC == edge.xC + 1 && e.yC == edge.yC || e.xC == edge.xC + 1 && e.yC == edge.yC - 1) {
                            drawLine = true;
                        }
                    } else if (e.xC == edge.xC && e.yC == edge.yC || e.xC == edge.xC && e.yC == edge.yC + 1 || e.xC == edge.xC - 1 && e.yC == edge.yC || e.xC == edge.xC - 1 && e.yC == edge.yC + 1) {
                        drawLine = true;
                    }
                    if (!drawLine) continue;
                    parts.add(new IsoPathPart(e.vPoint, edge.vPoint));
                }
            }
            List<LinkedList<Point2D>> lines = XYZAreaSeries2DRenderer.toLines(parts);
            ctx.setFont(new Font(10.0));
            for (LinkedList linkedList : lines) {
                Point2D currentPoint;
                Point2D firstPoint = null;
                Point2D lastPoint = null;
                ctx.beginPath();
                for (Point2D p : linkedList) {
                    Point2D drawPoint = drawBounds.domainToDraw(p);
                    if (firstPoint == null) {
                        ctx.moveTo(drawPoint.getX(), drawPoint.getY());
                        firstPoint = p;
                        continue;
                    }
                    ctx.lineTo(drawPoint.getX(), drawPoint.getY());
                    lastPoint = p;
                }
                ctx.stroke();
                if (firstPoint == null || lastPoint == null) continue;
                String text = NumberFormats.getOptimalFormat((double)v).format(v);
                double expectedTextLength = 8.0 * ((double)text.length() / 2.0);
                double length = 0.0;
                double textMargin = useZ ? 10 : 40;
                Iterator iterator = firstPoint.getY() < lastPoint.getY() ? linkedList.iterator() : linkedList.descendingIterator();
                Point2D prevPoint = currentPoint = drawBounds.domainToDraw((Point2D)iterator.next());
                while (iterator.hasNext()) {
                    prevPoint = currentPoint;
                    currentPoint = drawBounds.domainToDraw((Point2D)iterator.next());
                    if ((length += Math.sqrt(Math.pow(currentPoint.getX() - prevPoint.getX(), 2.0) + Math.pow(currentPoint.getY() - prevPoint.getY(), 2.0))) >= expectedTextLength / 2.0 + textMargin) break;
                }
                double lengthPart = length - (expectedTextLength / 2.0 + textMargin);
                double pathPartLength = Math.sqrt(Math.pow(currentPoint.getX() - prevPoint.getX(), 2.0) + Math.pow(currentPoint.getY() - prevPoint.getY(), 2.0));
                double pathPartRel = lengthPart / pathPartLength;
                Point2D centerPoint = new Point2D(currentPoint.getX() - (currentPoint.getX() - prevPoint.getX()) * pathPartRel, currentPoint.getY() - (currentPoint.getY() - prevPoint.getY()) * pathPartRel);
                double angle = 180.0 * Math.atan((currentPoint.getY() - prevPoint.getY()) / (currentPoint.getX() - prevPoint.getX())) / Math.PI;
                ctx.save();
                try {
                    ctx.translate(centerPoint.getX(), centerPoint.getY());
                    ctx.rotate(angle);
                    ctx.fillText(text, 0.0 - expectedTextLength / 2.0, -5.0);
                }
                finally {
                    ctx.restore();
                }
            }
        }
        finally {
            ctx.restore();
        }
    }

    private static List<LinkedList<Point2D>> toLines(LinkedList<IsoPathPart> parts) {
        LinkedList<LinkedList<Point2D>> lines = new LinkedList<LinkedList<Point2D>>();
        Point2D p1 = null;
        Point2D p2 = null;
        LinkedList<Point2D> line = null;
        while (!parts.isEmpty()) {
            if (line == null) {
                line = new LinkedList<Point2D>();
                IsoPathPart direction = parts.removeFirst();
                line.add(direction.p1);
                line.add(direction.p2);
                p1 = direction.p1;
                p2 = direction.p2;
            }
            IsoPathPart remove = null;
            for (IsoPathPart part : parts) {
                if (part.p1.equals(p2)) {
                    line.add(part.p2);
                    p2 = part.p2;
                    remove = part;
                    break;
                }
                if (part.p2.equals(p2)) {
                    line.add(part.p1);
                    p2 = part.p1;
                    remove = part;
                    break;
                }
                if (part.p1.equals((Object)p1)) {
                    line.addFirst(part.p2);
                    p1 = part.p2;
                    remove = part;
                    break;
                }
                if (!part.p2.equals((Object)p1)) continue;
                line.addFirst(part.p1);
                p1 = part.p1;
                remove = part;
                break;
            }
            if (remove != null) {
                parts.remove(remove);
                continue;
            }
            lines.add(line);
            line = null;
        }
        if (line != null) {
            lines.add(line);
        }
        return lines;
    }

    private static class Edge {
        private final boolean vertical;
        private final int xC;
        private final int yC;
        private final Point2D vPoint;

        public Edge(Point2D zPoint, int xC, int yC, boolean vertical) {
            this.vPoint = zPoint;
            this.xC = xC;
            this.yC = yC;
            this.vertical = vertical;
        }

        public static Edge vertEdge(double[] xs, double[] ys, double[][][] zws, int xC, int yC, double v, boolean useZ) {
            try {
                Point2D zPoint;
                double p1X = xs[xC];
                double p1Y = ys[yC];
                double value1 = zws[xC][yC][useZ ? 0 : 1];
                double p2Y = ys[yC + 1];
                double value2 = zws[xC][yC + 1][useZ ? 0 : 1];
                if (value1 == v && value2 == v) {
                    zPoint = new Point2D(xs[xC], (p1X + p2Y) / 2.0);
                } else if (value1 <= v && v <= value2 || value1 > v && v > value2) {
                    double yZ = p1Y + (p2Y - p1Y) * ((v - value1) / (value2 - value1));
                    zPoint = new Point2D(xs[xC], yZ);
                } else {
                    zPoint = null;
                }
                return new Edge(zPoint, xC, yC, true);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static Edge horzEdge(double[] xs, double[] ys, double[][][] zws, int xC, int yC, double v, boolean useZ) {
            Point2D zPoint;
            double p1X = xs[xC];
            double value1 = zws[xC][yC][useZ ? 0 : 1];
            double p2X = xs[xC + 1];
            double value2 = zws[xC + 1][yC][useZ ? 0 : 1];
            if (value1 == v && value2 == v) {
                zPoint = new Point2D((p1X + p2X) / 2.0, ys[yC]);
            } else if (value1 <= v && v <= value2 || value1 > v && v > value2) {
                double xZ = p1X + (p2X - p1X) * ((v - value1) / (value2 - value1));
                zPoint = new Point2D(xZ, ys[yC]);
            } else {
                zPoint = null;
            }
            return new Edge(zPoint, xC, yC, false);
        }
    }

    private static class IsoPathPart {
        private final Point2D p1;
        private final Point2D p2;

        public IsoPathPart(Point2D p1, Point2D p2) {
            this.p1 = p1;
            this.p2 = p2;
        }
    }
}

