/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.charts.xyz.series;

import de.elpro.ui.fx.charts.xyz.axis.ItemColorPolicy;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public abstract class XYZSeries {
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<Color> baseColor = new SimpleObjectProperty();
    private final ObjectProperty<ItemColorPolicy> zAxisColorPolicy = new SimpleObjectProperty();
    private final ObjectProperty<ItemColorPolicy> wAxisColorPolicy = new SimpleObjectProperty();
    private final BooleanProperty visible = new SimpleBooleanProperty(true);
    private InvalidationListener il = null;

    public XYZSeries(String name) {
        this.setName(name);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public final ObjectProperty<Color> baseColorProperty() {
        return this.baseColor;
    }

    public final Color getBaseColor() {
        return (Color)this.baseColorProperty().get();
    }

    public final void setBaseColor(Color baseColor) {
        this.baseColorProperty().set((Object)baseColor);
    }

    public final ObjectProperty<ItemColorPolicy> zAxisColorPolicyProperty() {
        return this.zAxisColorPolicy;
    }

    public final ItemColorPolicy getZAxisColorPolicy() {
        return (ItemColorPolicy)((Object)this.zAxisColorPolicyProperty().get());
    }

    public final void setZAxisColorPolicy(ItemColorPolicy zAxisColorPolicy) {
        this.zAxisColorPolicyProperty().set((Object)zAxisColorPolicy);
    }

    public final ObjectProperty<ItemColorPolicy> wAxisColorPolicyProperty() {
        return this.wAxisColorPolicy;
    }

    public final ItemColorPolicy getWAxisColorPolicy() {
        return (ItemColorPolicy)((Object)this.wAxisColorPolicyProperty().get());
    }

    public final void setWAxisColorPolicy(ItemColorPolicy wAxisColorPolicy) {
        this.wAxisColorPolicyProperty().set((Object)wAxisColorPolicy);
    }

    public final boolean isVisible() {
        return this.visibleProperty().get();
    }

    public final void setVisible(boolean visible) {
        this.visibleProperty().set(visible);
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    public void setInvalidationListener(InvalidationListener il) {
        this.il = il;
    }

    public void update() {
        if (this.il != null) {
            this.il.invalidated(null);
        }
    }

    public Node getGraphic() {
        Group graphic = new Group();
        graphic.prefHeight(16.0);
        graphic.prefWidth(16.0);
        Rectangle r = new Rectangle(12.0, 12.0, (Paint)(this.getBaseColor() != null ? this.getBaseColor() : Color.BLACK));
        r.setLayoutX(2.0);
        r.setLayoutY(2.0);
        graphic.getChildren().add((Object)r);
        return graphic;
    }

    public String toString() {
        return this.getName();
    }
}

