/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.perspectiveswitcher.addons;

import de.elpro.ui.fx.perspectiveswitcher.controller.SwitcherController;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class Init {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
            if (!perspectiveStack.isToBeRendered()) {
                return;
            }
            MPerspective selectedElement = (MPerspective)perspectiveStack.getSelectedElement();
            SwitcherController.INSTANCE.selectPerspective(selectedElement);
        }
    };
    private EventHandler perspectivesChangedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
            if (!perspectiveStack.isToBeRendered()) {
                return;
            }
            SwitcherController.INSTANCE.firePerspectivesChangedCallback(perspectiveStack);
        }
    };

    @PostConstruct
    void hookListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectionHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.perspectivesChangedHandler);
    }

    @PreDestroy
    void unhookListeners() {
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.perspectivesChangedHandler);
    }
}

