/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.perspectiveswitcher.parts;

import de.elpro.ui.fx.perspectiveswitcher.controller.SwitcherController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.controlsfx.control.SegmentedButton;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class PerspectiveSwitcherPart {
    @Inject
    private EPartService partService;
    private Group group;

    @Inject
    public void postConstruct(Group group, MWindow window) throws IOException {
        this.group = group;
        List<MPerspectiveStack> stacks = PerspectiveSwitcherPart.getMatchingChildren(window, MPerspectiveStack.class);
        this.group.getChildren().setAll((Object[])new Node[]{this.createSwitcher(stacks)});
        SwitcherController.INSTANCE.addPerspectivesChangedCallback(stack -> this.group.getChildren().setAll((Object[])new Node[]{this.createSwitcher(Arrays.asList(stack))}));
    }

    private Node createSwitcher(List<MPerspectiveStack> stacks) {
        HBox hbox = new HBox(10.0);
        hbox.setId("de-elpro-ui-fx-perspectiveswitcher-box");
        ObservableList tbs = FXCollections.observableArrayList();
        ToggleGroup tg = new ToggleGroup();
        for (MPerspectiveStack perspectiveStack : stacks) {
            for (MPerspective perspective : perspectiveStack.getChildren()) {
                RadioButton rbtn = new RadioButton(perspective.getLocalizedLabel());
                rbtn.getStyleClass().remove((Object)"radio-button");
                rbtn.getStyleClass().add((Object)"toggle-button");
                SwitcherController.INSTANCE.registerPerspective(perspective, (ToggleButton)rbtn);
                String iconUri = perspective.getIconURI();
                if (iconUri != null) {
                    rbtn.setGraphic((Node)new ImageView(iconUri));
                }
                if (perspectiveStack.getSelectedElement() == perspective) {
                    rbtn.setSelected(true);
                    SwitcherController.INSTANCE.selectPerspective(perspective);
                }
                rbtn.setOnAction(e -> this.partService.switchPerspective(perspective));
                tg.getToggles().add((Object)rbtn);
                tbs.add((Object)rbtn);
            }
        }
        SegmentedButton sb = new SegmentedButton(tbs);
        sb.setToggleGroup(tg);
        hbox.getChildren().add((Object)sb);
        return hbox;
    }

    public static <T extends MUIElement> List<T> getMatchingChildren(MElementContainer<?> container, Class<T> type) {
        ArrayList<MUIElement> matchingChildren = new ArrayList<MUIElement>();
        for (Object child : container.getChildren()) {
            if (!type.isInstance(child)) continue;
            matchingChildren.add((MUIElement)child);
        }
        return matchingChildren;
    }

    public static boolean isSelectedElement(MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent.getSelectedElement() == element) {
            if (!(parent instanceof MWindow)) {
                return PerspectiveSwitcherPart.isSelectedElement((MUIElement)parent);
            }
            return true;
        }
        return false;
    }
}

