/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.binding;

import de.elpro.ui.fx.utils.Callback2P;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;

public class Bindings {
    public static ObservableObjectValue<Double> sum(ObservableValue<Double> ... params) {
        return Bindings.sum((Callback<Double, Boolean>)((Callback)d -> true), params);
    }

    public static ObservableObjectValue<Double> sum(Callback<Double, Boolean> filter, ObservableValue<Double> ... params) {
        SimpleObjectProperty sum = new SimpleObjectProperty();
        Runnable computeSum = () -> {
            Double value = null;
            ObservableValue[] observableValueArray2 = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ObservableValue param = observableValueArray2[n2];
                if (param.getValue() != null) {
                    if (value == null && Double.isFinite((Double)param.getValue())) {
                        value = 0.0;
                    }
                    if (Double.isFinite((Double)param.getValue()) && ((Boolean)filter.call((Object)((Double)param.getValue()))).booleanValue()) {
                        value = value + (Double)param.getValue();
                    }
                }
                ++n2;
            }
            sum.set(value);
        };
        InvalidationListener il = o -> computeSum.run();
        computeSum.run();
        ObservableValue<Double>[] observableValueArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ObservableValue<Double> param = observableValueArray[n2];
            param.addListener(il);
            ++n2;
        }
        return sum;
    }

    public static ObservableObjectValue<Double> diff(ObservableValue<Double> arg, ObservableValue<Double> minusArg) {
        SimpleObjectProperty diff = new SimpleObjectProperty();
        Runnable computeDiff = () -> {
            Double value = null;
            if (arg.getValue() != null && Double.isFinite((Double)arg.getValue())) {
                value = (Double)arg.getValue();
            }
            if (minusArg.getValue() != null && Double.isFinite((Double)minusArg.getValue())) {
                if (value == null) {
                    value = 0.0;
                }
                value = value - (Double)minusArg.getValue();
            }
            diff.set(value);
        };
        InvalidationListener il = o -> computeDiff.run();
        computeDiff.run();
        arg.addListener(il);
        minusArg.addListener(il);
        return diff;
    }

    public static ObservableObjectValue<Double> diff(double value, ObservableValue<Double> minusArg) {
        SimpleObjectProperty diff = new SimpleObjectProperty();
        Runnable computeDiff = () -> {
            double dVal = value;
            if (minusArg.getValue() != null && Double.isFinite((Double)minusArg.getValue())) {
                dVal -= ((Double)minusArg.getValue()).doubleValue();
            }
            diff.set((Object)dVal);
        };
        InvalidationListener il = o -> computeDiff.run();
        computeDiff.run();
        minusArg.addListener(il);
        return diff;
    }

    public static ObservableObjectValue<Double> mult(ObservableValue<? extends Number> ... params) {
        SimpleObjectProperty mult = new SimpleObjectProperty();
        Runnable computeMult = () -> {
            Double value = 1.0;
            ObservableValue[] observableValueArray2 = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ObservableValue param = observableValueArray2[n2];
                if (param.getValue() == null || !Double.isFinite(((Number)param.getValue()).doubleValue())) {
                    value = null;
                    break;
                }
                value = value * ((Number)param.getValue()).doubleValue();
                ++n2;
            }
            mult.set((Object)value);
        };
        InvalidationListener il = o -> computeMult.run();
        computeMult.run();
        ObservableValue<? extends Number>[] observableValueArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ObservableValue<? extends Number> param = observableValueArray[n2];
            param.addListener(il);
            ++n2;
        }
        return mult;
    }

    public static ObservableObjectValue<Double> mult(double value, ObservableValue<? extends Number> param) {
        SimpleObjectProperty mult = new SimpleObjectProperty();
        Runnable computeMult = () -> mult.set(param.getValue() != null && Double.isFinite(((Number)param.getValue()).doubleValue()) ? Double.valueOf(((Number)param.getValue()).doubleValue() * value) : null);
        InvalidationListener il = o -> computeMult.run();
        computeMult.run();
        param.addListener(il);
        return mult;
    }

    public static ObservableObjectValue<Double> div(ObservableValue<? extends Number> nummerator, ObservableValue<? extends Number> divisor) {
        SimpleObjectProperty div = new SimpleObjectProperty();
        Runnable computeDiv = () -> {
            Double value = null;
            if (nummerator.getValue() != null && divisor.getValue() != null && Double.isFinite(((Number)nummerator.getValue()).doubleValue()) && Double.isFinite(((Number)divisor.getValue()).doubleValue())) {
                value = ((Number)divisor.getValue()).doubleValue() != 0.0 ? Double.valueOf(((Number)nummerator.getValue()).doubleValue() / ((Number)divisor.getValue()).doubleValue()) : Double.valueOf(Double.NaN);
            }
            div.setValue(value);
        };
        InvalidationListener il = o -> computeDiv.run();
        computeDiv.run();
        nummerator.addListener(il);
        divisor.addListener(il);
        return div;
    }

    public static <S, T> ObservableObjectValue<T> map(ObservableValue<S> observable, Callback<S, T> mapping) {
        SimpleObjectProperty result = new SimpleObjectProperty(mapping.call(observable.getValue()));
        observable.addListener(o -> result.set(mapping.call(observable.getValue())));
        return result;
    }

    public static <P1, P2, R> ObservableObjectValue<R> map(ObservableValue<P1> observable1, ObservableValue<P2> observable2, Callback2P<P1, P2, R> callback) {
        SimpleObjectProperty result = new SimpleObjectProperty(callback.call(observable1.getValue(), observable2.getValue()));
        InvalidationListener il = o -> result.setValue(callback.call(observable1.getValue(), observable2.getValue()));
        observable1.addListener(il);
        observable2.addListener(il);
        return result;
    }

    public static <S, T> ObjectProperty<T> mapBidirectional(ObjectProperty<S> observable, Callback<S, T> mapping, Callback<T, S> reverseMapping) {
        SimpleObjectProperty result = new SimpleObjectProperty(mapping.call(observable.get()));
        observable.addListener(il -> {
            Object newValue = mapping.call(observable.get());
            Object oldValue = result.get();
            if (newValue == null && oldValue != null || newValue != null && oldValue == null || newValue != null && !newValue.equals(oldValue)) {
                result.set(newValue);
            }
        });
        result.addListener(il -> {
            Object newValue = reverseMapping.call(result.get());
            Object oldValue = observable.get();
            if (newValue == null && oldValue != null || newValue != null && oldValue == null || newValue != null && !newValue.equals(oldValue)) {
                observable.set(newValue);
            }
        });
        return result;
    }

    public static ObjectProperty<LocalDateTime> mapBidirectionalToLocalDateTime(ObjectProperty<Instant> observable) {
        return Bindings.mapBidirectional(observable, i -> i != null ? LocalDateTime.ofInstant(i, ZoneOffset.systemDefault()) : null, ldt -> ldt != null ? ldt.atZone(ZoneOffset.systemDefault()).toInstant() : null);
    }

    public static ObservableBooleanValue createHasChangesProperty(ObservableValue<?> ... observables) {
        SimpleBooleanProperty hasChanges = new SimpleBooleanProperty();
        HashMap initialValues = new HashMap();
        ObservableValue<?>[] observableValueArray = observables;
        int n = observables.length;
        int n2 = 0;
        while (n2 < n) {
            ObservableValue<?> observable = observableValueArray[n2];
            initialValues.put(observable, observable.getValue());
            ++n2;
        }
        InvalidationListener check = arg_0 -> Bindings.lambda$19(initialValues, (BooleanProperty)hasChanges, arg_0);
        initialValues.keySet().forEach(o -> o.addListener(check));
        return hasChanges;
    }

    public static ObservableBooleanValue or(ObservableBooleanValue ... params) {
        if (params.length == 0) {
            throw new IllegalArgumentException();
        }
        if (params.length == 1) {
            return params[0];
        }
        ObservableBooleanValue res = params[0];
        int i = 0;
        while (i < params.length) {
            res = javafx.beans.binding.Bindings.or((ObservableBooleanValue)res, (ObservableBooleanValue)params[i]);
            ++i;
        }
        return res;
    }

    public static ObservableBooleanValue and(ObservableBooleanValue ... params) {
        if (params.length == 0) {
            throw new IllegalArgumentException();
        }
        if (params.length == 1) {
            return params[0];
        }
        ObservableBooleanValue res = params[0];
        int i = 0;
        while (i < params.length) {
            res = javafx.beans.binding.Bindings.and((ObservableBooleanValue)res, (ObservableBooleanValue)params[i]);
            ++i;
        }
        return res;
    }

    private static /* synthetic */ void lambda$19(Map map, BooleanProperty booleanProperty, Observable o) {
        boolean changesFound = false;
        for (Map.Entry entry : map.entrySet()) {
            Object initialValue = entry.getValue();
            Object currentValue = ((ObservableValue)entry.getKey()).getValue();
            if (initialValue == null && currentValue == null || initialValue != null && currentValue != null && initialValue.equals(currentValue)) continue;
            changesFound = true;
            break;
        }
        booleanProperty.set(changesFound);
    }
}

