/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import javafx.scene.control.TableCell;

public class DataSizeTableCell<T>
extends TableCell<T, Number> {
    private static final long kiloByte = (long)Math.pow(2.0, 10.0);
    private static final long megaByte = (long)Math.pow(2.0, 20.0);
    private static final long gigaByte = (long)Math.pow(2.0, 30.0);

    public DataSizeTableCell() {
        this.setStyle("-fx-alignment: center-right;");
    }

    protected void updateItem(Number item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null) {
            this.setText(null);
        } else {
            long bytes = item.longValue();
            if (bytes < kiloByte) {
                this.setText(String.format("%,d b", bytes));
            } else if (bytes < megaByte) {
                double val = (double)bytes / (double)kiloByte;
                this.setText(String.format("%.1f Kb", val));
            } else if (bytes < gigaByte) {
                double val = (double)bytes / (double)megaByte;
                this.setText(String.format("%.1f Mb", val));
            } else {
                double val = (double)bytes / (double)gigaByte;
                this.setText(String.format("%.1f Gb", val));
            }
        }
    }
}

