/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import de.elpro.ui.fx.cells.AdjustCellListener;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;

public class InstantTableCell<S>
extends TableCell<S, Instant> {
    private final DateTimeFormatter formatter;
    private final ZoneId atZone;
    private final AdjustCellListener<Instant> onAdjustCell;

    public InstantTableCell(DateTimeFormatter formatter) {
        this(ZoneId.systemDefault(), formatter, null);
    }

    public InstantTableCell(DateTimeFormatter formatter, AdjustCellListener<Instant> onAdjustCell) {
        this(ZoneId.systemDefault(), formatter, onAdjustCell);
    }

    public InstantTableCell(ZoneId atZone, DateTimeFormatter formatter, AdjustCellListener<Instant> onAdjustCell) {
        this.formatter = formatter;
        this.atZone = atZone;
        this.onAdjustCell = onAdjustCell;
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    protected void updateItem(Instant item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.onAdjustCell != null) {
            this.onAdjustCell.adjustCell((Cell<Instant>)this, item);
        }
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            ZonedDateTime zdt = item.atZone(this.atZone);
            this.setText(zdt.format(this.formatter));
        }
    }
}

