/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import de.elpro.ui.fx.controls.IntermediateCheckBox;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class IntermediateCheckBoxTableCell<S, T>
extends TableCell<S, T> {
    private final IntermediateCheckBox checkBox = new IntermediateCheckBox();
    private boolean showLabel;
    private ObservableValue<Boolean> booleanProperty;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>((Object)this, "converter"){

        protected void invalidated() {
            IntermediateCheckBoxTableCell.this.updateShowLabel();
        }
    };
    private ObjectProperty<Callback<Integer, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty((Object)this, "selectedStateCallback");

    public IntermediateCheckBoxTableCell() {
        this(null, null);
    }

    public IntermediateCheckBoxTableCell(Callback<Integer, ObservableValue<Boolean>> getSelectedProperty) {
        this(getSelectedProperty, null);
    }

    public IntermediateCheckBoxTableCell(Callback<Integer, ObservableValue<Boolean>> getSelectedProperty, StringConverter<T> converter) {
        this.getStyleClass().add((Object)"check-box-table-cell");
        this.checkBox.setAllowIndeterminate(true);
        this.setGraphic(null);
        this.setSelectedStateCallback(getSelectedProperty);
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final ObjectProperty<Callback<Integer, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<Integer, ObservableValue<Boolean>> value) {
        this.selectedStateCallbackProperty().set(value);
    }

    public final Callback<Integer, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            ObservableValue<?> obsValue;
            StringConverter<T> c = this.getConverter();
            if (this.showLabel) {
                this.setText(c.toString(item));
            }
            this.setGraphic((Node)this.checkBox);
            if (this.booleanProperty != null) {
                this.checkBox.compositeValueProperty().unbindBidirectional((Property)this.booleanProperty);
            }
            if ((obsValue = this.getSelectedProperty()) != null) {
                this.booleanProperty = obsValue;
                this.checkBox.compositeValueProperty().bindBidirectional((Property)this.booleanProperty);
            }
            this.checkBox.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.getTableView().editableProperty().and((ObservableBooleanValue)this.getTableColumn().editableProperty()).and((ObservableBooleanValue)this.editableProperty()).and((ObservableBooleanValue)new ReadOnlyBooleanWrapper(this.booleanProperty != null))));
        }
    }

    private void updateShowLabel() {
        this.showLabel = this.converter != null;
        this.checkBox.setAlignment(this.showLabel ? Pos.CENTER_LEFT : Pos.CENTER);
    }

    private ObservableValue<?> getSelectedProperty() {
        return this.getSelectedStateCallback() != null ? (ObservableValue)this.getSelectedStateCallback().call((Object)this.getIndex()) : this.getTableColumn().getCellObservableValue(this.getIndex());
    }
}

