/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import java.text.DecimalFormat;
import javafx.scene.control.TreeTableCell;

public class NumberTreeTableCell<S, T extends Number>
extends TreeTableCell<S, T> {
    private final DecimalFormat format;
    private final boolean finiteValues;

    public NumberTreeTableCell(DecimalFormat format) {
        this(format, false);
    }

    public NumberTreeTableCell(DecimalFormat format, boolean finiteValues) {
        this.format = format;
        this.finiteValues = finiteValues;
        this.getStyleClass().add((Object)"number-table-cell");
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else if (this.finiteValues && !Double.isFinite(((Number)item).doubleValue())) {
            this.setText(null);
        } else {
            this.setText(this.format.format(item));
        }
    }
}

