/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells;

import javafx.scene.control.TreeTableCell;

public class PercentTreeTableCell<S>
extends TreeTableCell<S, Double> {
    private final String format;

    public PercentTreeTableCell(String format) {
        this.format = format;
        this.getStyleClass().add((Object)"percent-cell");
    }

    protected void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
        } else {
            this.setText(String.valueOf(String.format(this.format, item * 100.0)) + "%");
        }
    }
}

