/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.editable;

import de.elpro.ui.fx.cells.editable.internal.CellUtils;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.cell.ComboBoxTableCell;

public class DynamicComboBoxTableCell<S, T>
extends ComboBoxTableCell<S, T> {
    protected ComboBox<T> comboBox;
    protected final CreateChoicesCallback<T> choicesCallback;

    public DynamicComboBoxTableCell(CreateChoicesCallback<T> choicesCallback) {
        this.choicesCallback = choicesCallback;
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        if (this.comboBox == null) {
            this.comboBox = CellUtils.createComboBox(this, FXCollections.observableArrayList(this.choicesCallback.createChoises(this.getItem())), this.converterProperty());
            this.comboBox.editableProperty().bind((ObservableValue)this.comboBoxEditableProperty());
        }
        this.comboBox.getSelectionModel().select(this.getItem());
        super.startEdit();
        this.setText(null);
        this.setGraphic((Node)this.comboBox);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellUtils.updateItem(this, this.getConverter(), null, null, this.comboBox);
    }

    public static interface CreateChoicesCallback<T> {
        public Collection<T> createChoises(T var1);
    }
}

